/* vim: set sw=8 ts=8 si : */
/*************************************************************************
Title:    linuxfocus ADC test for autonomous robot
Authors:   guido socher <guido[at]linuxfocus.org>, 
           katja socher <katja[at]linuxfocus.org>
Copyright: GPL
**************************************************************************/
#include <avr/io.h>
#include <avr/pgmspace.h>
#include <avr/interrupt.h>
#include "uart.h"
#include <string.h>
#include <stdlib.h>
#include <avr/signal.h>

/* the green led: */
#define LED2 PD2
/* the red led: */
#define LED1 PB0
static char uart_outbuf[UART_RX_BUFFER_SIZE+1];


static volatile unsigned char adcready;
static volatile unsigned char lowbyte;
static volatile unsigned char highbyte;

/* int = 16 bit */
static unsigned int photo[3];


void delay_ms(unsigned int ms)
/* delay for a minimum of <ms> */
/* with a 4Mhz crystal, the resolution is 1 ms */
{
        unsigned int outer1, outer2;
        outer1 = 200; /* 4 MHZ */
        /* outer1 = 300;  6 MHZ */

        while (outer1) {
                outer2 = 1000;
                while (outer2) {
                        while ( ms ) ms--;
                        outer2--;
                }
                outer1--;
        }
}

SIGNAL(SIG_ADC)
{
	/* this function will be called when the ADC conversion is ready*/
	cbi(PORTD,LED2);
	lowbyte=inp(ADCL);
	highbyte=inp(ADCH);
	adcready=1;
}


void main(void)
{ 
	/*enable led as output */
	sbi(DDRB,LED1);
	sbi(DDRD,LED2);
	
	/* led off */
	sbi(PORTB,LED1);
	sbi(PORTD,LED2);

	/* initialize rs232 */
	uart_init();

	/* enable analog to digital conversion in single run mode
	*  without noise canceler function. See datasheet of at90s4433 page 55 
	* We set ADPS2 and ADPS0 to have a clock division factor of 32.
	* This is needed to stay in the recommended range of 50-200kHz 
	* ADEN: Analog Digital Converter Enable
	* ADIE: ADC Interrupt Enable
	* ADIF: ADC Interrupt Flag
	* ADCSR: ADC Control and Status Register
	* ADPS2..ADPS0: ADC Prescaler Select Bits
	*/
	outp((1<<ADEN)|(1<<ADIE)|(1<<ADIF)|(1<<ADPS2)|(1<<ADPS2),ADCSR);
	sei(); /* enable interrupts */
	
	while (1) {
		/*check the values of the photo resistors */
		
		outp(0,ADMUX); /* photoresistor 0*/
		adcready=0;
		/*  start conversion */
		sbi(ADCSR,ADSC);
		/* wait until conversion ready*/
		while(adcready==0);
		/* combine the lower and higher byte of 
		* the ADC result to one number */
		photo[0]=(highbyte<<8)|lowbyte;
		
		outp(1,ADMUX); /* photoresistor 1*/
		adcready=0;
		/*  start conversion */
		sbi(ADCSR,ADSC);
		/* wait until conversion ready*/
		while(adcready==0);
		/* combine the lower and higher byte of 
		* the ADC result to one number */
		photo[1]=(highbyte<<8)|lowbyte;
		
		outp(2,ADMUX); /* photoresistor 2*/
		adcready=0;
		/*  start conversion */
		sbi(ADCSR,ADSC);
		/* wait until conversion ready*/
		while(adcready==0);
		/* combine the lower and higher byte of 
		* the ADC result to one number */
		photo[2]=(highbyte<<8)|lowbyte;	


		uart_sendstr_P("0: ");
		itoa(photo[0],uart_outbuf,10);
		uart_sendstr(uart_outbuf);
		uart_sendchar('\n');
		
		uart_sendstr_P("1: ");
		itoa(photo[1],uart_outbuf,10);
		uart_sendstr(uart_outbuf);
		uart_sendchar('\n');
		
		uart_sendstr_P("2: ");
		itoa(photo[2],uart_outbuf,10);
		uart_sendstr(uart_outbuf);
		uart_sendchar('\n');
		
		sbi(PORTD,LED2);
		uart_sendchar('\n');
		
		/* led on */
		cbi(PORTB,LED1);
		delay_ms(500);

		/* led off */
		sbi(PORTB,LED1);
		delay_ms(500);
	}
}
