	TITLE	'XSBT -- XS/XR CONTROLLER BUFFER TEST'

;	12-22-80



;   THIS PROGRAM TESTS THE BUFFER MEMORY OF AN "XS" OR "XR"
;   HARD DISK CONTROLLER. A PASS/FAIL INDICATION WILL BE
;   GIVEN TO THE OPERATOR. THIS PROGRAM RUNS UNDER CP/M
;   VERS 1.4 OR HIGHER.




;	---PROGRAM CONFIGURATION---
;
;   THE FOLLOWING STATMENT CONFIGURES THIS PROGRAM FOR
;   YOUR SPECIFIC HARDWARE ENVIRONMENT.
;
;
;	1. S100 -- SET THIS "TRUE" IF YOU ARE USING A CONTROLLER WITH
;	   AN S-100 BUS INTERFACE (XS). SET THIS "FALSE" IF YOU ARE
;	   USING A CONTROLLER WITH A RIBBON CABLE INTERFACE (XR).
;
;
FALSE	EQU	0		;DEFINE FALSE
TRUE	EQU	NOT FALSE	;DEFINE TRUE
;
S100	EQU	TRUE		;S-100 BUS (XS)




;	---LINKS---
;
;
WBOOT	EQU	0		;CPM WARM BOOT
BDOS	EQU	5		;BDOS ENTRY POINT






;	---EQUATES---
;
;
STRT	EQU	100H		;PROGRAM START ADDRESS
;
;   CPM FUNCTION CODES
;
F@CO	EQU	2		;CONSOLE OUTPUT
F@PRT	EQU	9		;PRINT MESSAGES
;
;   CONTROLLER COMMANDS
;
BANK0	EQU	0		;BANK 0
BANK1	EQU	1		;BANK 1
DBENB	EQU	2		;DATA BUFFER
;
;   CONTROLLER I/O
;
CBASE	EQU	70H		;BASE ADR OF THE CONTROLLER
	IF	S100	;IF S-100 BUS INTERFACE
CTCSR	EQU	CBASE+4		;CONTROLLER COMMAND/STATUS
CTBFR	EQU	CBASE+5		;CONTROLLER BUFFER ADDRESS
CTDP	EQU	CBASE+6		;CONTROLLER DATA PORT
	ELSE		;IF RIBBON CABLE INTERFACE
CTCSR	EQU	CBASE+3		;CONTROLLER COMMAND/STATUS
CTBFR	EQU	CBASE+2		;CONTROLLER BUFFER ADDRESS
CTDP	EQU	CBASE+1		;CONTROLLER DATA PORT
	ENDIF
;
;   ASCII CHARACTERS 
;
CR	EQU	0DH
LF	EQU	0AH
BELL	EQU	7




;	---PRINT MACRO---
;
;
PRNT	MACRO	MSG
	LXI	D,MSG		;; ADR OF MSG
	MVI	C,F@PRT		;; FUNCTION CODE
	CALL	BDOS		;; GOT BDOS
	ENDM

	PAGE

	ORG	STRT




;	---PROGRAM ENTRY POINT---
;
;
;
XSBT:	LXI	SP,$
	PRNT	MSG1		;SAY HELLO
	LXI	H,1
	SHLD	SEED		;SET SEED=1 AND PASS=0
;
;   BUFFER MEMORY TEST
;
BMT:	CALL	FILL		;FILL BFR WITH PSEUDO RANDOM DATA
	CALL	TST		;READ BACK & VERIFY BFR CONTENTS
	JNZ	MEMBAD		;JIF BFR TEST FAILED
	LXI	H,SEED
	MOV	C,M
	CALL	RNG		;CHANGE SEED
	MOV	M,C		;  SAVE NEW SEED
	INX	H
	INR	M		;INCR PASS COUNT
	JZ	MEMOK		;JIF TEST DONE (BFR OK)
	MOV	A,M		;A = PASS
	ANI	0FH
	CZ	DOT		;CIF PRINT A PERIOD
	JMP	BMT		;DO NEXT PASS
; MEMORY OK
MEMOK:	PRNT	MSG2		;PRINT OK MSG
	JMP	BAT		;DO BFR ADR TEST
; MEMORY BAD
MEMBAD:	PRNT	MSG3		;PRINT FAIL MESSAGE
;
;   BUFFER ADDRESS TEST
;
BAT:	PRNT	MSG4		; 'BFR ADR TEST'
	MVI	A,DBENB
	OUT	CTCSR		;ENABLE DATA BFR
	XRA	A
	OUT	CTBFR		;INIT BFR ADR
BAT1:	OUT	CTDP		;FILL DATA BFR = INCR CNT
	INR	A
	JNZ	BAT1
;
	LXI	H,0FF01H
	SHLD	SEED		;SET SEED = 1, PASS CNT = 255
	MOV	C,L		;INIT ADR
BAT2:	MVI	B,255		;INIT LOOP CNT
BAT3:	MOV	A,C
	OUT	CTBFR		;SET RANDOM BFR ADR
	IN	CTDP		;PRIME INPUT DATA
	IN	CTDP		;GET BFR DATA
	CMP	C		;DATA SHOULD MATCH ADR
	JNZ	ADRBAD		;JIF TEST FAILED
	CALL	BUMP		;BUMP PARMS
	JNZ	BAT3		;JIF MORE TO DO
	LXI	H,SEED
	MOV	C,M
	CALL	RNG		;ROLL NEW SEED
	MOV	M,C		;  SAVE IT
	INX	H
	DCR	M		;DECR PASS CNT
	JZ	ADROK		;JIF DONE (TEST OK)
	MOV	A,M
	ANI	0FH
	CZ	DOT		;CIF PRINT A PERIOD
	JMP	BAT2		;DO NEXT PASS
; ADR TEST OK
ADROK:	PRNT	MSG5		;SAY OK
	JMP	WBOOT		;EXIT
; ADR TEST FAILED
ADRBAD:	PRNT	MSG6		;WE ARE NOT OK
	JMP	WBOOT		;EXIT





;	---FILL CONTROLLER BUFFER---
;
;
FILL:	CALL	PSET		;SET PARMS
;
FILL1:	MOV	A,M
	OUT	CTCSR		;SLCT BUFFER SEGMENT
	INX	H
	MOV	B,M		;B = SIZE OF BFR SEG
	INX	H
	XRA	A
	OUT	CTBFR		;SET BFR ADR TO ZERO
;
FILL2:	MOV	A,C		;C = PSEUDO RANDOM DATA
	OUT	CTDP		;PUT DATA INTO BFR
	CALL	BUMP		;BUMP PARMS
	JNZ	FILL2
;
	DCR	D		;DECR SEG CNT
	JNZ	FILL1		;JIF FILL ANOTHER SEG
	RET




;	---TEST THE BUFFER---
;
;
TST:	CALL	PSET		;SET PARMS
;
TST1:	MOV	A,M
	OUT	CTCSR		;SELECT BUFFER SEGMENT
	INX	H
	MOV	B,M		;B = SIZE OF SEG
	INX	H
	XRA	A
	OUT	CTBFR		;SET BFR ADR TO ZERO
	IN	CTDP		;PRIME INPUT DATA
;
TST2:	IN	CTDP		;GET DATA FROM BFR
	CMP	C		;C = EXPECTED DATA
	RNZ			;RIF TEST FAILED
	CALL	BUMP		;BUMP PARMS
	JNZ	TST2		;TEST NEXT BYTE
;
	DCR	D		;DDECR SEG CNT
	JNZ	TST1		;JIF TEST ANOTHER SEG
	RET			;EXIT, THIS PASS OK

	PAGE


;	======================================
;	** SUBROUTINES, MESSAGES, & STORAGE **
;	======================================




;	---SET PARAMETERS---
;
;
PSET:	LXI	H,TBL		;SEGMENT TEST TABLE
	MVI	D,3		;SEGMENT COUNT
	LDA	SEED		;INITIAL PSEUDO RANDOM NUMBER
	MOV	C,A
	RET
;
;   SEGMENT TEST TABLE
;
TBL:	DB	BANK0,128
	DB	BANK1,128
	DB	DBENB,0




;	---BUMP PARAMETERS---
;
;
BUMP:	CALL	RNG		;GET NEXT PSEUDO RANDOM NUM
	DCR	B		;DECR LOOP COUNT
	RET




;	---RANDOM NUMBER GENERATOR---
;
;   THIS ROUTINE IS USED TO PRODUCE A PSEUDO RANDOM
;   NUMBER WHICH REPEATS EVERY 255 BYTES. THIS IS
;   USEFULL FOR TESTING PATTERN SENSITIVITY AS WELL
;   AS FINDING BUFFER ADDRESSING PROBLEMS.
;
;
RNG:	MOV	A,C
	RLC
	JNC	RNG1
	XRI	1CH
RNG1:	MOV	C,A
	RET




;	---PRINT A PERIOD---
;
;
DOT:	PUSH	B		;SAVE B/C
	MVI	E,'.'
	MVI	C,F@CO
	CALL	BDOS		;PRINT A PERIOD (.)
	POP	B		;RESTORE B/C
	RET




;	---MESSAGES---
;
;
MSG1:	DB	CR,LF,LF
	IF	S100
	DB	'XSBT'
	ELSE
	DB	'XRBT'
	ENDIF
	DB	' -- Vers 1.1'
	DB	CR,LF,LF
	DB	'Memory Test $'
;
MSG2:	DB	CR,LF,LF
	DB	'Memory Test OK'
	DB	CR,LF,LF,'$'
;
MSG3:	DB	CR,LF,LF
	DB	'Memory Test Failed'
	DB	CR,LF,LF,'$'
;
MSG4:	DB	CR,LF
	DB	'Buffer Address Test $'
;
MSG5:	DB	CR,LF,LF
	DB	'Address Test OK'
	DB	CR,LF,LF,'$'
;
MSG6:	DB	CR,LF,LF
	DB	'Address Test Failed'
	DB	CR,LF,LF,'$'




;	---STORAGE---
;
;
SEED:	DS	1		;RANDOM NUMBER SEED
PASS:	DS	1		;PASS COUNT




	END
