	TITLE	'CDCRWT -- CDC/SMS READ-WRITE TEST'

;	08-03-81



;   'CDCRWT' IS A SIMPLE READ/WRITE TEST DESIGNED TO ENSURE PROPER
;   OPERATION OF AN XCOMP SMS/SMR CONTROLLER WHEN USED WITH A CDC
;   (OR EQUIVALENT) HARD DISK DRIVE.
;
;	* NOTE: HITTING THE "ESC" KEY ABORTS TESTING.




;	---PROGRAM CONFIGURATION---
;
;
;   THE FOLLOWING STATEMENTS ARE USED TO CONFIGURE THE PROGRAM.
;
;	1. TEST - SET THIS 'FALSE' BEFORE USING THE PROGRAM.
;
;	2. ENBINT - SET THIS 'TRUE' IF YOU NEED INTERRUPTS ENABLED
;	   WHILE RUNNING THE PROGRAM. SET THIS 'FALSE' IF YOU DO
;	   NOT USE INTERRUPTS.
;
;	3. S100 - SET THIS 'TRUE' IF YOU ARE USING A CONTROLLER WITH
;	   AN S100 BUS INTERFACE (SMS). SET THIS 'FALSE' IF YOU ARE
;	   USING A CONTROLLER WITH A RIBBON CABLE INTERFACE (SMR).
;
;	4. DTYPE - DEFINES DRIVE TYPE. SET THIS TO A VALUE OF '1' IF
;	   YOU ARE USING A 32 MEG DRIVE. SET THIS TO A VALUE OF '2'
;	   IF YOU ARE USING A 64 MEG DRIVE. SET THIS TO A VALUE OF
;	   OF '3' IF YOU ARE USING A 96 MEG DRIVE.
;
;
FALSE	EQU	0		;DEFINE FALSE
TRUE	EQU	NOT FALSE	;..TRUE
;
TEST	EQU	FALSE		;NOT TESTING
;
ENBINT	EQU	FALSE		;WE DON'T USE INTERRUPTS
;
S100	EQU	TRUE		;S-100 BUS CONTROLLER (SMS)
;
DTYPE	EQU	1		;32 MEG DRIVE




;	---EQUATES---
;
;
STRT	EQU	100H		;PROGRAM START ADDRESS
STACK	EQU	100H		;STACK POINTER
WBOOT	EQU	0		;CPM WARM BOOT
BDOS	EQU	5		;BDOS ENTRY POINT
DEBUG	EQU	0F000H		;DEBUG ENTRY POINT
;
LACE	EQU	20		;FORMAT INTERLACE
RWIL	EQU	3		;READ/WRITE INTERLACE
VOL1	EQU	10H		;VOLUME 1
DATA	EQU	0E5H		;WRITE FILL DATA
RPT	EQU	80H		;REPEAT
INDEX	EQU	10H		;INDEX BIT
;
MAXSEC	EQU	64		;NUMBER OF SECTORS PER TRACK
MAXHD	EQU	DTYPE*2		;NUMBER OF HEADS
MAXCYL	EQU	823		;NUMBER OF CYLINDERS
;
;   CONTROLLER COMMANDS
;
BANK0	EQU	0		;BANK 0 SELECT
BANK1	EQU	1		;BANK 1 SELECT
DBENB	EQU	2		;DATA BUFFER ENABLE
CBENB	EQU	4		;COMPARE BUFFER ENABLE
START	EQU	8		;START COMMAND
;
;   DRIVE COMMANDS/STATUS
;
D@CLR	EQU	10H		;FAULT CLEAR
D@TKZ	EQU	40H		;REZERO
;
D@WP	EQU	40H		;WRITE PROTECT STATUS BIT
;
;   DRIVE TAGS
;
DSTAG	EQU	1		;DRIVE SELECT TAG
TAG1	EQU	2+1		;  TAG1
TAG2	EQU	4+1		;  TAG2
TAG3	EQU	8+1		;  TAG3
;
;   DRIVE/CONTROLLER I/O
;
CBASE	EQU	70H		;BASE ADR OF THE CONTROLLER
	IF	S100	;  ** IF S-100 INTERFACE **
DRCSR	EQU	CBASE		;DRIVE COMMAND/STATUS
CBL	EQU	CBASE+1		;COMMAND BUS, LSB
CBH	EQU	CBASE+2		;  * MSB
DRSB	EQU	CBASE+3		;DRIVE SELECT BITS
CTCSR	EQU	CBASE+4		;CONTROLLER COMMAND/STATUS
CTBFR	EQU	CBASE+5		;CONTROLLER BUFFER ADDRESS
CTDP	EQU	CBASE+6		;CONTROLLER DATA PORT
CLRSEK	EQU	CBASE+7		;CLEAR SEEK END F/F
	ELSE		;  ** IF RIBBON CABLE INTERFACE **
DRCSR	EQU	CBASE+7		;DRIVE COMMAND/STATUS
CBL	EQU	CBASE+6		;COMMAND BUS, LSB
CBH	EQU	CBASE+5		;  * MSB
DRSB	EQU	CBASE+4		;DRIVE SELECT BITS
CTCSR	EQU	CBASE+3		;CONTROLLER COMMAND/STATUS
CTBFR	EQU	CBASE+2		;CONTROLLER BUFFER ADDRESS
CTDP	EQU	CBASE+1		;CONTROLLER DATA PORT
CLRSEK	EQU	CBASE		;CLEAR SEEK END F/F
	ENDIF
;
;   ASCII CHARACTERS 
;
CR	EQU	0DH		;CARRIAGE RETURN
LF	EQU	0AH		;LINE FEED
BELL	EQU	7		;DING!
ESC	EQU	1BH		;ESCAPE KEY
;
;   CPM/MPM FUNCTION CODES
;
F@INZ	EQU	0		;SYSTEM RESET
F@CI	EQU	1		;CONSOLE INPUT
F@CO	EQU	2		;CONSOLE OUTPUT
F@PRNT	EQU	9		;PRINT MESSAGES
F@RCB	EQU	10		;READ CONSOLE BUFFER
F@REQ	EQU	11		;GET CONSOLE STATUS
F@VERS	EQU	12		;GET VERSION NUMBER
F@RSET	EQU	13		;DISK RESET
F@OPNQ	EQU	135		;OPEN QUEUE
F@CRQ	EQU	138		;CONDITIONAL READ QUEUE

	PAGE



;	============
;	** MACROS **
;	============



;	---CALL BDOS---
;
;
CPM	MACRO	FC
	CALL	SYSTEM		;; SYSTEM CALL ROUTINE
	DB	FC		;; CPM FUNCTION CODE
	ENDM




;	---PRINT MESSAGES---
;
;
PRNT	MACRO	MSG
	LXI	D,MSG		;; ADR OF THE MSG
	CPM	F@PRNT		;; PRINT THE MSG
	ENDM

	PAGE

	ORG	STRT	



;	==========================
;	** PROGRAM ENTRY POINT **
;	==========================
;
;
;
BGN:	LXI	SP,STACK	;SET SP
	XRA	A
	OUT	DRCSR		;DESELECT ALL DRIVES
	OUT	CBH	
	OUT	CBL		;CLEAR CMD BUS
	OUT	DRSB		;SLCT DRIVE 0
	INR	A
	OUT	DRCSR		;SET DRIVE SLCT TAG
	PRNT	MSG1		;SAY HELLO
	CALL	BST		;BUILD SECTOR TABLE
;
	MVI	C,F@VERS
	CALL	BDOS		;GET VERSION NUMBER
	MOV	A,H
	STA	MPMFLG		;SAVE CPM/MPM FLAG
	ORA	A
	JZ	LOOP		;JIF RUNNING UNDER CPM.
;
;   RUNNING UNDER MPM. ACQUIRE EXCLUSIVE USE OF
;   THE HARD DISK.
;
ACQ:	CPM	F@RSET		;DISK RESET
	LXI	D,MSG25		;ERROR MSG
	INR	A		;TEST RETURN CODE
	JZ	ACQ1		;ABORT, DISK RESET DENIED
;
	LXI	D,MXDISK
	CPM	F@OPNQ		;OPEN MXDisk QUEUE
	LXI	D,MSG26		;ERROR MSG
	INR	A		;TEST RETURN CODE
	JZ	ACQ1		;ABORT, CAN'T OPEN MXDisk
;
	LXI	D,MXDISK
	CPM	F@CRQ		;CONDITIONAL READ QUEUE
	LXI	D,MSG27		;ERROR MSG
	INR	A		;TEST RETURN CODE
	JNZ	LOOP		;JIF READ OK
; ABORT, CAN'T ACQUIRE DISK
ACQ1:	CPM	F@PRNT		;PRINT ERROR MSG
	MVI	C,F@INZ
	JMP	BDOS		;RESET SYSTEM, ABORT
;
;   COMMAND LOOP
;
LOOP:	LXI	SP,STACK	;RESET SP
	PRNT	MSG2		;PROMPT OPER
	MVI	A,1
	CALL	RCB		;GET OPER CMD
;
	MVI	B,0		;CLEAR MODE INDICATOR
	CPI	'C'
	JZ	CMN		;JIF DO CONTINUOUS TESTING
	INR	B		;INCR MODE FLAG
	CPI	'S'
	JZ	CMN		;JIF DO SINGLE PASS
	CPI	'X'
	JZ	XIT		;JIF EXIT TO CPM
;
;   INVALID INPUT
;
INV:	PRNT	MSG3		;PRINT 'INVALID INPUT'
	JMP	LOOP		;DO NEXT CMD
;
;   EXIT TO CPM
;
XIT:	CALL	CRLF		;DO CR.LF
 	IF	TEST
	JMP	DEBUG		;IF WE ARE TESTING
 	ELSE
	LDA	MPMFLG		;MPM FLAG
	ORA	A
	JZ	WBOOT		;JIF CPM SYSTEM
	MVI	C,F@INZ
	JMP	BDOS		;SYSTEM RESET, EXIT
 	ENDIF




;	---COMMON CODE---
;
;
CMN:	MOV	A,B
	STA	MODE		;SAVE MODE INDICATOR
	PRNT	MSG4		; 'ALL/SINGLE HEAD(S)'
	MVI	A,1
	CALL	RCB		;GET OPER RESPONSE
	CPI	'A'
	JZ	CMN1		;JIF DO ALL HEADS
	CPI	'S'
	JNZ	INV		;JIF INVALID INPUT
;
;   DO A SINGLE HEAD
;
	PRNT	MSG5		; 'HEAD ?'
	XRA	A
	STA	HFLG		;SET FLAG = SINGLE HEAD
	INR	A
	CALL	RCB		;GET HEAD #
	CALL	CONV		;  CONVERT IT
	MOV	A,L
	STA	FIRST		;SAVE FIRST HEAD #
	CPI	MAXHD
	JNC	INV		;JIF INVALID HEAD #
	JMP	CMN2
;
;   DO ALL HEADS
;
CMN1:	XRA	A
	STA	FIRST		;INIT HEAD #
	INR	A
	STA	HFLG		;SET FLAG = ALL HEADS
;
CMN2:	LXI	H,0
	SHLD	PASS		;INIT PASS CNT
	CALL	SRW		;SET READ/WRITE M/CODE
				;  * FALL THRU TO 'WRITE'

	PAGE




;	=============================
;	** FORMAT, WRITE, & VERIFY **
;	=============================




;	---WRITE---
;
;
WRITE:	PRNT	MSG20		; 'WRITE'
	CALL	TKZ		;REZERO THE DRIVE
;
	MVI	A,DBENB
	OUT	CTCSR		;ENB DATA BFR
	XRA	A
	OUT	CTBFR		;INIT BFR ADR
	MOV	B,A		;B = COUNT (256)
	MVI	A,DATA		;DATA PATTERN
WRT1:	OUT	CTDP		;SET WRITE DATA PATTERN
	DCR	B
	JNZ	WRT1
;
WRT2:	CALL	WAT		;WRITE A TRACK
	CALL	NXTK		;GOTO NEXT TRACK
	JC	WRT2		;JIF MORE TO DO
	JMP	READ		;READ/VERIFY DATA
;
;   WRITE A TRACK
;
WAT:	CALL	RWSET		;DO WRITE SETUP
;
WAT1:	CALL	WMS		;WRITE MULTIPLE SECTORS
	CALL	RWNXT		;SETUP FOR NEXT PASS
	JC	WAT1		;JIF MORE TO DO
	RET
;
;   WRITE MULTIPLE SECTORS
;
WMS:	CALL	SBP		;SET BFR PARMS
;
WMS1:	MOV	A,M		;PUT DISK ADR INTO DATA BFR
	OUT	CTDP
	INX	H
	DCR	B
	JNZ	WMS1
;
	CALL	WPTST		;DRIVE WRITE PROTECTED ?  (RIF NO)
	LXI	H,WTBL
	CALL	DORW		;WRITE A SECTOR
	LXI	D,MSG10		; 'WRITE ERROR'
	CNZ	PEM		;CIF HAD WRITE ERROR
	CALL	GNS		;SETUP FOR NEXT SECTOR
	JNZ	WMS		;JIF MORE TO DO
	RET






;	---READ/VERIFY---
;
;
READ:	PRNT	MSG21		; 'READ'
	CALL	TKZ		;REZERO THE DRIVE
;
RD1:	CALL	RAT		;READ A TRACK
	CALL	NXTK		;GOTO NEXT TRACK
	JC	RD1		;JIF MORE TO DO
	JMP	DONE		;ALL DONE
;
;   READ A TRACK
;
RAT:	CALL	RWSET		;READ SETUP
;
RAT1:	CALL	RMS		;READ MULTIPLE SECTORS
	CALL	RWNXT		;SETUP FOR NEXT PASS
	JC	RAT1		;JIF MORE TO DO
	RET
;
;   READ MULTIPLE SECTORS
;
RMS:	LXI	H,RTBL
	CALL	DORW		;READ A SECTOR
	JZ	RMS1		;JIF READ OK
	LXI	D,MSG11		; 'READ ERROR'
	CALL	PEM		;PRINT ERR MSG
	JMP	RMS4
;
RMS1:	CALL	SBP		;SET BFR PARMS
	IN	CTDP		;PRIME INPUT DATA
RMS2:	IN	CTDP		;COMPARE DISK DATA WITH
	CMP	M		;..CURRENT DISK ADDRESS
	JNZ	RMS3		;JIF ERROR
	INX	H
	DCR	B
	JNZ	RMS2
	JMP	RMS4		;COMPARE OK
RMS3:	LXI	D,MSG8		; 'VERIFY ERROR'
	CALL	PEM		;PRINT ERROR MSG
;
RMS4:	CALL	GNS		;SETUP FOR NEXT SECTOR
	JNZ	RMS		;JIF MORE TO DO
	RET




;	---READ/WRITE SETUP---
;
;
RWSET:	LXI	H,SECTBL
	SHLD	TBLADR		;INIT SECT TBL ADR
	MOV	A,M
	STA	SECTOR		;1ST SECTOR FOR READ/WRITE
	XRA	A
	STA	CSS		;INIT START POINT
	RET




;	---SETUP FOR NEXT READ/WRITE PASS---
;
;
RWNXT:	LXI	H,CSS
	INR	M		;INCR CURRENT STARTING POINT
	MOV	A,M
	CPI	RWIL		;READ/WRITE INTERLACE
	RNC			;RIF DONE
	LXI	H,SECTBL	;SECTOR TABLE
	MOV	E,A
	MVI	D,0
	DAD	D		;CALC NEW START POINT
	SHLD	TBLADR		;..SAVE IT
	MOV	A,M
	STA	SECTOR		;INIT 1ST SECTOR ADR
	STC			;SET FLAG = CON'T
	RET




;	---GET NEXT SECTOR---
;
;
GNS:	LHLD	TBLADR		;SECT TBL ADR
	LXI	D,RWIL		;READ/WRITE INTERLACE
	DAD	D		;POINT TO NEXT TABLE ENTRY
	SHLD	TBLADR
	MOV	A,M
	STA	SECTOR		;SAVE NEW SECTOR ADR
	INR	A		;TEST EOT FLAG  (0=DONE)
	RET




;	---PASS DONE---
;
;
DONE:	LDA	MODE		;MODE FLAG
	ORA	A
	JNZ	DN1		;JIF DOING SINGLE PASS
	PRNT	MSG9		; 'PASS = '
	LHLD	PASS
	INX	H		;INCR PASS CNT
	SHLD	PASS
	MOV	A,H
	CALL	BTH		;PRINT PASS CNT, MSB
	MOV	A,L
	CALL	BTH		;   * PRINT LSB
	CALL	CRLF
	JMP	WRITE		;DO NEXT PASS
;
DN1:	PRNT	MSG19		; 'ALL DONE'
	CALL	TKZ		;REZERO THE DRIVE
	JMP	LOOP		;DO NEXT CMD

	PAGE


;	============================
;	** DISK RELATED FUNCTIONS **
;	============================




;	---EXECUTE READ/WRITE COMMANDS---
;
;
DORW:	CALL	RDY		;DRIVE READY ?  (RIF YES)
	MOV	A,M
	OUT	CTCSR		;ENB CMP BFR
	INX	H
	MOV	A,M
	OUT	CTBFR		;SET CMP BFR ADR
	INX	H
;
	XCHG			;D/E = TBL ADR
	LXI	H,CYL
	MVI	B,4
DO1:	MOV	A,M
	OUT	CTDP		;PUT HDR INFO INTO CMP BFR
	INX	H
	DCR	B
	JNZ	DO1
	XCHG			;H/L = TBL ADR
;
	XRA	A
	OUT	CBH
	OUT	CBL		;CLEAR CMD BUS
	MVI	A,TAG3
	OUT	DRCSR		;SET TAG3
	MOV	A,M		;A = CNTL BANK
	INX	H
	MOV	B,A
	OUT	CTCSR		;SLCT CNTL BANK
	MOV	A,M
	OUT	CTBFR		;SET START ADR
	INX	H
	MOV	A,B
	ORI	START
	OUT	CTCSR		;START R/W CMD
;
DO2:	IN	CTCSR		;CTLR STATUS
	RRC
	JNC	DO2		;WAIT FOR DONE
	NOP			;DELAY FOR H/W
	IN	CTCSR		;GET NON-CHANGING STATUS
	MOV	B,A		;   SAVE IT
	XRA	A
	OUT	CTCSR		;STOP CTLR
	INR	A
	OUT	DRCSR		;CLEAR TAG3
	MOV	A,B
	STA	CSTAT		;SAVE CTLR STATUS
	ANA	M		;TEST CTLR STATUS (0=OK)
	MOV	B,A
	IN	DRCSR		;DRIVE STATUS
	STA	DSTAT		;  SAVE IT
	ANI	10H
	CNZ	CLRDF		;CIF CLEAR DRIVE FAULT
	ORA	B		;SET/CLEAR ERROR FLAG (0=OK)
	RET




;	---REZERO---
;
;
TKZ:	CALL	RDY		;DRIVE READY ?  (RIF YES)
	MVI	A,1
	OUT	CLRSEK		;CLEAR SEEK END F/F
	LXI	H,0
	SHLD	CYL		;INIT CYL ADR
	XRA	A
	OUT	CBH
	MVI	A,D@TKZ
	OUT	CBL		;SET CMD BUS = REZERO
	MVI	A,TAG3
	DI			;INHIBIT INTPS
	OUT	DRCSR		;SET TAG3
	MVI	A,DSTAG
	OUT	DRCSR		;CLEAR TAG3
	IF	ENBINT		;IF INTPS ENABLED
	EI
	ENDIF
	CALL	WSC		;WAIT FOR SEEK DONE
	JNZ	TKZ1		;JIF HAD SEEK ERROR
	LDA	FIRST		;FIRST HEAD #
	STA	HEAD		;MAKE CURRENT = 1ST
	CALL	HDSEL		;SLCT 1ST HEAD
	JMP	SEEK		;ENSURE VOLUME CHANGE, EXIT
;
TKZ1:	PRNT	MSG6		; 'REZERO FAILED'
	CALL	PDS		;PRINT DRIVE STATUS
	CALL	CRLF		;DO CR.LF
	JMP	LOOP		;DO NEXT CMD




;	---SEEK---
;
;
SEEK:	MVI	A,1
	OUT	CLRSEK		;CLEAR SEEK END F/F
	LHLD	CYL		;NEW CYL ADR
	MOV	A,H
	OUT	CBH		;SET CYL ADR, MSB
	MOV	A,L
	OUT	CBL		;  * LSB
	MVI	A,TAG1
	DI			;INHIBIT INTPS
	OUT	DRCSR		;SET TAG1
	MVI	A,DSTAG
	OUT	DRCSR		;CLEAR TAG1
	IF	ENBINT		;IF INTPS ENABLED
	EI
	ENDIF
	CALL	WSC		;WAIT FOR SEEK DONE
	RZ			;RIF SEEK OK
	PRNT	MSG7		; 'SEEK FAILED'
	CALL	PDS		;PRINT DRIVE STATUS
	CALL	PCA		;PRINT CYL ADR
	CALL	CRLF		;DO CR.LF
	JMP	LOOP		;DO NEXT CMD




;	---WAIT FOR SEEK COMPLETE---
;
;
WSC:	IN	CTCSR		;CTLR STATUS
	ANI	40H		;SEEK END INTP
	JZ	WSC		;WAIT FOR SEEK DONE
	IN	DRCSR		;DRIVE STATUS
	STA	DSTAT		;  SAVE IT
	ANI	22H		; 'SEEK ERR'  &  'ON CYL'
	XRI	2		;INVERT +ONCYL BIT
	RET			;IF A=0, SEEK OK




;	---NEXT TRACK---
;
;
NXTK:	CALL	STOP		;ABORT TEST ?  (RIF NO)
	LDA	HFLG		;HEAD FLAG
	ORA	A
	JZ	NXT2		;JIF DOING SINGLE HEAD
; MULTIPLE HEADS
	LXI	H,HEAD
	INR	M		;INCR HEAD #
	MOV	A,M
	CPI	MAXHD		;MAX HEAD #
	JNC	NXT1		;JIF START NEW CYL
	CALL	HDSEL		;SLCT NEW HEAD
	JMP	NXT3		;SEEK (ENSURES VOL CHANGE)
;
NXT1:	MVI	M,0		;RESET HEAD #
	CALL	HDSEL		;SLCT HEAD 0
;
NXT2:	LHLD	CYL		;CYL ADR
	INX	H		;  INCR IT
	SHLD	CYL
	MOV	A,L		;TEST FOR END OF DISK
	SUI	MAXCYL AND 0FFH
	MOV	A,H
	SBI	MAXCYL SHR 8
	RNC			;RIF ALL DONE
;
NXT3:	CALL	SEEK		;SEEK TO NEXT CYL
	LDA	CYL		;CYL ADR, LSB
	ANI	0FH
	MOV	B,A
	LDA	HFLG		;HEAD FLAG
	ORA	B
	JZ	NXT4		;JIF SNGL HD & 16TH CYL
	LDA	HEAD		;CURR HEAD #
	ORA	B
	JNZ	NXT5
NXT4:	MVI	E,'.'
	CPM	F@CO		;NOTIFY OPER EVERY 16 CYLS
NXT5:	STC			;SET FLAG = CON'T
	RET




;	---HEAD SELECT---
;
;
HDSEL:	XRA	A
	OUT	CBH		;CLEAR CMD BUS, MSB
	LXI	H,HSTBL
	LDA	HEAD		;LOGICAL HEAD # (0...N)
	CALL	BINDX		;GET VOLUME/HEAD #
	OUT	CBL		;  SET BOTH
	MVI	A,TAG2
	DI			;INHIBIT INTPS
	OUT	DRCSR		;SET TAG2
	MVI	A,DSTAG
	OUT	DRCSR		;CLEAR TAG2
	IF	ENBINT		;IF INTPS ENABLED
	EI
	ENDIF
	RET
;
;   HEAD SELECT TABLE
;
HSTBL:	DB	0		; 0 = V0,H0
	DB	0+VOL1		; 1 = V1,H0
	DB	1+VOL1		; 2 = V1,H1
	DB	2+VOL1		; 3 = V1,H2
	DB	3+VOL1		; 4 = V1,H3
	DB	4+VOL1		; 5 = V1,H4




;	---DRIVE READY TEST---
;
;
RDY:	IN	DRCSR		;DRIVE STATUS
	ANI	9		;'UNIT SLCT'  &  'DRIVE RDY'
	XRI	9		;INVERT BOTH
	RZ			;RIF DRIVE READY
	PRNT	MSG12		;PRINT ERROR MSG
	JMP	LOOP		;DO NEXT CMD




;	---WRITE PROTECT TEST---
;
;
WPTST:	IN	DRCSR		;DRIVE STATUS
	ANI	D@WP		;TEST STATUS BIT
	RZ			;RIF DRIVE NOT PROTECTED
	PRNT	MSG22		;PRINT ERROR MSG
	CALL	PHN		;PRINT HEAD #
	CALL	CRLF		;DO CR.LF
	JMP	LOOP		;ABORT




;	---CLEAR DRIVE FAULT---
;
;
CLRDF:	XRA	A
	OUT	CBH
	MVI	A,D@CLR
	OUT	CBL		;SET CMD BUS = FAULT CLEAR
	MVI	A,TAG3
	DI			;INHIBIT INTPS
	OUT	DRCSR		;SET TAG3
	MVI	A,DSTAG
	OUT	DRCSR		;CLEAR TAG3
	IF	ENBINT		;IF INTPS ENABLED
	EI
	ENDIF
	RET




;	---SET READ/WRITE MICROCODE---
;
;
SRW:	LXI	H,RDCODE
	CALL	SQUIRT		;SET READ M/CODE
	LXI	H,WRTCODE
	JMP	SQUIRT		;SET WRITE M/CODE, EXIT




;	---SET BUFFER PARAMETERS---
;
;
SBP:	MVI	A,DBENB
	OUT	CTCSR		;ENB DATA BFR
	XRA	A
	OUT	CTBFR		;SET BFR ADR = 0
	LXI	H,CYL		;H/L = DISK ADR
	MVI	B,4		;B = LOOP COUNT
	RET




;	---FILL CONTROLLER COMMAND BUFFER---
;
;
SQUIRT:	MOV	A,M
	OUT	CTCSR		;BANK SELECT
	INX	H
	MOV	A,M
	OUT	CTBFR		;SET CTLR BFR ADR
	INX	H
;
SQ1:	MOV	A,M
	ORA	A
	RZ			;RIF DONE
	INX	H		;INCR TBL ADR
	MOV	B,A		;B = COUNT
	RAL
	JC	SQ3		;JIF REPEAT
;
SQ2:	MOV	A,M
	OUT	CTDP		;OUTPUT CONTROL INFO
	INX	H
	DCR	B
	JNZ	SQ2
	JMP	SQ1		;DO NEXT STRING
;
SQ3:	ORA	A		;CLEAR CY
	RAR
	MOV	B,A		;B = COUNT
	MOV	A,M
	INX	H
SQ4:	OUT	CTDP		;OUTPUT REPEAT CONTROL INFO
	DCR	B
	JNZ	SQ4
	JMP	SQ1		;DO NEXT STRING




;	---COMMAND TABLES---
;
;
;   WRITE
;
WTBL:	DB	5		;CMP BFR ENB
	DB	0EAH		;CMP BFR ADR
	DB	BANK1		;CNTL BANK
	DB	0CCH		;START ADR
	DB	0EH		;STATUS MASK
;
;   READ
;
RTBL:	DB	4		;CMP BFR ENB
	DB	0EAH		;CMP BFR ADR
	DB	BANK0		;CNTL BANK
	DB	0CCH		;START ADDRESS
	DB	0EH		;STATUS MASK




;	---WRITE MICROCODE---
;
;
WRTCODE	EQU	$		;  CDC 		07-24-81
;
	DB	1		
	DB	0CCH		
	DB	2,40H		
	DB	41H		
	DB	RPT+16,40H	
	DB	RPT+10,6DH	
	DB	1,63H		
	DB	RPT+4,65H	
	DB	RPT+2,67H	
	DB	2,49H		
	DB	40H		
	DB	RPT+13,50H	
	DB	5,5BH		
	DB	0DDH		
	DB	5DH		
	DB	50H		
	DB	0FH		
	DB	0		





;	---READ MICROCODE---
;
;
RDCODE	EQU	$		;  CDC 		07-24-81
;
	DB	0		
	DB	0CCH		
	DB	2,40H		
	DB	41H		
	DB	RPT+16,40H	
	DB	RPT+10,6DH	
	DB	1,63H		
	DB	RPT+4,65H	
	DB	RPT+2,67H	
	DB	1,49H		
	DB	RPT+3,40H	
	DB	RPT+11,6DH	
	DB	4,63H		
	DB	0E7H		
	DB	67H		
	DB	0FH		
	DB	0		

	PAGE


;	======================================
;	** SUBROUTINES, MESSAGES, & STORAGE **
;	======================================




;	---CALL CPM---
;
;   USED TO GO TO CPM (VIA BDOS) TO PERFORM NON-DISK
;   I/O. ALL REGISTERS (EXCEPT 'A') ARE SAVED & THEN
;   RESTORED AFTER THE FUNCTION IS COMPLETE. THE
;   CALLING SEQUENCE IS ---
;
;	CALL	SYSTEM		;ENTRY POINT
;	DB	FC		;FUNCTION CODE
;
;
SYSTEM:	XTHL			;H/L = ADR OF F.C.
	PUSH	D		;SAVE REGS
	PUSH	B
	MOV	C,M		;C = FUNCTION CODE
	INX	H		;H/L = RETURN ADR
	PUSH	H		;  SAVE IT
	CALL	BDOS		;DO CPM FUNCTION
	POP	H		;RESTORE RETURN ADR
	POP	B		;RESTORE REGS
	POP	D
	XTHL			;STACK = RET ADR
	ORA	A		;SET 8080 FLAGS
	RET




;	---READ CONSOLE BUFFER---
;
;   READS A STRING OF ASCII CHARACTERS. LOWER CASE CHARACTERS ARE
;   TRANSLATED TO UPPER CASE. USES THE CPM 'READ BUFFER' FUNCTION.
;
;
;	ENTRY:	A = INPUT CHARACTER COUNT
;
;	EXIT:	A = FIRST CHARACTER IN THE STRING
;	      D/E = BUFFER ADDRESS OF THE FIRST CHARACTER
;
;
;   ERRORS - - IF AN ERROR OCCURES, 'RCB' IS ABORTED & THE
;	       PROGRAM RESUMES RUNNING AT 'LOOP'.
;
;
RCB:	LXI	D,RDBFR		;READ BFR
	INR	A		;FOR N+1 CHARS
	STAX	D		;SET CHAR COUNT
	MOV	B,A		;..SAVE THE COUNT
	CPM	F@RCB		;READ THE STRING
	CALL	CRLF		;DO CR.LF
	LXI	H,RDBFR+1
	MOV	A,M		;A = INPUT CHAR COUNT
	ORA	A
	JZ	INV		;ERROR, NO CHARS INPUT
	CMP	B		;B = MAX CHAR CNT +1
	JNC	INV		;ERROR, TOO MANY INPUT CHARS
; CONVERT L/C TO U/C
	MOV	B,A		;B = # CHARS TO CONVERT
RCB1:	INX	H		;INCR BFR ADR
	MOV	A,M
	CALL	UCT		;CONVERT
	MOV	M,A
	DCR	B
	JNZ	RCB1
	LXI	D,RDBFR+2	;D/E = ADR OF 1ST CHAR IN STRING
	LDAX	D		;..GET IT
	RET




;	---UPPER CASE TRANSLATION---
;
;   CONVERTS LOWER CASE CHARACTERS TO UPPER CASE.
;
;
UCT:	ANI	7FH		;KILL PARITY BIT
	CPI	61H
	RC			;RIF NOT L/C CHAR
	CPI	7BH	
	RNC			;RIF NOT L/C CHAR
	SUI	20H		;DO CONVERSION
	RET




;	---BUILD SECTOR ADDRESS TABLE---
;
;
BST:	LXI	H,SECTBL	;SECTOR TABLE 
	MVI	B,MAXSEC+RWIL
	MVI	A,-1		;A = SLOT EMPTY FLAG
BST1:	MOV	M,A		;PRE-FILL TABLE
	INX	H
	DCR	B
	JNZ	BST1
;
	LXI	D,0		;INIT TABLE INDEX
	MVI	B,0		;B = REAL SECTOR ADR
BST2:	LXI	H,SECTBL	;BASE ADR OF SECT TBL
	DAD	D		;INDEX INTO TABLE
	MOV	A,M		;A = TABLE ENTRY
	INR	A		;TEST FOR EMPTY SLOT
	JZ	BST3		;JIF STUFF TBL ENTRY
	INR	E		;INCR TBL INDEX
	MOV	A,E
	ANI	3FH		;KILL UNWANTED BITS
	MOV	E,A
	JMP	BST2		;TRY NEXT TABL ENTRY
;
BST3:	MOV	M,B		;PUT SECT ADR INTO TABLE SLOT
	INR	B		;INCR SECTOR ADR
	MOV	A,B
	CPI	MAXSEC		;ARE WE DONE ?
	RNC			;YES, EXIT
	MVI	A,LACE
	ADD	E		;ADD SKEW FACTOR TO TBL INDEX
	ANI	3FH		;KILL UNWANTED BITS
	MOV	E,A
	JMP	BST2		;DO NEXT TBL ENTRY




;	---STOP TEST---
;
;   TEST FOR "ESC". IF FOUND, ABORT FUNCTION.
;
;
STOP:	CPM	F@REQ		;GET CONSOLE STATUS
	RZ			;RIF DATA NOT AVAIL
	CPM	F@CI		;GET INPUT CHAR
	ANI	7FH		;KILL PARITY BIT
	CPI	ESC		;ESCAPE KEY ?
	RNZ			;NO, EXIT
	PRNT	MSG18		; 'FUNCTION ABORTED'
	CALL	PCA		;PRINT CYL ADR
	CALL	PHN		;PRINT HEAD #
	CALL	CRLF		;DO CR.LF
	JMP	LOOP		;ABORT, DO NEXT CMD




;	---CONVERT---
;
;   CONVERTS AN ASCII CHARACTER STRING TO BINARY.
;
;   EXIT:	H/L = BINARY DATA
;
;
;   ERROR:	IF A CONVERSION ERROR IS DETECTED 'CONV' IS
;		ABORTED & THE PROGRAM RESUMES RUNNING AT
;		'LOOP'.
;
;
;
CONV:	LXI	H,RDBFR+1	;READ BFR
	MOV	B,M		;B = INPUT CHAR COUNT
	INX	H
	XCHG
	LXI	H,0
;
CNV1:	LDAX	D		;GET ASCII CHAR
	INX	D		;POINT TO NEXT CHAR IN STRING
	CALL	HTB		;CONVERT TO BINART
	JC	INV		;JIF FOUND NON-HEX CHAR
	DAD	H		;SHIFT H/L LEFT 4   (1 DIGIT)
	DAD	H
	DAD	H
	DAD	H
	ORA	L		; 'OR' IN NEW DIGIT
	MOV	L,A
	DCR	B		;DECR COUNT
	JNZ	CNV1		;JIF NOT DONE
	RET




;	---HEX/BINARY CONVERSION---
;
;   CONVERTS AN ASCII CHARACTER (IN 'A') TO A BINARY DIGIT
;   (RETURNED IN 'A'). THE CARRY IS SET (CY=1) IF A NON-HEX 
;   CHARACTER IS ENCOUNTERED.
;
;
HTB:	ANI	7FH		;KILL PARITY BIT
	SUI	'0'
	RC			;ERROR, CHAR < 0
	CPI	9+1
	CMC
	RNC			;RIF CHAR 0-9
	SUI	7		;MAKES CHARS A-F
	CPI	0AH
	RC			;RIF INVALID CHAR
	CPI	10H		;CHAR > 'F' ?
	CMC
	RET




;	---BINARY/HEX CONVERSION---
;
;   CONVERTS BINARY DATA (IN 'A') TO 2 ASCII
;   HEX CHARACTERS & PRINTS THOSE CHARACTERS.
;
;
BTH:	PUSH	D		;SAVE D/E
	PUSH	PSW
	RRC			;MOVE MSD TO LSD
	RRC
	RRC
	RRC
	CALL	BTH1		;CONVERT MSD & PRINT IT
	POP	PSW
	CALL	BTH1		;  * LSD
	POP	D		;RESTORE D/E
	RET
;
BTH1:	ANI	0FH		;KILL MSD
	ADI	'0'
	CPI	'9'+1
	JC	BTH2		;JIF CHAR 0-9
	ADI	7		;CHAR A-F
BTH2:	MOV	E,A
	CPM	F@CO		;PRINT THE DIGIT
	RET




;	---PRINT ERROR MESSAGE---
;
;
PEM:	CPM	F@PRNT		;PRINT ERROR MSG
	CALL	PDS		;  DRIVE STATUS
	CALL	PCS		;  CTLR STATUS
	CALL	PCA		;  CYL ADR
	CALL	PHN		;  HEAD #
	CALL	PSA		;  SECT ADR
	CALL	CRLF		;DO CR.LF
	JMP	STOP		;ABORT TEST ?




;	---PRINT DRIVE STATUS---
;
;
PDS:	PRNT	MSG13		; 'DST='
	LDA	DSTAT
	JMP	BTH		;PRINT STATUS, EXIT




;	---PRINT CONTROLLER STATUS---
;
;
PCS:	PRNT	MSG14		; 'CST='
	LDA	CSTAT
	JMP	BTH		;PRINT STATUS, EXIT




;	---PRINT CYLINDER ADDRESS---
;
;
PCA:	PRNT	MSG15		; 'CYL='
	LHLD	CYL
	MOV	A,H
	CALL	BTH1		;PRINT MS DIGIT OF CYL ADR
	MOV	A,L
	JMP	BTH		;LAST 2 DIGITS, EXIT




;	---PRINT HEAD NUMBER---
;
;
PHN:	PRNT	MSG16		; 'HD='
	LDA	HEAD
	JMP	BTH1		;PRINT HEAD #, EXIT




;	---PRINT SECTOR ADDRESS---
;
;
PSA:	PRNT	MSG17		; 'SECT='
	LDA	SECTOR
	JMP	BTH		;PRINT ADR, EXIT




;	---CARRIAGE RETURN, LINE FEED---
;
;
CRLF:	PUSH	D		;SAVE D/E
	MVI	E,CR
	CPM	F@CO
	MVI	E,LF
	CPM	F@CO
	POP	D		;RESTORE D/E
	RET




;	---BYTE WIDE INDEX---
;
;
BINDX:	PUSH	D		;SAVE D/E
	MOV	E,A		;A = ENTRY #
	MVI	D,0
	DAD	D		;INDEX INTO TBL
	MOV	A,M		;A = TABLE ENTRY
	POP	D		;RESTORE D/E
	RET




;	---MESSAGES---
;
;
MSG1:	DB	CR,LF,LF,LF
	DB	'CDCRWT -- Vers 1.0		3-Aug-81',CR,LF,'$'
;
MSG2:	DB	CR,LF,LF
	DB	'Select one of the following Options ---',CR,LF,LF
	DB	'  C = Continuous testing',CR,LF
	DB	'  S = Single pass',CR,LF
	DB	'  X = Exit to CPM',CR,LF,LF
	DB	'Option? $'
;
MSG3:	DB	BELL,CR,LF
	DB	'* Invalid input'
	DB	CR,LF,'$'
;
MSG4:	DB	CR,LF
	DB	'Do want to do ALL heads or just a SINGLE head (A/S)? $'
;
MSG5:	DB	CR,LF,'Head (0...n)? $'
;
MSG6:	DB	BELL,CR,LF,'* REZERO failed  $'
;
MSG7:	DB	BELL,CR,LF,'* SEEK failed  $'
;
MSG8:	DB	CR,LF,'Verify Error  $'
;
MSG9:	DB	CR,LF,LF,'Pass = $'
;
MSG10:	DB	BELL,CR,LF,'* Write Error  $'
;
MSG11:	DB	BELL,CR,LF,'* Read Error  $'
;
MSG12:	DB	BELL,CR,LF,'* Drive not ready',CR,LF,'$'
;
MSG13:	DB	'  DST=$'
;
MSG14:	DB	'  CST=$'
;
MSG15:	DB	'  Cyl=$'
;
MSG16:	DB	'  Hd=$'
;
MSG17:	DB	'  Sect=$'
;
MSG18:	DB	BELL,CR,LF,LF,'* Function aborted  $'
;
MSG19:	DB	CR,LF,LF,'Testing finished',CR,LF,'$'
;
MSG20:	DB	CR,LF,LF,'Write $'
;
MSG21:	DB	CR,LF,LF,'Read  $'
;
MSG22:	DB	BELL,CR,LF,LF
	DB	'* Write Protected Drive$'
;
MSG25:	DB	BELL,CR,LF,LF
	DB	'* Disk Reset Denied'
	DB	CR,LF,LF,'$'
;
MSG26:	DB	BELL,CR,LF,LF
	DB	'* Can''t Open MXdisk'
	DB	CR,LF,LF,'$'
;
MSG27:	DB	BELL,CR,LF,LF
	DB	'* Can''t Read MXDisk'
	DB	CR,LF,LF,'$'




;	---STORAGE---
;
;
PASS:	DS	2		;PASS COUNT
MODE:	DS	1		;MODE INDICATOR
HFLG:	DS	1		;HEAD FLAG
FIRST:	DS	1		;FIRST HEAD NUMBEER
CYL:	DS	2		;CYLINDER ADDRESS
HEAD:	DS	1		;HEAD NUMBER
SECTOR:	DS	1		;SECTOR ADDRESS
CSTAT:	DS	1		;CONTROLLER STATUS
DSTAT:	DS	1		;DRIVE STATUS
CSS:	DS	1		;CURRENT STARTING SECTOR
MPMFLG:	DS	1		;MPM FLAG
;
MXDISK:	DS	2		;MXDisk QUEUE CONTROL BLOCK
	DW	0
	DB	'MXDisk  '
;
RDBFR:	DS	10		;CONSOLE READ BUFFER
;
TBLADR:	DS	2		;TABLE ADDRESS
SECTBL:	DS	MAXSEC+RWIL	;SECTOR TABLE



LAST	EQU	$		;DEFINES END OF PROGRAM



	END
