#

 /* unix 370 link editor */

#define	NSYM	400
#define	NFILES	40
#define	bytes	1
#ifndef unix
#define	words	4
#endif
#ifdef unix
#define	words	2
#endif

struct filtab {
	int text;
	int textsize;
	int textaddr;
	int data;
	int datasize;
	int dataaddr;
	int bsssize;
	int bssaddr;
	int prld;
	int rldsize;
	int *symtran;
} filtab[NFILES], *fp, *lfp;

#define	ASCIIE	0105
char ASCEND[]	{0105, 0116, 0104, 0};
char ASCEDATA[]	{0105, 0104, 0101, 0124, 0101, 0};
char ASCETEXT[]	{0105, 0124, 0105, 0130, 0124, 0};

/* define symbol types */
#define	TEXT	1
#define	DATA	2
#define	BSS	3
#define	ABS	4
#define	PSREG	5
#define	WEXTERN	010
#define	SEXTERN	011
#define	COMMON	012
#define	EXTDISP	014	/* external displacement - not yet implemented */

struct rld {
	char flag;
	char loc[1]; char loc1; char loc2;
	char sym[2];
};

struct eesd {
	char name[8];
	char type;
	char addr[1]; char addr1; char addr2;
} eesd;

struct iesd {
	char name[8];
	char type;
	int value;
	int reloc;
	int filp;
} *symtab;

int gsymtran[NSYM];

int text, data, bss, rldsize;
int od;
int totsym;
int relocflg, comflg, locflg;
int verflg;

#define	MAGIC1	010774000040

struct {
	char magic[4];
	char tsize[4];
	char dsize[4];
	char bsize[4];
	char rsize[4];
	char esize[2];
	char lsize[1]; char lsize1;
	char free[8];
} header;


main(argc, argv)
char **argv;
{
	fp = filtab;
	symtab = calloc(NSYM, sizeof(*symtab));
	clear(symtab, NSYM*sizeof(*symtab));
	od = copen("AOUT", 'w');
	rldsize = text = data = bss = 0;
	while(--argc) {
		argv++;
		if(**argv == '-') {
			switch(*++*argv) {

			case 'r':
			case 'R':
				relocflg++;	/* preserve reloc info */
				break;

			case 'd':
			case 'D':	/* force definition of common storage */
				comflg++;
				break;

			case 'l':
			case 'L':
				locflg++; /*preserve local symbols */
				break;

			case 'v':
			case 'V':
				verflg++;	/* verbose */
				break;

			default:
				printf("bad switch\n");
				cexit(1);
			}
		} else {
			paout(*argv);
		}
	}
	finish();
	if(verflg) printsyms();
	cexit(0);
}

paout(file)
char *file;
{
	int id;
	register struct iesd *s;
	register int *q, n;
	extern int urnleft;

	if (fp >= &filtab[NFILES]) {
		printf("Too many files; Maximum is %d\n",NFILES);
		cexit(12);
	}
	urnleft = 0;
	id = copen(file,'r');
	uread(id, &header, sizeof header);
	if(out2(&header.magic[2]) != MAGIC1) {
		printf("bad format a.out file: %s\n", file);
		cexit(1);
	}

	fp->textaddr = text;
	if(fp->textsize = out4(header.tsize)) {
		fp->text = calloc(fp->textsize, bytes);
		uread(id, fp->text, fp->textsize);
		text =+ fp->textsize;
	}

	fp->dataaddr = data;
	if(fp->datasize = out4(header.dsize)) {
		fp->data = calloc(fp->datasize, bytes);
		uread(id, fp->data, fp->datasize);
		data =+ fp->datasize;
	}

	fp->bsssize = out4(header.bsize);
	bss =+ fp->bsssize;
	if(fp->rldsize = out4(header.rsize)) {
		fp->prld = calloc(fp->rldsize, bytes);
		uread(id, fp->prld, fp->rldsize);
		rldsize =+ fp->rldsize;
	}

	n = out2(header.esize)/sizeof eesd;
	q = fp->symtran = calloc(n, words);
	clear(q, n*words);

	while(n--) {
		uread(id, &eesd, sizeof eesd);
		*q++ = s = lookup();
		if(s->type == 0) {	/* previously undeclared */
			s->value = out3(eesd.addr);
			s->type = eesd.type;
			s->filp = fp;
		} else {	/* otherwise check for conflicts */
			mergesym(&eesd, s, file);
		}
	}

	/* for now we ignore local symbols */
	fp++;
	cclose(id);
 /**/
}

mergesym(new, old, file)
struct iesd *old;
struct eesd *new;
char *file;
{
	if(old->type > PSREG) {
	if(new->type > PSREG) {
		/* both undefined - decide who wins */
		if(new->type > old->type) {
			old->type = new->type;
			old->value = out3(new->addr);
		}
	} else {
		/* new is defined and old is undefined */
		old->type = new->type;
		old->value = out3(new->addr);
		old->filp = fp;
	}} else {
	if(new->type > PSREG) {
		/* new is undefined & old is defined */
		/* do nothing */
	} else {
		/* both defined - allowed only if both are absolute with same value */
		if(new->type != ABS || old->type != ABS
			|| out3(new->addr) != old->value) {
			printf("Multiply Defined Symbol ");
			pname(old->name);
			printf("in file %s\n", file);
		}
	}}
}

finish()
{
	register char *p;
	register struct iesd *s;
	register int c;
	int n;
	int newloc;
	int r;

	/* now that everything is in core link it all together */

	lfp = fp;
	buildst();	/* build symbol number translation table & relocate symbols */
	if(relocflg == 0 || comflg)
		defcom();	/* define common storage */
	if(relocflg == 0)
		pundef();	/* print undefined symbols */

	for(fp=filtab; fp<lfp; fp++) {
		for(p = fp->prld; p<fp->prld+fp->rldsize;) {
			/* compute segment of address constant */
			n = out3(p->loc);
			c = TEXT;
			if(n>= fp->textsize) {
				c++;
				n =- fp->textsize;
				if(n >= fp->datasize) {
					printf("address constants not permitted in bss segment\n");
					continue;
				}
			}

			if(c == TEXT) {
				newloc = fp->textaddr+n;
				n =+ fp->text;
			} else {
				newloc = text + fp->dataaddr - fp->textsize + n;
				n =+ fp->data;
			}
			in3(p->loc, newloc);

			if(p->flag&03) {
				switch(p->flag&03) {

				case TEXT:
					r = fp->textaddr;
					break;

				case DATA:
					r = text + fp->dataaddr - fp->textsize;
					break;

				case BSS:
					r = text + data + fp->bssaddr - fp->textsize - fp->datasize;
				}
				reloc(n, p->flag>>2, r);
				p =+ 4;
			} else {
				/* external */
 /*
 printf("stype=%o,pflag=%o,sval=%x\n",s->type,p->flag,s->value);
 /**/
				s = fp->symtran[out2(p->sym)];
				in2(p->sym, gsymtran[s - symtab]);
				if(s->type <= PSREG) {
					/* symbol is defined
					 * relocate & change (text, data, bss)
					 * or delete (abs) rld entry, but flag it
					 * so output routine won't choke on gap
					 */
					if(s->type == ABS) {
						reloc(n, p->flag>>2, s->value);
						p->flag = 0200; /* deleted 6-byte rld entry */
						rldsize =- 6;
					} else {
						reloc(n, p->flag>>2, s->value);
						p->flag =| 0200 + (s->type&03);
						rldsize =- 2;
					}
				}
				p=+ 6;
			}
		} /* end of for */
	} /* end of other for */

	in4(header.tsize, text);
	in4(header.dsize, data);
	in4(header.bsize, bss);
	in4(header.rsize, relocflg? rldsize : 0);
	in2(header.esize, totsym*sizeof eesd);

	uwrite(od, &header, sizeof header);
	for(fp=filtab; fp<lfp; fp++) {
		if(fp->textsize) {
			uwrite(od, fp->text, fp->textsize);
		}
	}

	for(fp=filtab; fp<lfp; fp++) {
		if(fp->datasize) {
			uwrite(od, fp->data, fp->datasize);
		}
	}


	if(relocflg) {
		for(fp = filtab; fp<lfp; fp++) {
			p = fp->prld;
			for(n=p+fp->rldsize; p<n; p =+ 6) {
				if(p->flag == 0200) {
					continue;
				}
				if(p->flag&0200) {
					p->flag =& ~0200;
					uwrite(od, p, 4);
				} else {
					if(p->flag&03) {
						uwrite(od, p, 4);
						p =- 2;
					} else {
						uwrite(od, p, 6);
					}
				}
			}
		}
	}

	for(s=symtab; s<&symtab[NSYM]; s++) {
		if(s->type) {
			move(s, &eesd, 9);
			in3(eesd.addr, s->value);
			uwrite(od, &eesd, sizeof eesd);
		}
	}
	uclose(od);
}

defcom()	/* routine to define common areas */
{
	register n;
	register struct iesd *s;
	for(s = symtab; s< &symtab[NSYM]; s++) {
		if(s->type == COMMON) {
			s->type = BSS;
			n = s->value;
			s->value = bss;
			bss =+ n;
		}
	}
}

buildst()	/* routine to build symbol number translation table */
		/* and relocate symbols */
{
	register i;
	register struct iesd *s;
	i = 0;
	for(s = symtab; s<&symtab[NSYM]; s++) {
		if(s->type) {
			gsymtran[s-&symtab[0]] = i;
			i++;
			if((fp = s->filp) && s->type < ABS) {
				switch(s->type) {

				case TEXT:
					s->value =+ fp->textaddr;
					break;

				case DATA:
					s->value =+ text + fp->dataaddr - fp->textsize;
					break;

				case BSS:
					s->value =+ text + data + fp->bssaddr - fp->textsize - fp->datasize;
				}
			}
		}
	}
	totsym = i;
}

pundef()	/* check for undefined symbols and complain */
{
	register uflg;
	register struct iesd *s;

	uflg = 0;
	for(s = symtab; s< &symtab[NSYM]; s++) {
		if(s->type == SEXTERN) {
			if(s->name[0] == ASCIIE) {
				if(cmp(s->name, ASCEND, 4)) {
					s->value = text + data + bss;
					s->type = BSS;
					continue;
				}
				if(cmp(s->name, ASCEDATA, 6)) {
					s->value = text + data;
					s->type = DATA;
					continue;
				}
				if(cmp(s->name, ASCETEXT, 6)) {
					s->value = text;
					s->type = TEXT;
					continue;
				}
			}
			if(uflg == 0) {
				printf("undefined:\n");
				uflg++;
			}
			pname(s->name);
			printf("\n");
		}
	}
	if(uflg) {
		printf("\n");
	}
}

struct iesd *lookup()
{
	register struct iesd *s;
	register char *p, *q;
	int i;
	static	symcount;

 /*
 /*
 printf("lookup %.8s ", eesd.name);
 /**/
	i = 0;
	for(p = eesd.name; p<&eesd.name[8];)
		i = (i<<1) + *p++;
	for(s = &symtab[(i&077777)%NSYM]; s->type != 0;) {
		q = s->name;
		for(p = eesd.name; p< &eesd.name[8];)
			if(*p++ != *q++)
				goto next;
/*
 printf("old %o\n", s);
 /**/
		return(s);

	next:
		if(++s >= &symtab[NSYM])
			s = symtab;
	}
	if (++symcount >= NSYM) {
		printf("Too many symbols; Maximum is %d\n",NSYM-1);
		cexit(12);
	}
	q = s->name;
	for(p = eesd.name; p< &eesd.name[8]; *q++ = *p++);
 /*
 printf("new %o\n", s);
 /**/
	return(s);
}

reloc(loc, flag, off)
{
	if(flag&04) off = -off;
	switch(flag&03) {

	case 1:
		return(in2(loc, out2(loc) + off));

	case 2:
		return(in3(loc, out3(loc) + off));
	}
	return(in4(loc, out4(loc) + off));
}

#include	"uio.c"

char *typetab[] {
	"illegal", "text   ", "data   ",
	"bss", "abs", "psreg", "illegal", "illegal",
	"wextern", "sextern", "common"
};
printsyms()
{
	struct iesd *s;
	int *j, *w;
	int tem;
	register i;

	i=0;
	w = calloc(totsym, words);
	for(s = symtab; s<&symtab[NSYM]; s++)
		if(s->type) w[i++] = s;

	for(i=totsym-1; i; i--) {
		for(j = w; j < w+i; j++) {
			if((*j)->value > (*(j+1))->value) {
				tem = *j;
				*j = *(j+1);
				*(j+1) = tem;
			}
		}
	}

	for(j = w; j < w+totsym; j++) {
		pname((*j)->name);
		printf(" %s %x\n", typetab[(*j)->type], (*j)->value);
	}
}

pname(name)
char *name;
{
#ifdef unix
	printf("%.8s", name);
#endif
#ifndef unix
	register i;
	extern char atetab[];
	for(i=0; i<8; i++) {
		if(*name) putchar(atetab[*name++]);
		else putchar(' ');
	}
#endif
}

cmp(a, b, n)
char *a, *b;
{
	while(n--)
		if(*a++ != *b++) return(0);
	return(1);
}


#ifdef unix
#include "uutil.c"
#endif
#ifndef unix
#include "iutil.c"
#endif

clear(a, i)
char *a;
{
	while(i--) *a++ = 0;
}
