/** @file
  64-bit Math Worker Function.
  The 32-bit versions of C compiler generate calls to library routines
  to handle 64-bit math. These functions use non-standard calling conventions.

  Copyright (c) 2009 - 2011, Intel Corporation. All rights reserved.<BR>
  This program and the accompanying materials are licensed and made available
  under the terms and conditions of the BSD License which accompanies this
  distribution.  The full text of the license may be found at
  http://opensource.org/licenses/bsd-license.php.

  THE PROGRAM IS DISTRIBUTED UNDER THE BSD LICENSE ON AN "AS IS" BASIS,
  WITHOUT WARRANTIES OR REPRESENTATIONS OF ANY KIND, EITHER EXPRESS OR IMPLIED.

**/

#include <Library/BaseLib.h>


/*
 * Divides a 64-bit signed value by another 64-bit signed value and returns
 * the 64-bit signed result and the 64-bit signed remainder.
 */
__declspec(naked) void __cdecl _alldvrm(void)
{
  //
  // Wrapper Implementation over EDKII DivS64x64Remainder() routine
  //    INT64
  //    EFIAPI
  //    DivS64x64Remainder (
  //      IN      INT64     Dividend,
  //      IN      INT64     Divisor,
  //      OUT     INT64     *Remainder
  //      )
  //
  _asm {
    ; Original local stack when calling _alldvrm
    ;               -----------------
    ;               |               |
    ;               |---------------|
    ;               |               |
    ;               |--  Divisor  --|
    ;               |               |
    ;               |---------------|
    ;               |               |
    ;               |--  Dividend --|
    ;               |               |
    ;               |---------------|
    ;               |  ReturnAddr** |
    ;       ESP---->|---------------|
    ;
    ;
    ; On Exit:
    ;       EDX:EAX contains the quotient (dividend/divisor)
    ;       EBX:ECX contains the remainder (divided % divisor)
    ;       NOTE: this routine removes the parameters from the stack.
    ;

    ;
    ; Set up the local stack for Reminder pointer
    ;
    sub  esp, 8
    push esp

    ;
    ; Set up the local stack for Divisor parameter
    ;
    mov  eax, [esp + 28]
    push eax
    mov  eax, [esp + 28]
    push eax

    ;
    ; Set up the local stack for Dividend parameter
    ;
    mov  eax, [esp + 28]
    push eax
    mov  eax, [esp + 28]
    push eax

    ;
    ; Call native DivS64x64Remainder of BaseLib
    ;
    call DivS64x64Remainder

    ;
    ; EDX:EAX contains the quotient (dividend/divisor)
    ; Put the Remainder in EBX:ECX
    ;
    mov  ecx, [esp + 20]
    mov  ebx, [esp + 24]

    ;
    ; Adjust stack
    ;
    add  esp, 28

    ret  16
  }
}
