/*
 * Decompiled with CFR 0.152.
 */
package jcckit.data;

import java.text.MessageFormat;
import java.util.Vector;
import jcckit.data.DataElement;
import jcckit.data.DataEvent;
import jcckit.data.DataListener;

public abstract class DataContainer {
    private static final String TEMPLATE = "Invalid operation: {0}, Element: {1}, Container: {2}";
    static final String ADD = "add";
    static final String REPLACE = "replace";
    static final String INSERT = "insert";
    private final Vector _listeners = new Vector();
    private final Vector _container = new Vector();

    public void addDataListener(DataListener listener) {
        if (!this._listeners.contains(listener)) {
            this._listeners.addElement(listener);
        }
    }

    public void removeDataListener(DataListener listener) {
        this._listeners.removeElement(listener);
    }

    private void notifyListeners(DataEvent event) {
        DataContainer container;
        int n = this._listeners.size();
        for (int i = 0; i < n; ++i) {
            ((DataListener)this._listeners.elementAt(i)).dataChanged(event);
        }
        if (this instanceof DataElement && (container = ((DataElement)((Object)this)).getContainer()) != null) {
            container.notifyListeners(event);
        }
    }

    public int getNumberOfElements() {
        return this._container.size();
    }

    public DataElement getElement(int index) {
        return (DataElement)this._container.elementAt(index);
    }

    public int getIndexOf(DataElement element) {
        return this._container.indexOf(element);
    }

    public void addElement(DataElement element) {
        if (this.isValid(element)) {
            this._container.addElement(element);
            element.setContainer(this);
            this.notifyListeners(DataEvent.createAddEvent(this));
        } else {
            this.throwException(ADD, element);
        }
    }

    public void insertElementAt(int index, DataElement element) {
        if (this.isValid(element)) {
            this._container.insertElementAt(element, index);
            element.setContainer(this);
            this.notifyListeners(DataEvent.createInsertEvent(this, index));
        } else {
            this.throwException(INSERT, element);
        }
    }

    public void removeElementAt(int index) {
        DataElement element = (DataElement)this._container.elementAt(index);
        element.setContainer(null);
        this._container.removeElementAt(index);
        this.notifyListeners(DataEvent.createRemoveEvent(this, index, element));
    }

    public void replaceElementAt(int index, DataElement element) {
        if (this.isValid(element)) {
            DataElement oldElement = (DataElement)this._container.elementAt(index);
            oldElement.setContainer(null);
            this._container.setElementAt(element, index);
            element.setContainer(this);
            this.notifyListeners(DataEvent.createReplaceEvent(this, index, oldElement));
        } else {
            this.throwException(REPLACE, element);
        }
    }

    private void throwException(String operation, DataElement element) {
        throw new IllegalArgumentException(MessageFormat.format(TEMPLATE, operation, element, this.getClass().getName()));
    }

    protected abstract boolean isValid(DataElement var1);
}

