"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProgressRing = void 0;
const react_1 = __importDefault(require("react"));
// Based on https://css-tricks.com/building-progress-ring-quickly/
exports.ProgressRing = ({ radius, stroke, progress, }) => {
    const normalizedRadius = radius - stroke;
    const circumference = normalizedRadius * 2 * Math.PI;
    const strokeDashoffset = circumference - (progress / 100) * circumference;
    return (react_1.default.createElement("svg", { height: radius * 2, width: radius * 2, className: "progress-ring" },
        react_1.default.createElement("circle", { stroke: "#000", fill: "transparent", strokeWidth: stroke, strokeDasharray: `${circumference} ${circumference}`, style: { strokeDashoffset }, r: normalizedRadius, cx: radius, cy: radius })));
};
//# sourceMappingURL=ProgressRing.js.map