/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ja;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.ja.JapaneseFilterUtil;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.internal.hppc.CharObjectHashMap;

public final class JapaneseHiraganaUppercaseFilter
extends TokenFilter {
    private static final CharObjectHashMap<Character> LETTER_MAPPINGS = JapaneseFilterUtil.createCharMap(Map.entry(Character.valueOf('\u3041'), Character.valueOf('\u3042')), Map.entry(Character.valueOf('\u3043'), Character.valueOf('\u3044')), Map.entry(Character.valueOf('\u3045'), Character.valueOf('\u3046')), Map.entry(Character.valueOf('\u3047'), Character.valueOf('\u3048')), Map.entry(Character.valueOf('\u3049'), Character.valueOf('\u304a')), Map.entry(Character.valueOf('\u3063'), Character.valueOf('\u3064')), Map.entry(Character.valueOf('\u3083'), Character.valueOf('\u3084')), Map.entry(Character.valueOf('\u3085'), Character.valueOf('\u3086')), Map.entry(Character.valueOf('\u3087'), Character.valueOf('\u3088')), Map.entry(Character.valueOf('\u308e'), Character.valueOf('\u308f')), Map.entry(Character.valueOf('\u3095'), Character.valueOf('\u304b')), Map.entry(Character.valueOf('\u3096'), Character.valueOf('\u3051')));
    private final CharTermAttribute termAttr = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);

    public JapaneseHiraganaUppercaseFilter(TokenStream input) {
        super(input);
    }

    public boolean incrementToken() throws IOException {
        if (!this.input.incrementToken()) {
            return false;
        }
        char[] termBuffer = this.termAttr.buffer();
        int length = this.termAttr.length();
        for (int i = 0; i < length; ++i) {
            Character c = (Character)LETTER_MAPPINGS.get(termBuffer[i]);
            if (c == null) continue;
            termBuffer[i] = c.charValue();
        }
        return true;
    }
}

