/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.mutation.internal;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.function.Supplier;
import org.hibernate.engine.jdbc.mutation.group.PreparedStatementDetails;
import org.hibernate.engine.jdbc.spi.JdbcCoordinator;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.jdbc.Expectation;
import org.hibernate.sql.model.PreparableMutationOperation;
import org.hibernate.sql.model.TableMapping;

public class PreparedStatementDetailsStandard
implements PreparedStatementDetails {
    private final TableMapping mutatingTableDetails;
    private final String sql;
    private final Supplier<PreparedStatement> jdbcStatementCreator;
    private final Expectation expectation;
    private final JdbcServices jdbcServices;
    private PreparedStatement statement;

    public PreparedStatementDetailsStandard(PreparableMutationOperation tableMutation, Supplier<PreparedStatement> jdbcStatementCreator, JdbcServices jdbcServices) {
        this(tableMutation, tableMutation.getSqlString(), jdbcStatementCreator, tableMutation.getExpectation(), jdbcServices);
    }

    public PreparedStatementDetailsStandard(PreparableMutationOperation tableMutation, String sql, Supplier<PreparedStatement> jdbcStatementCreator, Expectation expectation, JdbcServices jdbcServices) {
        this.mutatingTableDetails = tableMutation.getTableDetails();
        this.sql = sql;
        this.jdbcStatementCreator = jdbcStatementCreator;
        this.expectation = expectation;
        this.jdbcServices = jdbcServices;
    }

    @Override
    public TableMapping getMutatingTableDetails() {
        return this.mutatingTableDetails;
    }

    @Override
    public void releaseStatement(SharedSessionContractImplementor session) {
        if (this.statement != null) {
            JdbcCoordinator jdbcCoordinator = session.getJdbcCoordinator();
            jdbcCoordinator.getLogicalConnection().getResourceRegistry().release(this.statement);
            this.statement = null;
            jdbcCoordinator.afterStatementExecution();
        }
    }

    @Override
    public String getSqlString() {
        return this.sql;
    }

    @Override
    public PreparedStatement getStatement() {
        return this.statement;
    }

    @Override
    public PreparedStatement resolveStatement() {
        if (this.statement == null) {
            this.statement = this.jdbcStatementCreator.get();
            try {
                this.expectation.prepare(this.statement);
            }
            catch (SQLException e) {
                throw this.jdbcServices.getSqlExceptionHelper().convert(e, "Unable to prepare for expectation", this.sql);
            }
        }
        return this.statement;
    }

    @Override
    public Expectation getExpectation() {
        return this.expectation;
    }

    public String toString() {
        return "PreparedStatementDetails(" + this.sql + ")";
    }
}

