/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;
import org.apache.kafka.clients.consumer.internals.ShareCompletedFetch;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.errors.InterruptException;
import org.apache.kafka.common.internals.IdempotentCloser;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Timer;
import org.slf4j.Logger;

public class ShareFetchBuffer
implements AutoCloseable {
    private final Logger log;
    private final ConcurrentLinkedQueue<ShareCompletedFetch> completedFetches;
    private final Lock lock;
    private final Condition notEmptyCondition;
    private final IdempotentCloser idempotentCloser = new IdempotentCloser();
    private final AtomicBoolean wokenUp = new AtomicBoolean(false);
    private ShareCompletedFetch nextInLineFetch;

    public ShareFetchBuffer(LogContext logContext) {
        this.log = logContext.logger(ShareFetchBuffer.class);
        this.completedFetches = new ConcurrentLinkedQueue();
        this.lock = new ReentrantLock();
        this.notEmptyCondition = this.lock.newCondition();
    }

    boolean isEmpty() {
        this.lock.lock();
        try {
            boolean bl = this.completedFetches.isEmpty();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    boolean hasCompletedFetches(Predicate<ShareCompletedFetch> predicate) {
        this.lock.lock();
        try {
            boolean bl = this.completedFetches.stream().anyMatch(predicate);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    void add(ShareCompletedFetch fetch) {
        this.lock.lock();
        try {
            this.completedFetches.add(fetch);
            this.notEmptyCondition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    ShareCompletedFetch nextInLineFetch() {
        this.lock.lock();
        try {
            ShareCompletedFetch shareCompletedFetch = this.nextInLineFetch;
            return shareCompletedFetch;
        }
        finally {
            this.lock.unlock();
        }
    }

    void setNextInLineFetch(ShareCompletedFetch nextInLineFetch) {
        this.lock.lock();
        try {
            this.nextInLineFetch = nextInLineFetch;
        }
        finally {
            this.lock.unlock();
        }
    }

    ShareCompletedFetch peek() {
        this.lock.lock();
        try {
            ShareCompletedFetch shareCompletedFetch = this.completedFetches.peek();
            return shareCompletedFetch;
        }
        finally {
            this.lock.unlock();
        }
    }

    ShareCompletedFetch poll() {
        this.lock.lock();
        try {
            ShareCompletedFetch shareCompletedFetch = this.completedFetches.poll();
            return shareCompletedFetch;
        }
        finally {
            this.lock.unlock();
        }
    }

    void awaitNotEmpty(Timer timer) {
        this.lock.lock();
        try {
            while (this.completedFetches.isEmpty() && !this.wokenUp.compareAndSet(true, false)) {
                timer.update();
                if (timer.isExpired()) {
                    if (Thread.interrupted()) {
                        throw new InterruptException("Thread interrupted.");
                    }
                } else if (this.notEmptyCondition.await(timer.remainingMs(), TimeUnit.MILLISECONDS)) continue;
                break;
            }
        }
        catch (InterruptedException e) {
            throw new InterruptException("Timeout waiting for results from fetching records", e);
        }
        finally {
            this.lock.unlock();
            timer.update();
        }
    }

    void wakeup() {
        this.wokenUp.set(true);
        this.lock.lock();
        try {
            this.notEmptyCondition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    Set<TopicIdPartition> bufferedPartitions() {
        this.lock.lock();
        try {
            HashSet<TopicIdPartition> partitions = new HashSet<TopicIdPartition>();
            if (this.nextInLineFetch != null && !this.nextInLineFetch.isConsumed()) {
                partitions.add(this.nextInLineFetch.partition);
            }
            this.completedFetches.forEach(cf -> partitions.add(cf.partition));
            HashSet<TopicIdPartition> hashSet = partitions;
            return hashSet;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void drainAll() {
        this.lock.lock();
        try {
            this.completedFetches.forEach(ShareCompletedFetch::drain);
            this.completedFetches.clear();
            if (this.nextInLineFetch != null) {
                this.nextInLineFetch.drain();
                this.nextInLineFetch = null;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void close() {
        this.lock.lock();
        try {
            this.idempotentCloser.close(this::drainAll, () -> this.log.warn("The fetch buffer was already closed"));
        }
        finally {
            this.lock.unlock();
        }
    }
}

