/*
 * Decompiled with CFR 0.152.
 */
package com.sparshui.common.messages.events;

import com.sparshui.common.Event;
import com.sparshui.common.utils.Converter;

public class SpinEvent
implements Event {
    private static final long serialVersionUID = 6394319277586792988L;
    private float _rotationX;
    private float _rotationY;
    private float _rotationZ;

    @Override
    public int getEventType() {
        return 2;
    }

    public SpinEvent() {
        this._rotationX = 0.0f;
        this._rotationY = 0.0f;
        this._rotationZ = 0.0f;
    }

    public SpinEvent(float rotationX, float rotationY, float rotationZ) {
        this._rotationX = rotationX;
        this._rotationY = rotationY;
        this._rotationZ = rotationZ;
    }

    public float getRotationX() {
        return this._rotationX;
    }

    public float getRotationY() {
        return this._rotationY;
    }

    public float getRotationZ() {
        return this._rotationZ;
    }

    public void setRotationX(float rotation) {
        this._rotationX = rotation;
    }

    public void setRotationY(float rotation) {
        this._rotationY = rotation;
    }

    public void setRotationZ(float rotation) {
        this._rotationZ = rotation;
    }

    public SpinEvent(byte[] data) {
        if (data.length < 12) {
            System.err.println("An error occurred while deserializing a TouchEvent.");
        } else {
            this._rotationX = Converter.byteArrayToFloat(data, 0);
            this._rotationY = Converter.byteArrayToFloat(data, 4);
            this._rotationY = Converter.byteArrayToFloat(data, 8);
        }
    }

    @Override
    public byte[] serialize() {
        byte[] data = new byte[16];
        Converter.intToByteArray(data, 0, this.getEventType());
        Converter.floatToByteArray(data, 4, this._rotationX);
        Converter.floatToByteArray(data, 8, this._rotationY);
        Converter.floatToByteArray(data, 12, this._rotationZ);
        return data;
    }

    public String toString() {
        return "Spin Event - rotationX: " + this._rotationX + ", rotationY: " + this._rotationY + ", rotationZ: " + this._rotationZ;
    }
}

