/***************************************************************************
 *
 * Copyright (c) 1999 Balzs Scheidler
 * Copyright (c) 1999 BalaBit Computing
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Inspired by nsyslog, originally written by Darren Reed.
 *
 * $Id: affile.h,v 1.8 1999/12/18 22:25:38 bazsi Exp $
 *
 ***************************************************************************/

#ifndef __AFFILE_H
#define __AFFILE_H

#include "syslog-ng.h"

#include "log.h"
#include "io.h"
#include "sources.h"
#include "destinations.h"

#define AFFILE_COMPRESS   0x0001
#define AFFILE_COMPRESS_SHIFT 0

#define AFFILE_ENCRYPT    0x0002
#define AFFILE_ENCRYPT_SHIFT 1

#define AFFILE_NO_EXPAND  0x0004
#define AFFILE_NO_EXPAND_SHIFT 2

void affile_set_syncfreq(struct log_dest_driver *affile, int syncfreq);

void affile_set_compress(struct log_dest_driver *affile, int enable);
void affile_set_encrypt(struct log_dest_driver *affile, int enable);

struct log_source_driver *make_affile_source(const char *name);
struct log_dest_driver *make_affile_dest(const char *name, int flags);

#endif
