/***************************************************************************
 *
 * Copyright (c) 1999 Balzs Scheidler
 * Copyright (c) 1999 BalaBit Computing
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Inspired by nsyslog, originally written by Darren Reed.
 *
 * $Id: afsocket.h,v 1.9 1999/10/20 19:30:01 bazsi Exp $
 *
 ***************************************************************************/

#ifndef __AFUNIX_H_INCLUDED
#define __AFUNIX_H_INCLUDED

#include "syslog-ng.h"
#include "io.h"
#include "sources.h"
#include "destinations.h"
#include "utils.h"

#define AFSOCKET_STREAM		0x0000
#define AFSOCKET_DGRAM		0x0001
#define AFSOCKET_INET		0x0000
#define AFSOCKET_UNIX		0x0002

#define AFINET_PROTO_STREAM	(AFSOCKET_STREAM | AFSOCKET_INET)
#define AFINET_PROTO_DGRAM	(AFSOCKET_DGRAM | AFSOCKET_INET)
#define AFUNIX_PROTO_STREAM	(AFSOCKET_STREAM | AFSOCKET_UNIX)
#define AFUNIX_PROTO_DGRAM	(AFSOCKET_DGRAM | AFSOCKET_UNIX)

#define AFSOCKET_REQUIRED       2
#define AFSOCKET_ALLOW          1
#define AFSOCKET_DENY           0

#define AFSOCKET_YES            3
#define AFSOCKET_NO             0

#define AFSOCKET_AUTH_MASK      0x000C
#define AFSOCKET_AUTH_SHIFT     2

#define AFSOCKET_MAC_MASK       0x0030
#define AFSOCKET_MAC_SHIFT      4

#define AFSOCKET_ENCRYPT_MASK   0x00C0
#define AFSOCKET_ENCRYPT_SHIFT  6


#define AFSOCKET_TYPE		0x0001
#define AFSOCKET_PROTO          0x0002

void afunix_set_owner(struct log_source_driver *c, const char *owner);
void afunix_set_group(struct log_source_driver *c, const char *group);
void afunix_set_perm(struct log_source_driver *c, int perm);

void afinet_src_set_localport(struct log_source_driver *c, UINT32 port);
void afinet_src_set_localip(struct log_source_driver *c, const char *ip);
void afinet_src_set_auth(struct log_source_driver *c, UINT32 v);
void afinet_src_set_mac(struct log_source_driver *c, UINT32 v);
void afinet_src_set_encrypt(struct log_source_driver *c, UINT32 v);

void afinet_dest_set_localip(struct log_dest_driver *c, const char *ip);
void afinet_dest_set_localport(struct log_dest_driver *c, UINT32 port);
void afinet_dest_set_destport(struct log_dest_driver *c, UINT32 port);
void afinet_dest_set_auth(struct log_dest_driver *c, UINT32 value);
void afinet_dest_set_mac(struct log_dest_driver *c, UINT32 value);
void afinet_dest_set_encrypt(struct log_dest_driver *c, UINT32 value);

struct log_source_driver *make_afsocket_source(struct address_info *a, UINT32 flags);
struct log_dest_driver *make_afsocket_dest(struct address_info *a, UINT32 flags);


#endif

