/***************************************************************************
 *
 * Copyright (c) 1999 BalaBit Computing
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Inspired by nsyslog, originally written by Darren Reed.
 *
 * $Id: cfgfile.h,v 1.11 1999/07/10 15:58:33 bazsi Exp $
 *
 ***************************************************************************/

#ifndef __CFGFILE_H_INCLUDED
#define __CFGFILE_H_INCLUDED

#include "sources.h"
#include "filters.h"
#include "destinations.h"
#include "center.h"

#define CLASS_DECLARE
#include "cfgfile.h.x"
#undef CLASS_DECLARE

/* CLASS:
    (class
      (name syslog_conf)
      (vars
        (init method int)
	(destroy method int)
	(resources object resource_list)
        (backend object io_backend)
	; global options
	(long_hostnames simple UINT32)
	(mark_freq simple UINT32)
	(sync_freq simple UINT32)
	(time_reopen simple UINT32)
	(log_fifo_size simple UINT32)
	; internal messages should come from this source
	(internal object log_handler)
        (sources object log_source_group)
        (filters object log_filter)
        (destinations object log_dest_group)
	; connections between sources and destinations
        (connections object log_connection))) 
*/

#define CONFIG_INIT(c) (c)->init(c)
#define CONFIG_DESTROY(c) (c)->destroy(c)

extern struct syslog_conf *configuration;

void add_dest_group(struct log_dest_group *grp);
void add_source_group(struct log_source_group *grp);
void add_log_connection(struct log_connection *conn);
void add_filter_rule(struct log_filter *filter);

struct syslog_conf *make_syslog_conf(const char *name, struct io_backend *backend);

#endif
