/* StegFS - The Steganographic File System */
/* Copyright (c)1999-2001 Andrew McDonald <andrew@mcdonald.org.uk> */
/* $Id: stegfsopen.c,v 1.4 2001/02/12 21:05:57 admcd Exp $ */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <libgen.h>
#include <string.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <errno.h>
#include "../kernel/stegfs_fs.h"

void printusage(char *);

int main(int argc, char *argv[]) {

	int fd, r, l, l2, i;
	struct stegfs_setlevel setlevel;
	char * pass;
	char * tmpc;

	if (argc < 2 || argc > 4)
		printusage(argv[0]);
	fd = open (argv[1], O_RDONLY|O_NONBLOCK);
	if (fd == -1)
		return -1;

	r = ioctl(fd, STEGFS_IOC_GETLEVELS, &l);
	if (r != 0) {
		perror("Error");
		exit(1);
	}

	if (argc == 2) {
		printf("StegFS open levels:");
		r = 0;
		for (i=0; i<STEGFS_MAX_LEVELS-1; i++) {
			if ( (l>>i) & 0x01 ) {
				printf(" %d", i+1);
				r = 1;
			}
		}
		if (r)
			printf("\n");
		else
			printf(" none\n");
		close(fd);
		exit(0);
	}

	/* open security context/levels */

	setlevel.context = strtol(argv[2], &tmpc, 0);
	if (*argv[2] == '\0' || *tmpc != '\0' ||
	    setlevel.context < 1 || setlevel.context > STEGFS_MAX_CONTEXTS) {
		printf("Invalid security context number\n");
		exit(1);
	}

	if (argc == 4) {
		setlevel.level = strtol(argv[3], &tmpc, 0);
		if (*argv[3] == '\0' || *tmpc != '\0' ||
		    setlevel.level < 1 ||
		    setlevel.level > STEGFS_MAX_LEVELS-1) {
			printf("Invalid security level number\n");
			exit(1);
		}
	}
	else
		setlevel.level = 0;

/*
	printf("StegFS current level change %d to %d\n", l, setlevel.level);
*/

	setlevel.flags = 0;

	pass = getpass("Enter passphrase: ");

	strncpy(setlevel.passw, pass, STEGFS_PASS_LEN);
	setlevel.passw[STEGFS_PASS_LEN-1] = '\0';  /* force null terminate */
	memset(pass, 0, strlen(pass));

	r = ioctl(fd, STEGFS_IOC_SETLEVELS, &setlevel);
	memset(setlevel.passw, 0, STEGFS_PASS_LEN);
	if (r != 0) {
		if (errno == EBADPASS) {
			printf("Level open failed: bad passphrase?\n");
			exit(1);
		}
		perror("Error");
		exit(1);
	}

	/* double check */
	r = ioctl(fd, STEGFS_IOC_GETLEVELS, &l2);
	if (r != 0) {
		perror("Error");
		exit(1);
	}

	printf("Level change successful\n");

	printf("StegFS open levels:");
	r = 0;
	for (i=0; i<STEGFS_MAX_LEVELS-1; i++) {
		if ( (l2>>i) & 0x01 ) {
			printf(" %d", i+1);
			r = 1;
		}
	}
	if (r)
		printf("\n");
	else
		printf(" none\n");

	close(fd);
	exit(0);
}


void printusage(char *progname) {

  printf("Usage: %s /mnt/mntpoint [contextnum [levelnum]]\n",
	 basename(progname));

  exit(1);
}
