#!/usr/bin/perl

#    mkpatch - Create patches against the Linux kernel
#    Copyright (c) 1999  Frodo Looijaard <frodol@dds.nl>
#
#    From the version for lm-sensors
#    Modifications for StegFS
#    Copyright (c) 2001  Andrew McDonald <andrew@mcdonald.org.uk>
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

use strict;


# This generates fs.h They are a bit intricate.
# $_[0]: Linux kernel tree (like /usr/src/linux)
sub gen_include_linux_fs_h
{
  my ($package_root, $kernel_root) = @_;
  my $kernel_file = "include/linux/fs.h";
  my $package_file = "fs.h";
  my $pr1 = 0;
  my $pr2 = 0;
  my $pr3 = 0;
  my $pr4 = 0;

  open INPUT,"$kernel_root/$kernel_file"
        or die "Can't open `$kernel_root/$kernel_file'";
  open OUTPUT,">$package_root/$package_file"
        or die "Can't open $package_root/$package_file";
  MAIN: while(<INPUT>) {
    if (m@qnx4_fs_i\.h@) {
      $pr1 = 1;
      print OUTPUT << 'EOF';
#include "stegfs_fs_i.h"
EOF
    }
    if (m@qnx4_inode_info@) {
      $pr2 = 1;
      print OUTPUT << 'EOF';
		struct stegfs_inode_info	stegfs_i;
EOF
    }
    if (m@qnx4_fs_sb\.h@) {
      $pr3 = 1;
      print OUTPUT << 'EOF';
#include "stegfs_fs_sb.h"
EOF
    }
    if (m@qnx4_sb_info@) {
      $pr4 = 1;
      print OUTPUT << 'EOF';
		struct stegfs_sb_info	stegfs_sb;
EOF
    }
    print OUTPUT;
  }
  close INPUT;
  close OUTPUT;
  die "Automatic generation for `fs.h' failed.\n".
      "Contact the authors please!" if $pr1 = 0 or $pr2 = 0 or $pr3 = 0 or $pr4 = 0;
}


# Main function
sub main
{
  my ($package_root, $kernel_root);

  # --> Read the command-lineo
  $package_root = $ARGV[0];
  $kernel_root = $ARGV[1];
  die "Kernel root `$kernel_root' is not found\n"
        unless -f "$kernel_root/Rules.make";

  gen_include_linux_fs_h $package_root, $kernel_root;
}

main;

