#ifndef _RSA_H
#define _RSA_H

#include "bn.h"

/* RSA key structure */

struct RSAKey {
    unsigned short bits;
    unsigned short bytes;
    Bignum modulus;
    Bignum exponent;
    Bignum private_exponent;
    Bignum p;
    Bignum q;
    Bignum iqmp;
    char *comment;
};

int makekey(unsigned char *, struct RSAKey *, char **, short);
int makeprivate(unsigned char *, struct RSAKey *);
void rsaencrypt(char *, int, struct RSAKey *);
Bignum rsadecrypt(Bignum, struct RSAKey *);
int rsa_verify(struct RSAKey *);
void freersakey(struct RSAKey *);

int loadrsakey(char *, struct RSAKey *, char *);
int rsakey_encrypted(char *, char **);
int key_type(char *);
char *key_type_to_str(int);

#endif
