/*

  silcunixmutex.c

  Author: Pekka Riikonen <priikone@silcnet.org>

  Copyright (C) 2001 - 2005 Pekka Riikonen

  The contents of this file are subject to one of the Licenses specified 
  in the COPYING file;  You may not use this file except in compliance 
  with the License.

  The software distributed under the License is distributed on an "AS IS"
  basis, in the hope that it will be useful, but WITHOUT WARRANTY OF ANY
  KIND, either expressed or implied.  See the COPYING file for more
  information.

*/
/* $Id: silcunixmutex.c,v 1.5.2.3 2005/05/05 18:37:21 priikone Exp $ */

#include "silcincludes.h"

/* SILC Mutex structure */
struct SilcMutexStruct {
#ifdef SILC_THREADS
  pthread_mutex_t mutex;
  unsigned int locked : 1;
#else
  void *tmp;
#endif /* SILC_THREADS */
};

bool silc_mutex_alloc(SilcMutex *mutex)
{
#ifdef SILC_THREADS
  *mutex = silc_calloc(1, sizeof(**mutex));
  if (*mutex == NULL)
    return FALSE;
  pthread_mutex_init(&(*mutex)->mutex, NULL);
#endif /* SILC_THREADS */
  return TRUE;
}

void silc_mutex_free(SilcMutex mutex)
{
#ifdef SILC_THREADS
  if (mutex) {
    pthread_mutex_destroy(&mutex->mutex);
    silc_free(mutex);
  }
#endif /* SILC_THREADS */
}

void silc_mutex_lock(SilcMutex mutex)
{
#ifdef SILC_THREADS
  if (mutex) {
    if (pthread_mutex_lock(&mutex->mutex))
      assert(FALSE);
    assert(mutex->locked == 0);
    mutex->locked = 1;
  }
#endif /* SILC_THREADS */
}

void silc_mutex_unlock(SilcMutex mutex)
{
#ifdef SILC_THREADS
  if (mutex) {
    assert(mutex->locked == 1);
    mutex->locked = 0;
    if (pthread_mutex_unlock(&mutex->mutex))
      assert(FALSE);
  }
#endif /* SILC_THREADS */
}
