/*

  silczip.h
 
  Author: Pekka Riikonen <priikone@silcnet.org>
 
  Copyright (C) 2001 Pekka Riikonen
 
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

*/

/****h* silcutil/silczip.h
 *
 * DESCRIPTION
 *
 * Interface for SILC Zip compression routines. This interface can be
 * used to compress and decrompress data buffers. The interface is
 * independent of any specific compression algorithm.
 *
 */

#ifndef SILCZIP_H
#define SILCZIP_H

/* Prototypes */

/****s* silcutil/SilcZipAPI/SilcZip
 *
 * NAME
 * 
 *    typedef struct SilcZipStruct *SilcZip;
 *
 * DESCRIPTION
 *
 *    This context is the actual SILC Zip and is returned by the 
 *    silc_zip_alloc function, and given as arguments to all of the
 *    silc_zip_* functions. This context and its resources are freed
 *    by calling the silc_zip_free function.
 *
 ***/
typedef struct SilcZipStruct *SilcZip;

/* These macros can be used to implement the SILC Zip API and to avoid
   errors in the API these macros should be used always. */
#define SILC_ZIP_API_INIT(zip)			\
bool silc_##zip##_init(void *context)
#define SILC_ZIP_API_UNINIT(zip)		\
void silc_##zip##_uninit(void *context)
#define SILC_ZIP_API_COMPRESS(zip)				\
void silc_##zip##_compress(void *context, unsigned char *src,	\
			   SilcUInt32 src_len, unsigned char *dst, 	\
			   SilcUInt32 dst_len);
#define SILC_ZIP_API_UNCOMPRESS(zip)					\
void silc_##zip##_uncompress(void *context, unsigned char *src, 	\
			     SilcUInt32 src_len, unsigned char *dst, 	\
			     SilcUInt32 dst_len);
#define SILC_ZIP_API_CONTEXT_LEN(zip)		\
SilcUInt32 silc_##zip##_context_len(void)


SilcZip silc_zip_alloc(const char *name, int level);
void silc_zip_free(SilcZip zip);
void silc_zip_compress(SilcZip zip, unsigned char *src, SilcUInt32 src_len,
		       unsigned char *dst, SilcUInt32 src_len);
void silc_zip_uncompress(SilcZip zip, unsigned char *src, SilcUInt32 src_len,
			 unsigned char *dst, SilcUInt32 src_len);

#endif
