
#include "window.h"

/* extern char	*strdup(char *); */

WINDOW *
wopen(title, drawproc)
char *title;
void (*drawproc)();
{
	WINDOW	*new;
	int	x_maxsize, y_maxsize, w_maxsize, h_maxsize;
	int	left;
	int	top;
	int	right;
	int	bottom;
	int	handle;
	int	dummy = 0;
	int inc;

	rmcaret ();

	wind_update(BEG_UPDATE);

	x_maxsize = 0;
	y_maxsize = BAR_HEIGHT+w_min_v_pos;
	w_maxsize = max_width + w_l_border + w_r_border;
	h_maxsize = max_height-w_min_v_pos;
	if ( !w_from_con ) {
		h_maxsize += w_t_border + w_b_border;
		if ( ( inc = ( x_def + w_l_border ) % 8 ) != 0 ) {
			x_def -= inc;
			if ( inc > 4 || x_def < 0 ) x_def += 8;
		}
		if ( ( inc = ( h_def - w_t_border - w_b_border ) % chheight ) != 0 ) {
			h_def -= inc;
		}
		if ( ( inc = ( w_def - w_l_border - w_r_border ) % 8 ) != 0 ) {
			w_def -= inc;
		}
	}
	
	handle = wind_create (w_def_opt, x_maxsize, y_maxsize, w_maxsize, h_maxsize);
	if (handle < 0) {
Abo:
		wind_update(END_UPDATE);
		showcaret ();
		return (NULL);
	}
	if ( ( new = ALLOC (WINDOW) ) == 0 ) {
		wind_delete (handle);
		goto Abo;
	}
/*
	Take previously closed window positions into account.
*/
	if ( num_w_pile > 0 ) {
		while ( num_w_pile-- > 0 ) {
			if ( w_win_pile[num_w_pile].console != w_from_con ) continue;
			x_def = w_win_pile[num_w_pile].x;
			y_def = w_win_pile[num_w_pile].y;
			w_def = w_win_pile[num_w_pile].w;
			h_def = w_win_pile[num_w_pile].h;
			break;
		}
	}

	new->console  = w_from_con;
	new->tag      = 0;
	new->handle   = handle;
	if ( w_from_con ) new->title = 0;
	else			  new->title = strdup (title);
	new->drawproc = drawproc;
	new->h        = x_def;
	new->v        = y_def;
	new->width    = w_def;
	new->height   = h_def;
	if ( !w_from_con ) {
		new->h        += + w_l_border;
		new->v        += + w_t_border;
		new->width    += - w_l_border - w_r_border;
	}
	else new->v++;
	new->height   += - w_t_border - w_b_border;
	new->careton  = FALSE;
	new->caret_h  = new->caret_v = -1;

	initmbar(new);
	wgettextattr(&new->attr);
	wsetorigin(new, 0, 0);
	wsetdocsize(new, 0, 0);
	wsettimer(new, 0);

	if ( !w_from_con )
		wind_set (handle, WF_NAME, new->title, dummy, dummy, dummy);

	if ( !wind_open (handle, x_def, y_def,
				w_from_con ? new->width:  w_def,
				w_from_con ? new->height: h_def)) {
		wclose (new);
		return (NULL);
	}

	if ( !w_from_con ) setscrollbars (new);

	L_APPEND (nrwin, winlist, WINDOW *, new);

	left = new->orgh;
	top = new->orgv;
	right = left + new->width;
	bottom = top + new->height;
	wchange (new, left, top, right, bottom);

	active = new;

	wind_update(END_UPDATE);

	wupdate(new);

	showcaret ();

	x_def += 48;
	if (x_def + w_def >= scr_width) {
		x_def -= scr_width;
		if (x_def < 0)
			x_def = 0;
	}

	y_def += 32;
	if (y_def + h_def >= scr_height) {
		y_def -= scr_width;
		if (y_def < BAR_HEIGHT+w_min_v_pos)
			y_def = BAR_HEIGHT+w_min_v_pos;
	}

	return (new);
}

