#include <stdio.h>
#include "window.h"

#define MIN_WIDTH       100
#define MIN_HEIGHT      100

WINDOW  **winlist ;
int     nrwin = 0 ;
WINDOW  *active = NULL ;

int     vdi_handle = -1 ;

static Rect     def ;

static int      max_width ;
static int      max_height ;

static int      pix_width ;
static int      pix_height ;

int     scr_width ;
int     scr_height ;

static int      lborder ;
static int      tborder ;
static int      rborder ;
static int      bborder ;

static int      chwidth ;
int     chheight ;
static int      bxwidth ;
static int      bxheight ;

/* variables used by the vdi library */
int     contrl[12] ;
int     intin[128] ;
int     intout[128] ;
int     ptsin[128] ;
int     ptsout[128] ;

extern char     *strdup () ;

void
winit ()
{
        Rect    inside ;
        Rect    outside ;
        int     i ;
        int     workin[11] ;
        int     workout[57] ;
        int     dummy ;

        if (appl_init () < 0)
                return ;

        /* Get the size of characters and the screen size */

        vdi_handle = graf_handle (&chwidth, &chheight, &bxwidth, &bxheight) ;

        for (i = 0; i < 10; i++)
                workin[i] = 1 ;
        workin[10] = 2 ;
        v_opnvwk (workin, &vdi_handle, workout) ;

        scr_width = workout[0] + 1 ;
        scr_height = workout[1] + 1 ;

        pix_width = workout[2] ;
        pix_height = workout[3] ;

        /*
        ** Some atributes for drawing...
        */
        vsf_perimeter (vdi_handle, 1) ;

        vsl_color (vdi_handle, 1) ;
        vsl_type (vdi_handle, 1) ;

        vst_color (vdi_handle, 1) ;
        vst_alignment (vdi_handle, 0, 5, &dummy, &dummy) ;

        outside.x = 0 ;
        outside.y = BAR_HEIGHT ;
        outside.w = scr_width ;
        outside.h = scr_height - BAR_HEIGHT ;

        wind_calc (1, DEF_OPT, outside, &inside.x, &inside.y, &inside.w,
                                                                &inside.h) ;

        lborder = inside.x - outside.x ;
        tborder = inside.y - outside.y ;
        rborder = outside.x + outside.w - (inside.x + inside.w) ;
        bborder = outside.y + outside.h - (inside.y + inside.h) ;

        initglobmenus () ;

        /* Set window positions and sizes */

        wsetdefwinpos (0, 0) ;
        wsetmaxwinsize (scr_width, scr_height) ;
        wsetdefwinsize (scr_width * 2/3, scr_height * 2/3) ;

        wsetplain () ;

        if (!graf_mouse (BUSY_BEE, &dummy))
                wdebug ("winit: mouse busy bee") ;
}

void
winitnew (pargc, pargv)
        int     *pargc ;
        char    **pargv[] ;
{
        /*
        ** Dummy call because some versions of STDWIN want acces to
        ** argc and argv
        */

        winit () ;
}

void
wdone ()
{
        int     i ;

        for (i = nrwin ; --i >= 0 ; ) {
                wclose (winlist[i]) ;
        }

        delmenubar () ;

        v_clsvwk (vdi_handle) ;
        appl_exit () ;

}

WINDOW
*wopen (title, drawproc)
        char    *title ;
        void    (*drawproc)() ;
{
        WINDOW  *new ;
        Rect    maxsize ;
        int     left ;
        int     top ;
        int     right ;
        int     bottom ;
        int     handle ;
        int     dummy = 0 ;

        wind_update (BEG_UPDATE) ;

        rmcaret () ;

        maxsize.x = 0 ;
        maxsize.y = BAR_HEIGHT ;
        maxsize.w = max_width + lborder + rborder ;
        maxsize.h = max_height + tborder + bborder ;

        handle = wind_create (DEF_OPT, maxsize) ;
        if (handle < 0) {
                wdebug ("wind_create failed") ;
                return (NULL) ;
        }

        new = ALLOC (WINDOW) ;
        if (new == (WINDOW *) NULL) {
                wdebug ("ALLOC (WINDOW) failed") ;
                wind_delete (handle) ;
                return (NULL) ;
        }

        new->tag        = 0 ;
        new->handle     = handle ;
        new->title      = strdup (title) ;
        new->drawproc   = drawproc ;
        new->h          = def.x + lborder ;
        new->v          = def.y + tborder ;
        new->width      = def.w - lborder - rborder ;
        new->height     = def.h - tborder - bborder ;
        new->careton    = FALSE ;
        new->caret_h = new->caret_v = -1 ;

        initmbar (new) ;
        wgettextattr (&new->attr) ;
        wsetorigin (new, 0, 0) ;
        wsetdocsize (new, 0, 0) ;
        wsettimer (new, 0) ;

        if (!wind_set (handle, WF_NAME, new->title, dummy, dummy, dummy)) {
                wdebug ("wind_set title") ;
        }

        if (!wind_open (handle, def)) {
                wdebug ("wind_open") ;
                wclose (new) ;
                return (NULL) ;
        }

        setscrollbars (new) ;

        L_APPEND (nrwin, winlist, WINDOW *, new) ;

        left = new->orgh ;
        top = new->orgv ;
        right = left + new->width ;
        bottom = top + new->height ;
        wchange (new, left, top, right, bottom) ;

        active = new ;

        showcaret () ;

        wind_update (END_UPDATE) ;

        wupdate (new) ;

        def.x += 50 ;
        if (def.x + def.w >= scr_width) {
                def.x -= scr_width ;
                if (def.x < 0)
                        def.x = 0 ;
        }

        def.y += 30 ;
        if (def.y + def.h >= scr_height) {
                def.y -= scr_width ;
                if (def.y < BAR_HEIGHT)
                        def.y = BAR_HEIGHT ;
        }

        return (new) ;
}

WINDOW  *getwin () ;

void
wclose (win)
        WINDOW  *win ;
{
        int     i ;
        int     j ;
        int     newtop ;
        int     dummy = 0 ;

        if (active == win)
                active = NULL ;

        for (i = 0; i < nrwin; i++) {
                if (winlist[i] == win) {
                        wind_close (winlist[i]->handle) ;
                        wind_delete (winlist[i]->handle) ;
                        for (j = win->mbar.nrmenus ; --j >= 0 ;)
                                wmenudetach (win, win->mbar.menulist[j]) ;
                        L_REMOVE (nrwin, winlist, WINDOW *, i) ;
                        break ;
                }
        }

        if (nrwin > 0) {
                wind_get (dummy, WF_TOP, &newtop, &dummy, &dummy, &dummy) ;
                active = getwin (newtop) ;
                if (active == NULL)
                        wdebug ("wclose: cannot find new active window") ;
                showcaret () ;
        }
}

WINDOW
*getwin (handle)
        int     handle ;
{
        int     i ;

        for (i = 0; i < nrwin; i++) {
                if (winlist[i]->handle == handle)
                        return (winlist[i]) ;
        }

        return (NULL) ;
}

void
wsetactive (win)
        WINDOW  *win ;
{
        int     dummy = 0 ;

        if (win == NULL || win == active)
                return ;

        rmcaret () ;

        wind_set (win->handle, WF_TOP, win->handle, dummy, dummy, dummy) ;

        active = win ;

        showcaret () ;
}

WINDOW
*wgetactive ()
{
        return (active) ;
}

void
wgetscrsize (pwidth, pheight)
        int     *pwidth ;
        int     *pheight ;
{
        *pwidth = scr_width ;
        *pheight = scr_height ;
}

void
wgetscrmm (pmmhor, pmmvert)
        int     *pmmhor ;
        int     *pmmvert ;
{
        *pmmhor = (long)pix_width * scr_width / 1000L ;
        *pmmvert = (long)pix_height * scr_height / 1000L ;
}

void
wsettitle (win, title)
        WINDOW  *win ;
        char    *title ;
{
        int     dummy = 0 ;

        FREE (win->title) ;
        win->title = strdup (title) ;
        wind_set (win->handle, WF_NAME, win->title, dummy, dummy, dummy) ;
}

void
wsetdefwinsize (width, height)
        int     width ;
        int     height ;
{
        if (width < MIN_WIDTH)
                width = MIN_WIDTH ;
        if (width > scr_width - lborder - rborder)
                width = scr_width - lborder - rborder ;

        if (height < MIN_HEIGHT)
                height = MIN_HEIGHT ;
        if (height > scr_height - (BAR_HEIGHT + tborder + bborder))
                height = scr_height - (BAR_HEIGHT + tborder + bborder) ;

        def.w = width + lborder + rborder ;
        def.h = height + tborder + bborder ;

        if (max_width < def.w - lborder - rborder)
                max_width = def.w - lborder - rborder ;
        if (max_height < def.h - tborder - bborder)
                max_height = def.h - tborder - bborder ;
}

void
wsetmaxwinsize (width, height)
        int     width ;
        int     height ;
{
        if (width < MIN_WIDTH)
                width = MIN_WIDTH ;
        if (width > scr_width - lborder - rborder)
                width = scr_width - lborder - rborder ;

        if (height < MIN_HEIGHT)
                height = MIN_HEIGHT ;
        if (height > scr_height - BAR_HEIGHT - tborder - bborder)
                height = scr_height - BAR_HEIGHT - tborder - bborder ;

        max_width = width ;
        max_height = height ;

        if (def.w > max_width + lborder + rborder)
                def.w = max_width + lborder + rborder ;
        if (def.h > max_height + tborder + bborder)
                def.h = max_height + tborder + bborder ;
}

void
wsetdefwinpos (h, v)
        int     h;
        int     v;
{
        if (h < 0)
                h = 0 ;
        if (h > scr_width - 1)
                h = scr_width - 1 ;

        if (v < BAR_HEIGHT)
                v = BAR_HEIGHT ;
        if (v > scr_height - 1)
                v = scr_height - 1 ;

        def.x = h ;
        def.y = v ;
}

void
wgetwinsize (win, pwidth, pheight)
        WINDOW  *win ;
        int     *pwidth ;
        int     *pheight ;
{
        if (win == NULL) {
                wdebug ("wgetwinsize: illegal window pointer") ;
                return ;
        }

        *pwidth = win->width ;
        *pheight = win->height ;
}

_setsize (win, h, v, width, height)
        WINDOW  *win ;
        int     h ;
        int     v ;
        int     width ;
        int     height ;
{
        win->h = h + lborder ;
        win->v = v + tborder ;
        win->width = width - lborder - rborder ;
        win->height = height - tborder - bborder ;
}

void
wsettimer (win, dtime)
        WINDOW  *win ;
        int     dtime ;
{
        if (win == NULL) {
                wdebug ("wsettimer: illegal window pointer") ;
                return ;
        }

        if (dtime > 0) {
                msec    currtime ;

                currtime = MSTIME () ;
                win->alarm = currtime + (dtime * 100L) ;
        }
        else {
                if (dtime != 0)
                        wdebug ("timer negative") ;
                win->alarm = 0L ;
        }
}

void
wfleep ()
{
        write (1, "\07\07", 2) ;
}

int
wdebug (fmt, a0, a1, a2, a3, a4, a5, a6, a7, a8, a9)
        char    *fmt ;
{
        char    buf[256] ;

        strcpy (buf, "[3][__") ;
        sprintf (buf+4, fmt, a0, a1, a2, a3, a4, a5, a6, a7, a8, a9) ;
        strcat (buf, "__][abort|cont]") ;

        if (form_alert (2, buf) == 1) {
                wdone () ;
                exit (1) ;
        }
}

int
wlineheight ()
{
        return (chheight) ;
}

int
wtextwidth (str, len)
        char    *str ;
        int     len ;
{
        int     dummy ;
        int     sizes[5] ;
        int     adjust[3] ;
        int     str_len = len == -1 ? strlen (str) : len ;

        /*
        ** The width of one character on the ATARI with a monochrome display
        ** and default attributes is "chwidth" pixels. The only thing we have to
        ** calculate is the adjustment for the 'special effects'.
        */

        vqt_font_info (vdi_handle, &dummy, &dummy, sizes, &dummy, adjust) ;

        return (str_len * (chwidth + adjust[0])) ;
}

int
wcharwidth (c)
        int     c ;
{
        char    buf[2] ;

        buf[0] = c ;
        buf[1] = 0 ;

        return (wtextwidth (buf, 1)) ;
}
