#include "window.h"

extern int      vdi_handle ;

bool
getsrcdiff (win, RECT, dh, dv, snit, diff, nr_diff)
        WINDOW  *win ;
        int     RECT ;
        int     dh ;
        int     dv ;
        int     *snit ;
        int     diff[][4] ;
        int     *nr_diff ;
{
        int     src[4] = { left, top, right, bottom } ;
        int     orgh = win->orgh ;
        int     orgv = win->orgv ;
        int     width = win->width ;
        int     height = win->height ;

        if (dh > 0)
                src[2] -= dh ;
        if (dh < 0)
                src[0] -= dh ;

        if (dv > 0)
                src[3] -= dv ;
        if (dv < 0)
                src[1] -= dv ;

        /*
        ** Clip the rectangle with the window to get the clean source ...
        */

        snit[0] = orgh ;
        snit[1] = orgv ;
        snit[2] = orgh + width ;
        snit[3] = orgv + height ;
/*wdebug ("      l   r   t   b|src  %3d %3d %3d %3d|snit %3d %3d %3d %3d", src[0],
        src[1], src[2], src[3], snit[0], snit[1], snit[2], snit[3]) ;
*/      if (!intersect (src, snit)) {
/*wdebug ("no intersection") ;
*/              *nr_diff = 1 ;
                diff[0][0] = orgh - dh ;
                diff[0][1] = orgv - dv ;
                diff[0][2] = orgh + width - dh ;
                diff[0][3] = orgv + height - dv ;

                return (FALSE) ;
        }
/*wdebug ("      l   r   t   b|src  %3d %3d %3d %3d|snit %3d %3d %3d %3d", src[0],
        src[1], src[2], src[3], snit[0], snit[1], snit[2], snit[3]) ;
*/      rectsubt (src, snit, diff, nr_diff) ;

        return (TRUE) ;
}

void
scrollby (win, RECT, dh, dv)
        WINDOW  *win ;
        int     RECT ;
        int     dh ;
        int     dv ;
{
        FDB     dummy = { 0L, 0, 0, 0, 0, 0, 0, 0, 0 } ;
        int     logic = 3 ;
        int     xyarray[8] ;
        bool    mouseoff = FALSE ;
        int     status ;
        int     m_h ;
        int     m_v ;

        DOCTOSCR (win, left, top, xyarray[0], xyarray[1]) ;
        DOCTOSCR (win, right - 1, bottom - 1, xyarray[2], xyarray[3]) ;

        DOCTOSCR (win, left + dh, top + dv, xyarray[4], xyarray[5]) ;
        DOCTOSCR (win, right + dh - 1, bottom + dv - 1, xyarray[6], xyarray[7]) ;

        vq_mouse (vdi_handle, &status, &m_h, &m_v) ;

        if (m_h > win->h - wlineheight () &&
            m_h < win->h + win->width + wlineheight () &&
            m_v > win->v - 2 * wcharwidth ('m') &&
            m_v < win->v + win->height + 2 * wcharwidth ('m')) {
                mouseoff = TRUE ;
                graf_mouse (M_OFF, &dummy) ;
        }

        wind_update (BEG_UPDATE) ;

        setclip (win, 1, win->orgh, win->orgv, win->orgh + win->width,
                                                win->orgv + win->height) ;

        vro_cpyfm (vdi_handle, logic, xyarray, &dummy, &dummy) ;

        setclip (win, 0, win->orgh, win->orgv, win->orgh + win->width,
                                                win->orgv + win->height) ;

        wind_update (END_UPDATE) ;

        if (mouseoff)
                graf_mouse (M_ON, &dummy) ;
}

void
wscroll (win, RECT, dh, dv)
        WINDOW  *win ;
        int     RECT ;
        int     dh ;
        int     dv ;
{
        int     src[4] ;
        int     diff[4][4] ;
        int     nr_diff ;
        int     i ;
        int     changed[4] ;

        if (win == NULL) {
                wdebug ("wscroll: illegal window pointer") ;
                return ;
        }

        rmcaret () ;

        if (left >= right || top >= bottom || (dh == 0 && dv == 0))
                return ;

        if (getsrcdiff (win, RECT, dh, dv, src, diff, &nr_diff))
                scrollby (win, src[0], src[1], src[2], src[3], dh, dv) ;

        wgetchange (win, &changed[0], &changed[1], &changed[2], &changed[3]) ;
        if (intersect (src, changed))
                wchange (win, changed[0] + dh, changed[1] + dv,
                                changed[2] + dh, changed[3] + dv) ;

        for (i = 0 ; i < nr_diff ; i++) {
                wchange (win, diff[i][0] + dh, diff[i][1] + dv,
                                diff[i][2] + dh, diff[i][3] + dv) ;
        }

        showcaret () ;

        wupdate (win) ;
}

void
setscrollbars (win)
        WINDOW  *win ;
{
        int     dummy ;
        int     old ;
        int     size ;
        int     pos ;
        int     win_width = win->width ;
        int     win_height = win->height;
        int     doc_width = win->doc_width ;
        int     doc_height = win->doc_height ;
        int     orgh = win->orgh ;
        int     orgv = win->orgv ;

        if (doc_width <= win_width) {
                size = 1000 ;
                pos = 0 ;
        }
        else {
                size = (long) win_width * 1000L / (long) doc_width ;
                pos = (long) orgh * 1000L / (long) (doc_width - win_width) ;
        }

        if (size > 1000)
                size = 1000 ;

        wind_get (win->handle, WF_HSLIDE, &old, &dummy, &dummy, &dummy) ;
        if (old != pos)
                wind_set (win->handle, WF_HSLIDE, pos, dummy, dummy, dummy) ;
        wind_get (win->handle, WF_HSLSIZE, &old, &dummy, &dummy, &dummy) ;
        if (old != size)
                wind_set (win->handle, WF_HSLSIZE, size, dummy, dummy, dummy) ;

        if (doc_height <= win_height) {
                size = 1000 ;
                pos = 0 ;
        }
        else {
                size = win_height * 1000L / (long) doc_height ;
                pos = orgv * 1000L / (long) (doc_height - win_height) ;
        }

        if (size > 1000)
                size = 1000 ;

        wind_get (win->handle, WF_VSLIDE, &old, &dummy, &dummy, &dummy) ;
        if (old != pos)
                wind_set (win->handle, WF_VSLIDE, pos, dummy, dummy, dummy) ;
        wind_get (win->handle, WF_VSLSIZE, &old, &dummy, &dummy, &dummy) ;
        if (old != size)
                wind_set (win->handle, WF_VSLSIZE, size, dummy, dummy, dummy) ;
}

void
do_scroll (msg_buf)
        int     msg_buf[8] ;
{
#define HOR_STEP        (width / 10 <= 0 ? wcharwidth ('m') :\
                                                        width / 10)

        WINDOW  *win = getwin (msg_buf[3]) ;
        int     orgh = win->orgh ;
        int     orgv = win->orgv ;
        int     width = win->width ;
        int     height = win->height ;
        int     dummy = 0 ;

        if (win == NULL) {
                wdebug ("do_scroll: window doesn't belong to me") ;
                return ;
        }

        if (msg_buf[0] == WM_ARROWED) {
                switch (msg_buf[4]) {
                case 0 :        /* Page up */
                        orgv -= (height - wlineheight ()) ;
                        break ;
                case 1 :        /* Page down */
                        orgv += (height - wlineheight ()) ;
                        break ;
                case 2 :        /* Arrow up */
                        orgv -= wlineheight () ;
                        break ;
                case 3 :        /* Arrow down */
                        orgv += wlineheight () ;
                        break ;
                case 4 :        /* Page left */
                        orgh -= (width - HOR_STEP) ;
                        break ;
                case 5 :        /* Page right */
                        orgh += (width - HOR_STEP) ;
                        break ;
                case 6 :        /* Arrow left */
                        orgh -= HOR_STEP ;
                        break ;
                case 7 :        /* Arrow right */
                        orgh += HOR_STEP ;
                        break ;
                }
        }
        else if (msg_buf[0] == WM_HSLID)
                orgh = (long) msg_buf[4] * (long) (win->doc_width - width)
                                                                / 1000L ;
        else
                orgv = (long) msg_buf[4] * (long) (win->doc_height - height)
                                                                / 1000L;

        wsetorigin (win, orgh, orgv) ;

#undef HOR_STEP
}

rectsubt (a, b, diff, nr_diff)
        int     *a ;
        int     *b ;
        int     diff[][4] ;
        int     *nr_diff ;
{
        int     i = 0 ;

        *nr_diff = 0 ;
/*wdebug ("   l   t   r   b|a %3d %3d %3d %3d|b %3d %3d %3d %3d", a[0], a[1],
        a[2], a[3], b[0], b[1], b[2], b[3]) ;
*/      if (a[LEFT] < b[LEFT]) {
/*wdebug ("left") ;
*/              diff[i][LEFT] = a[LEFT] ;
                diff[i][TOP] = a[TOP] ;
                diff[i][RIGHT] = b[LEFT] ;
                diff[i][BOTTOM] = a[BOTTOM] ;
                i++ ;

                if (a[RIGHT] < b[LEFT]) {
/*wdebug ("outside") ;
*/                      diff[i - 1][RIGHT] = a[RIGHT] ;
                        *nr_diff = i ;
                        return ;
                }
        }

        if (a[RIGHT] > b[RIGHT]) {
/*wdebug ("right") ;
*/              diff[i][LEFT] = b[RIGHT] ;
                diff[i][TOP] = a[TOP] ;
                diff[i][RIGHT] = a[RIGHT] ;
                diff[i][BOTTOM] = a[BOTTOM] ;
                i += 1 ;

                if (a[LEFT] > b[RIGHT]) {
/*wdebug ("outside") ;
*/                      diff[i - 1][LEFT] = a[LEFT] ;
                        *nr_diff = i ;
                        return ;
                }
        }

        if (a[TOP] < b[TOP]) {
/*wdebug ("top") ;
*/              diff[i][LEFT] = a[LEFT] ;
                diff[i][TOP] = a[TOP] ;
                diff[i][RIGHT] = a[RIGHT] ;
                diff[i][BOTTOM] = b[TOP] ;
                i += 1 ;

                if (a[BOTTOM] < b[TOP]) {
/*wdebug ("outside") ;
*/                      diff[i - 1][BOTTOM] = a[BOTTOM] ;
                        *nr_diff = i ;
                        return ;
                }
        }

        if (a[BOTTOM] > b[BOTTOM]) {
/*wdebug ("bottom") ;
*/              diff[i][LEFT] = a[LEFT] ;
                diff[i][TOP] = b[BOTTOM] ;
                diff[i][RIGHT] = a[RIGHT] ;
                diff[i][BOTTOM] = a[BOTTOM] ;
                i += 1 ;

                if (a[TOP] > b[BOTTOM]) {
/*wdebug ("outside") ;
*/                      diff[i - 1][TOP] = a[TOP] ;
                        *nr_diff = i ;
                        return ;
                }
        }
/*wdebug ("nr rect %d", i) ;
*/      *nr_diff = i ;
}

void
autoscroll (win, h, v)
        WINDOW  *win ;
        int     h ;
        int     v ;
{
        int     dh = 0 ;
        int     dv = 0 ;

        if (win == NULL)
                return ;

        if (h < win->h)
                dh = h - win->h ;
        else if (h > win->h + win->width)
                dh = h - (win->h + win->width) ;

        if (v < win->v)
                dv = v - win->v ;
        else if (v > win->v + win->height)
                dv = v - (win->v + win->height) ;

        if (dh != 0 || dv != 0) {
                int     orgh = win->orgh + dh ;
                int     orgv = win->orgv + dv ;

                wsetorigin (win, orgh, orgv) ;
        }
}
