#include <osbind.h>
#include <string.h>
#include "window.h"
#include "trees.h"

#define REV     0x110f1L
#define MAXLEN  40

#define NDEF_FLAG       (SELECTABLE | EXIT)
#define DEF_FLAG        (SELECTABLE | EXIT | DEFAULT)

static char     curdir[256] ;

int
waskfile (prompt, buf, buflen, new)
        char    *prompt ;
        char    *buf ;
        int     buflen ;
        int     new ;
{
        static char     dir[256] ;
        static char     fname[256] ;
        char    *p = dir ;
        int     button ;

        if (!*dir) {
                int     drive ;

                drive = Dgetdrv () ;
                *p++ = (char) drive + 'A' ;
                *p++ = ':' ;
                Dgetpath (p, drive + 1) ;
                strcat (dir, "\\*.*") ;
                strcpy (curdir, dir) ;
        }

        if (*buf) {
                char    *pdir ;

                p = strrchr (buf, '\\') ;

                if (buf[1] == ':')      /* buf contains full path name */
                        pdir = dir ;
                else
                        pdir = &dir[2] ;

                if (p) {
                        strncpy (pdir, buf, (int) (p - buf)) ;
                        strcat (dir, "\\*.*") ;
                        strcpy (fname, &buf[(int) (p - buf) + 1]) ;
                }
                else
                        strcpy (fname, buf) ;
        }

        if (!fsel_input (dir, fname, &button)) {
                wdebug ("waskfile: fsel_input") ;
                buf[0] = '\0' ;
                return (FALSE) ;
        }

        if (!button) {
                buf[0] = '\0' ;
                return (FALSE) ;
        }

        if ((p = strrchr (dir, '\\')) == NULL)
                p = dir ;

        if (strncmp (curdir, dir, (int) (p - dir)) == 0) {
                strcpy (buf, fname) ;
                return (TRUE) ;
        }

        if (buflen < ((int) (p - dir + 1) + strlen (fname))) {
                wdebug ("waskfile: buffer not long enough") ;
                buf[0] = '\0' ;
                return (FALSE) ;
        }

        strncpy (buf, dir, (int) (p - dir) + 1) ;
        buf[(int) (p - dir) + 1] = 0 ;
        strcat (buf, fname) ;

        return (TRUE) ;
}

TEDINFO
*tedinfo (buf, len)
        char    *buf ;
        int     len ;
{
        TEDINFO *e = ALLOC (TEDINFO) ;
        char    *tmpl = malloc (len) ;
        char    *valid = malloc (len) ;
        int     str_len = strlen (buf) ;
        int     i ;

        for (i = 0 ; i < len - 1 ; i++) {
                /*if (i >= str_len)
                        buf[i] = '@' ;*/
                tmpl[i] = '_' ;
                valid[i] = 'X' ;
        }
        buf[len-1] = tmpl[len-1] = valid[len-1] = '\0' ;

        e->te_ptext = buf ;
        e->te_ptmplt = tmpl ;
        e->te_pvalid = valid ;
        e->te_font = IBM ;
        e->te_junk1 = 0 ;
        e->te_just = TE_LEFT ;
        e->te_color = 0x01f0 ;
        e->te_junk2 = 0 ;
        e->te_thickness = 0 ;
        e->te_txtlen = len - 1 ;
        e->te_tmplen = len - 1 ;

        return (e) ;
}

OBJECT
*str_obj (prompt, buf, buflen)
        char    *prompt ;
        char    *buf ;
        int     buflen ;
{
        TREE    tree = { 0, 0, 0 } ;
        TREE    *t = &tree ;
        TEDINFO *edit ;
        int     lh = wlineheight () ;
        int     cw = wcharwidth ('m') ;
        int     pr_width = wtextwidth (prompt, -1) ;
        int     buf_width = buflen <= 40 ? buflen * cw : 40 * cw ;
        int     but_width = 17 * cw ;
                        /*
                        ** 12 for the characters, 3 for the space around the
                        ** buttons and 2 for the borders of the buttons
                        */
        int     box_width ;
        int     box_height = 8 * lh + 6 ;

        box_width = (pr_width > buf_width ?
                        (pr_width > but_width ? pr_width : but_width) :
                        (buf_width > but_width ? buf_width : but_width))
                + 6 * cw + 6 ;

        tr_add (t, 0, G_BOX, NONE, NORMAL, BAR, 0, 0, box_width, box_height) ;
        tr_add (t, 1, G_BOX, NONE, NORMAL, BAR, 3, 3, box_width - 6,
                                                        box_height - 6) ;
        tr_add (t, 1, G_STRING, NONE, NORMAL, prompt, 3 * cw, lh, pr_width, lh);

        edit = tedinfo (buf, buflen > 40 ? 40 : buflen) ;
        tr_add (t, 0, G_FTEXT ,NONE, NORMAL, edit, 3 * cw, 5 * lh / 2,
                                                        buf_width, 2 * lh) ;

        tr_add (t, 0, G_BUTTON, DEF_FLAG, NORMAL, " Ok ", 3 * cw, 6 * lh,
                                                                4 * cw, lh) ;
        tr_add (t, 0, G_BUTTON, NDEF_FLAG, NORMAL, " Cancel ",
                                box_width - 15 * cw, 6 * lh, 8 * cw, lh) ;

        return (tr_tree (t)) ;
}

int
waskstr (prompt, buf, buflen)
        char    *prompt ;
        char    *buf ;
        int     buflen ;
{
        OBJECT  *dialog = str_obj (prompt, buf, buflen) ;
        Rect    tmpbox ;
        int     dummy ;
        int     rc ;

        graf_mouse (ARROW, &dummy) ;

        form_center (dialog, &tmpbox.x, &tmpbox.y, &tmpbox.w, &tmpbox.h) ;
        form_dial (0, 1, 1, 1, 1, tmpbox) ;

        objc_draw (dialog, ROOT, MAX_DEPTH, tmpbox) ;

        rc = form_do (dialog, 3) ;

        form_dial (3, 1, 1, 1, 1, tmpbox) ;

        graf_mouse (BUSY_BEE, &dummy) ;

        if (rc == 5) {  /*      Cancel  */
                buf[0] = '\0' ;
                return (FALSE) ;
        }
        return (TRUE) ;
}

int
waskync (question, def)
        char    *question ;
        int     def ;
{
        char    buf[256] ;

        strcpy (buf, "[2][") ;
        if (strlen (question) >= 16)
                strcat (buf, question) ;
        else
                sprintf (buf + 4, "%-16s", question) ;
        strcat (buf, "][Yes|No|Cancel]") ;

        return (2 - form_alert (2 - def, buf)) ;
}

void
wmessage (str)
        char    *str ;
{
        char    buf[256] ;

        strcpy (buf, "[1][") ;
        strcat (buf, str) ;
        strcat (buf, "][ Ok ]") ;

        (void) form_alert (1, buf) ;

        return ;
}
