--
-- Selected TOC Entries:
--
\connect - postgres

--
-- TOC Entry ID 69 (OID 10698067)
--
-- Name: "plpgsql_call_handler" () Type: FUNCTION Owner: postgres
--

CREATE FUNCTION "plpgsql_call_handler" () RETURNS opaque AS '$libdir/plpgsql', 'plpgsql_call_handler' LANGUAGE 'C';

--
-- TOC Entry ID 70 (OID 10698068)
--
-- Name: plpgsql Type: PROCEDURAL LANGUAGE Owner: 
--

CREATE TRUSTED PROCEDURAL LANGUAGE 'plpgsql' HANDLER "plpgsql_call_handler" LANCOMPILER '';


--
-- TOC Entry ID 2 (OID 215124)
--
-- Name: auth_accounts_id_seq Type: SEQUENCE Owner: postgres
--

CREATE SEQUENCE "auth_accounts_id_seq" start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;

--
-- TOC Entry ID 4 (OID 215126)
--
-- Name: auth_groups_id_seq Type: SEQUENCE Owner: postgres
--

CREATE SEQUENCE "auth_groups_id_seq" start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;

--
-- TOC Entry ID 6 (OID 215130)
--
-- Name: auth_permissions_id_seq Type: SEQUENCE Owner: postgres
--

CREATE SEQUENCE "auth_permissions_id_seq" start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;

--
-- TOC Entry ID 8 (OID 215132)
--
-- Name: auth_permlink_id_seq Type: SEQUENCE Owner: postgres
--

CREATE SEQUENCE "auth_permlink_id_seq" start 5 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;

--
-- TOC Entry ID 10 (OID 215134)
--
-- Name: dm_cat_permissions_id_seq Type: SEQUENCE Owner: postgres
--

CREATE SEQUENCE "dm_cat_permissions_id_seq" start 1 increment 1 maxvalue 2147483647 minvalue 1 cache 1;

--
-- TOC Entry ID 12 (OID 215136)
--
-- Name: dm_category_id_seq Type: SEQUENCE Owner: postgres
--

CREATE SEQUENCE "dm_category_id_seq" start 1 increment 1 maxvalue 2147483647 minvalue 1 cache 1;

--
-- TOC Entry ID 14 (OID 215138)
--
-- Name: dm_discussion_id_seq Type: SEQUENCE Owner: postgres
--

CREATE SEQUENCE "dm_discussion_id_seq" start 1 increment 1 maxvalue 2147483647 minvalue 1 cache 1;

--
-- TOC Entry ID 16 (OID 215140)
--
-- Name: dm_docindex_id_seq Type: SEQUENCE Owner: postgres
--

CREATE SEQUENCE "dm_docindex_id_seq" start 1 increment 1 maxvalue 2147483647 minvalue 1 cache 1;

--
-- TOC Entry ID 18 (OID 215142)
--
-- Name: dm_file_cat_id_seq Type: SEQUENCE Owner: postgres
--

CREATE SEQUENCE "dm_file_cat_id_seq" start 1 increment 1 maxvalue 2147483647 minvalue 1 cache 1;

--
-- TOC Entry ID 20 (OID 215144)
--
-- Name: dm_file_history_id_seq Type: SEQUENCE Owner: postgres
--

CREATE SEQUENCE "dm_file_history_id_seq" start 1 increment 1 maxvalue 2147483647 minvalue 1 cache 1;

--
-- TOC Entry ID 22 (OID 215146)
--
-- Name: dm_file_log_id_seq Type: SEQUENCE Owner: postgres
--

CREATE SEQUENCE "dm_file_log_id_seq" start 1 increment 1 maxvalue 2147483647 minvalue 1 cache 1;

--
-- TOC Entry ID 24 (OID 215148)
--
-- Name: dm_file_view_id_seq Type: SEQUENCE Owner: postgres
--

CREATE SEQUENCE "dm_file_view_id_seq" start 1 increment 1 maxvalue 2147483647 minvalue 1 cache 1;

--
-- TOC Entry ID 26 (OID 215150)
--
-- Name: dm_object_id_seq Type: SEQUENCE Owner: postgres
--

CREATE SEQUENCE "dm_object_id_seq" start 1 increment 1 maxvalue 2147483647 minvalue 1 cache 1;

--
-- TOC Entry ID 28 (OID 215152)
--
-- Name: site_properties_id_seq Type: SEQUENCE Owner: postgres
--

CREATE SEQUENCE "site_properties_id_seq" start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;

--
-- TOC Entry ID 32 (OID 215154)
--
-- Name: auth_accounts Type: TABLE Owner: postgres
--

CREATE TABLE "auth_accounts" (
	"id" integer DEFAULT nextval('"auth_accounts_id_seq"'::text) NOT NULL,
	"login" text NOT NULL,
	"password" text NOT NULL,
	"first_name" text,
	"last_name" text,
	"enable" smallint DEFAULT 1 NOT NULL,
	"email" text,
	"auth_objectid" integer DEFAULT nextval('"auth_object_seq"'::text),
	Constraint "auth_accounts_pkey" Primary Key ("id")
);

--
-- TOC Entry ID 33 (OID 215160)
--
-- Name: auth_cookies Type: TABLE Owner: postgres
--

CREATE TABLE "auth_cookies" (
	"id" bigint NOT NULL,
	"accountid" integer NOT NULL,
	Constraint "auth_cookies_pkey" Primary Key ("id")
);

--
-- TOC Entry ID 34 (OID 215163)
--
-- Name: auth_grouplink Type: TABLE Owner: postgres
--

CREATE TABLE "auth_grouplink" (
	"accountid" integer NOT NULL,
	"groupid" integer NOT NULL
);

--
-- TOC Entry ID 35 (OID 215165)
--
-- Name: auth_groups Type: TABLE Owner: postgres
--

CREATE TABLE "auth_groups" (
	"id" integer DEFAULT nextval('"auth_groups_id_seq"'::text) NOT NULL,
	"name" text NOT NULL,
	"auth_objectid" integer DEFAULT nextval('"auth_object_seq"'::text),
	Constraint "auth_groups_pkey" Primary Key ("id")
);

--
-- TOC Entry ID 36 (OID 215177)
--
-- Name: auth_permissions Type: TABLE Owner: postgres
--

CREATE TABLE "auth_permissions" (
	"id" integer DEFAULT nextval('"auth_permissions_id_seq"'::text) NOT NULL,
	"name" text NOT NULL,
	"bitpos" integer NOT NULL,
	"appid" integer NOT NULL,
	"owner" smallint DEFAULT 0,
	Constraint "auth_permissions_pkey" Primary Key ("id")
);

--
-- TOC Entry ID 37 (OID 215183)
--
-- Name: auth_permlink Type: TABLE Owner: postgres
--

CREATE TABLE "auth_permlink" (
	"auth_objectid" integer NOT NULL,
	"bitset" integer NOT NULL,
	"appid" integer NOT NULL,
	Constraint "auth_permlink_pkey" Primary Key ("auth_objectid")
);

--
-- TOC Entry ID 38 (OID 215186)
--
-- Name: dm_cat_permissions Type: TABLE Owner: postgres
--

CREATE TABLE "dm_cat_permissions" (
	"cat_id" integer NOT NULL,
	"group_id" integer NOT NULL,
	"bitset" integer
);

--
-- TOC Entry ID 39 (OID 215188)
--
-- Name: dm_category Type: TABLE Owner: postgres
--

CREATE TABLE "dm_category" (
	"id" integer DEFAULT nextval('"dm_category_id_seq"'::text) NOT NULL,
	"name" text NOT NULL,
	"owner" bigint NOT NULL,
	Constraint "dm_category_pkey" Primary Key ("id")
);

--
-- TOC Entry ID 40 (OID 215194)
--
-- Name: dm_discussion Type: TABLE Owner: postgres
--

CREATE TABLE "dm_discussion" (
	"id" integer DEFAULT nextval('"dm_discussion_id_seq"'::text) NOT NULL,
	"object_id" bigint NOT NULL,
	"thread" text,
	"account_id" bigint NOT NULL,
	"message" text,
	"date" date NOT NULL,
	"owner" bigint NOT NULL,
	Constraint "dm_discussion_pkey" Primary Key ("id")
);

--
-- TOC Entry ID 41 (OID 215200)
--
-- Name: dm_docindex Type: TABLE Owner: postgres
--

CREATE TABLE "dm_docindex" (
	"id" integer DEFAULT nextval('"dm_docindex_id_seq"'::text) NOT NULL,
	"word" text NOT NULL,
	Constraint "docindex_pkey" Primary Key ("id")
);

--
-- TOC Entry ID 42 (OID 215206)
--
-- Name: dm_doclink Type: TABLE Owner: postgres
--

CREATE TABLE "dm_doclink" (
	"file_id" bigint NOT NULL,
	"word_id" bigint NOT NULL,
	"page_id" integer NOT NULL
);

--
-- TOC Entry ID 43 (OID 215208)
--
-- Name: dm_file_cat Type: TABLE Owner: postgres
--

CREATE TABLE "dm_file_cat" (
	"id" integer DEFAULT nextval('"dm_file_cat_id_seq"'::text) NOT NULL,
	"file_id" bigint NOT NULL,
	"cat_id" integer NOT NULL,
	Constraint "dm_file_cat_pkey" Primary Key ("id")
);

--
-- TOC Entry ID 44 (OID 215211)
--
-- Name: dm_file_history Type: TABLE Owner: postgres
--

CREATE TABLE "dm_file_history" (
	"id" integer DEFAULT nextval('"dm_file_history_id_seq"'::text) NOT NULL,
	"object_id" bigint NOT NULL,
	"size" text NOT NULL,
	"version" bigint DEFAULT 1 NOT NULL,
	"modify" timestamp with time zone NOT NULL,
	"owner_id" bigint NOT NULL,
	Constraint "dm_file_history_pkey" Primary Key ("id")
);

--
-- TOC Entry ID 45 (OID 215217)
--
-- Name: dm_file_log Type: TABLE Owner: postgres
--

CREATE TABLE "dm_file_log" (
	"id" integer DEFAULT nextval('"dm_file_log_id_seq"'::text) NOT NULL,
	"object_id" bigint NOT NULL,
	"entry" text NOT NULL,
	"account_id" integer,
	"date" timestamp with time zone,
	Constraint "dm_file_log_pkey" Primary Key ("id")
);

--
-- TOC Entry ID 46 (OID 215223)
--
-- Name: dm_file_permissions Type: TABLE Owner: postgres
--

CREATE TABLE "dm_file_permissions" (
	"object_id" bigint NOT NULL,
	"auth_objectid" integer NOT NULL,
	"bitset" integer
);

--
-- TOC Entry ID 47 (OID 215225)
--
-- Name: dm_file_view Type: TABLE Owner: postgres
--

CREATE TABLE "dm_file_view" (
	"id" integer DEFAULT nextval('"dm_file_view_id_seq"'::text) NOT NULL,
	"file_path" text NOT NULL,
	"user_id" integer NOT NULL,
	Constraint "dm_file_view_pkey" Primary Key ("id")
);

--
-- TOC Entry ID 48 (OID 215231)
--
-- Name: dm_object Type: TABLE Owner: postgres
--

CREATE TABLE "dm_object" (
	"id" integer DEFAULT nextval('"dm_object_id_seq"'::text) NOT NULL,
	"name" text NOT NULL,
	"version" integer DEFAULT 1 NOT NULL,
	"status" smallint NOT NULL,
	"status_date" timestamp with time zone,
	"summary" text,
	"description" text,
	"create_date" timestamp with time zone,
	"status_owner" integer,
	"file_owner" integer,
	Constraint "dm_object_pkey" Primary Key ("id")
);

--
-- TOC Entry ID 67 (OID 215237)
--
-- Name: "wordindex" (text) Type: FUNCTION Owner: postgres
--

CREATE FUNCTION "wordindex" (text) RETURNS bigint AS '    DECLARE\015
        wordValue ALIAS FOR $1;\015
        wordid INT8;\015
    BEGIN\015
  \015
    SELECT INTO wordid * FROM dm_docindex WHERE word = wordValue;\015
     	\015
  	IF wordid IS NULL THEN\015
   \015
              	INSERT INTO dm_docindex (word) VALUES (wordValue);\015
        	SELECT INTO wordid id FROM dm_docindex WHERE word = wordValue;\015
         	                \015
        END IF;\015
      \015
       	RETURN wordid;\015
\015
    END;\015
\015
\015
' LANGUAGE 'plpgsql';

\connect - postgres

--
-- TOC Entry ID 30 (OID 215409)
--
-- Name: auth_object_seq Type: SEQUENCE Owner: postgres
--

CREATE SEQUENCE "auth_object_seq" start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;

--
-- TOC Entry ID 49 (OID 215411)
--
-- Name: site_properties Type: TABLE Owner: postgres
--

CREATE TABLE "site_properties" (
	"id" integer DEFAULT nextval('"site_properties_id_seq"'::text) NOT NULL,
	"module_name" text NOT NULL,
	"module_type" smallint DEFAULT '1' NOT NULL,
	"module_directory" text NOT NULL,
	"define_name" text NOT NULL,
	"sort_order" smallint,
	"hidden" smallint NOT NULL,
	"auth_only" smallint,
	"perm_name" text,
	"perm_message" text,
	"owner" integer NOT NULL
);

\connect - postgres

--
-- Data for TOC Entry ID 68 (OID 215154)
--
-- Name: auth_accounts Type: TABLE DATA Owner: postgres
--


INSERT INTO "auth_accounts" VALUES (1,'admin','21232f297a57a5a743894a0e4a801fc3','Administrator','',1,'',1);
--
-- Data for TOC Entry ID 69 (OID 215160)
--
-- Name: auth_cookies Type: TABLE DATA Owner: postgres
--


--
-- Data for TOC Entry ID 70 (OID 215163)
--
-- Name: auth_grouplink Type: TABLE DATA Owner: postgres
--


INSERT INTO "auth_grouplink" VALUES (1,1);
INSERT INTO "auth_grouplink" VALUES (4,2);
INSERT INTO "auth_grouplink" VALUES (5,3);
--
-- Data for TOC Entry ID 71 (OID 215165)
--
-- Name: auth_groups Type: TABLE DATA Owner: postgres
--


INSERT INTO "auth_groups" VALUES (1,'Administrators',2);
INSERT INTO "auth_groups" VALUES (2,'Users',3);
INSERT INTO "auth_groups" VALUES (3,'Guest',4);
--
-- Data for TOC Entry ID 72 (OID 215177)
--
-- Name: auth_permissions Type: TABLE DATA Owner: postgres
--


INSERT INTO "auth_permissions" VALUES (1,'Administrator',1,1,0);
INSERT INTO "auth_permissions" VALUES (9,'Can alter own profile',9,1,0);
INSERT INTO "auth_permissions" VALUES (8,'Can view Admin Menu',2,1,0);
INSERT INTO "auth_permissions" VALUES (5,'Can view other users'' files',6,1,0);
INSERT INTO "auth_permissions" VALUES (6,'Can insert files',7,1,0);
INSERT INTO "auth_permissions" VALUES (7,'Can checkout/update other users'' files',8,1,0);
INSERT INTO "auth_permissions" VALUES (2,'Can manage other users',3,1,2);
INSERT INTO "auth_permissions" VALUES (3,'Can manage groups',4,1,2);
INSERT INTO "auth_permissions" VALUES (4,'Can manage categories',5,1,2);
--
-- Data for TOC Entry ID 73 (OID 215183)
--
-- Name: auth_permlink Type: TABLE DATA Owner: postgres
--


INSERT INTO "auth_permlink" VALUES (2,3,1);
INSERT INTO "auth_permlink" VALUES (1,3,1);
INSERT INTO "auth_permlink" VALUES (0,1,1);
INSERT INTO "auth_permlink" VALUES (3,997,1);
INSERT INTO "auth_permlink" VALUES (4,65,1);
INSERT INTO "auth_permlink" VALUES (8,1,1);
INSERT INTO "auth_permlink" VALUES (9,1,1);
--
-- Data for TOC Entry ID 74 (OID 215186)
--
-- Name: dm_cat_permissions Type: TABLE DATA Owner: postgres
--


--
-- Data for TOC Entry ID 75 (OID 215188)
--
-- Name: dm_category Type: TABLE DATA Owner: postgres
--


INSERT INTO "dm_category" VALUES (3,'Personal Folders','0');
INSERT INTO "dm_category" VALUES (2,'Imported','0');
INSERT INTO "dm_category" VALUES (1,'Unassigned','0');
--
-- Data for TOC Entry ID 76 (OID 215194)
--
-- Name: dm_discussion Type: TABLE DATA Owner: postgres
--


--
-- Data for TOC Entry ID 77 (OID 215200)
--
-- Name: dm_docindex Type: TABLE DATA Owner: postgres
--


--
-- Data for TOC Entry ID 78 (OID 215206)
--
-- Name: dm_doclink Type: TABLE DATA Owner: postgres
--


--
-- Data for TOC Entry ID 79 (OID 215208)
--
-- Name: dm_file_cat Type: TABLE DATA Owner: postgres
--


--
-- Data for TOC Entry ID 80 (OID 215211)
--
-- Name: dm_file_history Type: TABLE DATA Owner: postgres
--


--
-- Data for TOC Entry ID 81 (OID 215217)
--
-- Name: dm_file_log Type: TABLE DATA Owner: postgres
--


--
-- Data for TOC Entry ID 82 (OID 215223)
--
-- Name: dm_file_permissions Type: TABLE DATA Owner: postgres
--


--
-- Data for TOC Entry ID 83 (OID 215225)
--
-- Name: dm_file_view Type: TABLE DATA Owner: postgres
--


--
-- Data for TOC Entry ID 84 (OID 215231)
--
-- Name: dm_object Type: TABLE DATA Owner: postgres
--


\connect - postgres

--
-- Data for TOC Entry ID 85 (OID 215411)
--
-- Name: site_properties Type: TABLE DATA Owner: postgres
--


INSERT INTO "site_properties" VALUES (3,'Upload',1,'upload','UPLOAD_MOD',2,0,1,'INSERT_FILES','insert files',0);
INSERT INTO "site_properties" VALUES (2,'Import',1,'import','IMPORT_MOD',3,0,1,'INSERT_FILES','insert files',0);
INSERT INTO "site_properties" VALUES (6,'Admin',1,'admin','ADMIN_MOD',4,0,1,'ACCESS_ADMIN','access the Administration Tools',0);
INSERT INTO "site_properties" VALUES (10,'User Admin',1,'useradmin','USERADMIN_MOD',1,1,1,'MANAGE_USERS','manage other users',0);
INSERT INTO "site_properties" VALUES (13,'Group Admin',1,'groupadmin','GROUPADMIN_MOD',2,0,1,'MANAGE_GROUP','manage groups',6);
INSERT INTO "site_properties" VALUES (12,'Category Admin',1,'catadmin','CATADMIN_MOD',3,0,1,'MANAGE_CAT','manage categories',6);
INSERT INTO "site_properties" VALUES (14,'Database Admin',1,'databaseadmin','DBADMIN_MOD',4,0,1,'ADMIN','manage the database',6);
INSERT INTO "site_properties" VALUES (1,'Find',1,'find','FIND_MOD',1,0,1,'','0',0);
INSERT INTO "site_properties" VALUES (18,'Messages',2,'messages','MESSAGES_MOD',3,0,0,'','0',0);
INSERT INTO "site_properties" VALUES (16,'Search',2,'search','SEARCH_MOD',6,0,0,'','0',0);
INSERT INTO "site_properties" VALUES (15,'Category',2,'category','CAT_MOD',9,0,0,'','0',0);
INSERT INTO "site_properties" VALUES (17,'File Statistics',2,'filestat','FILESTAT_MOD',12,1,0,'','0',0);
INSERT INTO "site_properties" VALUES (27,'QuickView Check',2,'quickcheck','QUICKCHECK_MOD',13,0,0,'','0',0);
INSERT INTO "site_properties" VALUES (28,'File Module',1,'file','FILEORG_MOD',15,1,0,NULL,NULL,0);
INSERT INTO "site_properties" VALUES (26,'Profile',1,'useradmin','PROFILE_MOD',5,1,1,'EDIT_PROFILE','edit your profile',0);
INSERT INTO "site_properties" VALUES (4,'View',1,'view','VIEW_MOD',1,1,1,'','',28);
INSERT INTO "site_properties" VALUES (5,'Show',1,'show','SHOW_MOD',2,1,1,'','0',28);
INSERT INTO "site_properties" VALUES (19,'Properties',1,'property','PROPERTY_MOD',3,1,1,'','0',28);
INSERT INTO "site_properties" VALUES (20,'Update',1,'update','UPDATE_MOD',4,1,1,'','',28);
INSERT INTO "site_properties" VALUES (25,'Discussion',1,'discussion','DISCUSSION_MOD',5,1,1,'','0',28);
INSERT INTO "site_properties" VALUES (24,'Check Out',1,'checkout','CHECKOUT_MOD',6,1,1,'','',28);
INSERT INTO "site_properties" VALUES (23,'Logs',1,'logs','LOGS_MOD',7,1,1,'','0',28);
INSERT INTO "site_properties" VALUES (22,'History',1,'history','HISTORY_MOD',8,1,1,'','0',28);
INSERT INTO "site_properties" VALUES (21,'Delete',1,'delete','DELETE_MOD',9,1,1,'','0',28);
\connect - postgres

--
-- TOC Entry ID 50 (OID 215289)
--
-- Name: "auth_accounts_id_key" Type: INDEX Owner: postgres
--

CREATE INDEX auth_accounts_id_key ON auth_accounts USING btree (id);

--
-- TOC Entry ID 51 (OID 215290)
--
-- Name: "auth_cookies_id_key" Type: INDEX Owner: postgres
--

CREATE INDEX auth_cookies_id_key ON auth_cookies USING btree (id);

--
-- TOC Entry ID 52 (OID 215291)
--
-- Name: "auth_groups_name_key" Type: INDEX Owner: postgres
--

CREATE INDEX auth_groups_name_key ON auth_groups USING btree (name);

--
-- TOC Entry ID 53 (OID 215293)
--
-- Name: "auth_permissions_id_key" Type: INDEX Owner: postgres
--

CREATE INDEX auth_permissions_id_key ON auth_permissions USING btree (id);

--
-- TOC Entry ID 54 (OID 215294)
--
-- Name: "dm_category_id_key" Type: INDEX Owner: postgres
--

CREATE INDEX dm_category_id_key ON dm_category USING btree (id);

--
-- TOC Entry ID 55 (OID 215295)
--
-- Name: "dm_discussion_id_key" Type: INDEX Owner: postgres
--

CREATE INDEX dm_discussion_id_key ON dm_discussion USING btree (id);

--
-- TOC Entry ID 56 (OID 215296)
--
-- Name: "dm_docindex_id_key" Type: INDEX Owner: postgres
--

CREATE INDEX dm_docindex_id_key ON dm_docindex USING btree (id);

--
-- TOC Entry ID 57 (OID 215297)
--
-- Name: "word_dm_docindex_ukey" Type: INDEX Owner: postgres
--

CREATE UNIQUE INDEX word_dm_docindex_ukey ON dm_docindex USING btree (word);

--
-- TOC Entry ID 58 (OID 215298)
--
-- Name: "dm_file_cat_id_key" Type: INDEX Owner: postgres
--

CREATE INDEX dm_file_cat_id_key ON dm_file_cat USING btree (id);

--
-- TOC Entry ID 59 (OID 215299)
--
-- Name: "dm_file_history_id_key" Type: INDEX Owner: postgres
--

CREATE INDEX dm_file_history_id_key ON dm_file_history USING btree (id);

--
-- TOC Entry ID 60 (OID 215300)
--
-- Name: "dm_file_log_id_key" Type: INDEX Owner: postgres
--

CREATE INDEX dm_file_log_id_key ON dm_file_log USING btree (id);

--
-- TOC Entry ID 61 (OID 215301)
--
-- Name: "dm_file_view_id_key" Type: INDEX Owner: postgres
--

CREATE INDEX dm_file_view_id_key ON dm_file_view USING btree (id);

--
-- TOC Entry ID 62 (OID 215302)
--
-- Name: "dm_description_object_key" Type: INDEX Owner: postgres
--

CREATE INDEX dm_description_object_key ON dm_object USING btree (description);

--
-- TOC Entry ID 63 (OID 215303)
--
-- Name: "dm_name_object_key" Type: INDEX Owner: postgres
--

CREATE INDEX dm_name_object_key ON dm_object USING btree (name);

--
-- TOC Entry ID 64 (OID 215304)
--
-- Name: "dm_object_id_key" Type: INDEX Owner: postgres
--

CREATE INDEX dm_object_id_key ON dm_object USING btree (id);

--
-- TOC Entry ID 65 (OID 215305)
--
-- Name: "dm_summary_object_key" Type: INDEX Owner: postgres
--

CREATE INDEX dm_summary_object_key ON dm_object USING btree (summary);

\connect - postgres

--
-- TOC Entry ID 66 (OID 215416)
--
-- Name: "id_site_properties_ukey" Type: INDEX Owner: postgres
--

CREATE UNIQUE INDEX id_site_properties_ukey ON site_properties USING btree (id);

\connect - postgres

--
-- TOC Entry ID 3 (OID 215124)
--
-- Name: auth_accounts_id_seq Type: SEQUENCE SET Owner: postgres
--

SELECT setval ('"auth_accounts_id_seq"', 5, true);

--
-- TOC Entry ID 5 (OID 215126)
--
-- Name: auth_groups_id_seq Type: SEQUENCE SET Owner: postgres
--

SELECT setval ('"auth_groups_id_seq"', 4, true);

--
-- TOC Entry ID 7 (OID 215130)
--
-- Name: auth_permissions_id_seq Type: SEQUENCE SET Owner: postgres
--

SELECT setval ('"auth_permissions_id_seq"', 10, true);

--
-- TOC Entry ID 9 (OID 215132)
--
-- Name: auth_permlink_id_seq Type: SEQUENCE SET Owner: postgres
--

SELECT setval ('"auth_permlink_id_seq"', 5, false);

--
-- TOC Entry ID 11 (OID 215134)
--
-- Name: dm_cat_permissions_id_seq Type: SEQUENCE SET Owner: postgres
--

SELECT setval ('"dm_cat_permissions_id_seq"', 1, false);

--
-- TOC Entry ID 13 (OID 215136)
--
-- Name: dm_category_id_seq Type: SEQUENCE SET Owner: postgres
--

SELECT setval ('"dm_category_id_seq"', 4, true);

--
-- TOC Entry ID 15 (OID 215138)
--
-- Name: dm_discussion_id_seq Type: SEQUENCE SET Owner: postgres
--

SELECT setval ('"dm_discussion_id_seq"', 1, true);

--
-- TOC Entry ID 17 (OID 215140)
--
-- Name: dm_docindex_id_seq Type: SEQUENCE SET Owner: postgres
--

SELECT setval ('"dm_docindex_id_seq"', 1, true);

--
-- TOC Entry ID 19 (OID 215142)
--
-- Name: dm_file_cat_id_seq Type: SEQUENCE SET Owner: postgres
--

SELECT setval ('"dm_file_cat_id_seq"', 1, true);

--
-- TOC Entry ID 21 (OID 215144)
--
-- Name: dm_file_history_id_seq Type: SEQUENCE SET Owner: postgres
--

SELECT setval ('"dm_file_history_id_seq"', 1, true);

--
-- TOC Entry ID 23 (OID 215146)
--
-- Name: dm_file_log_id_seq Type: SEQUENCE SET Owner: postgres
--

SELECT setval ('"dm_file_log_id_seq"', 1, true);

--
-- TOC Entry ID 25 (OID 215148)
--
-- Name: dm_file_view_id_seq Type: SEQUENCE SET Owner: postgres
--

SELECT setval ('"dm_file_view_id_seq"', 1, true);

--
-- TOC Entry ID 27 (OID 215150)
--
-- Name: dm_object_id_seq Type: SEQUENCE SET Owner: postgres
--

SELECT setval ('"dm_object_id_seq"', 1, true);

--
-- TOC Entry ID 29 (OID 215152)
--
-- Name: site_properties_id_seq Type: SEQUENCE SET Owner: postgres
--

SELECT setval ('"site_properties_id_seq"', 28, true);

--
-- TOC Entry ID 31 (OID 215409)
--
-- Name: auth_object_seq Type: SEQUENCE SET Owner: postgres
--

SELECT setval ('"auth_object_seq"', 4, true);

