use Cwd;
my ($data, $drop, $str, %repObjects, %queueObjects);
sub ProcessFiles {
	my $i = 0;
	my $wd = Cwd->getcwd();
	opendir (D, $wd); # "/home/app/cafeterra/install/Pg");
	my @files = readdir(D);
	close D;
	foreach my $file (@files) {
		next unless (($file =~ /\.sql$/) || ($file =~ /\.txt$/));
		open (I, $file);
		my $name;
		if ($file =~ /^d_(.*).sql$/) {
			$name = $1;
			$data->{$name} = [] unless ($data->{$name});
			while (my $l = <I>) {
				next if ($l =~ /^--/);
				next if ($l =~ /^\s*$/);
				chomp($l);
				$l =~ s/;\s*$//;
				push @{$data->{$name}}, $l; 
			}
		}
		elsif ($file =~ /^(.*).sql$/) {
			$name = $1;
			$str->{$name} = [] unless ($str->{$name});
			my $sqlstr = "";
			while (my $l = <I>) {
				next if ($l =~ /^--/);
				next if ($l =~ /^\s*$/);
				$i++ if ($l=~/^CREATE /);
				my $semic;
				if ($name =~ /_seq$/) {
					if ($l =~ /(.*[[:digit:]]*)\s*;\s*$/) { $l = $1; $semic = 1; };
				}
				elsif ($l =~ /(.*\))\s*;\s*$/) { $l = $1; $semic = 1; }
				if ($semic) {
					$sqlstr .= $l;
					chomp($sqlstr);
					$sqlstr =~ s/;\s*$//;
					push @{$str->{$name}}, $sqlstr;
					if ($l !~ /INDEX/) {
						$sqlstr =~ s/^\s*CREATE(\s*[^\s]+\s*[^\s]+).*/DROP$1/s;
						$drop->{$name} = $sqlstr;
#						push @{$drop->{$name}}, $sqlstr;
					}
					$sqlstr = "";
				}
				else { $sqlstr .= $l; }
			}
		}
		elsif ($file =~ /listtables.txt/) {
			while (my $l = <I>) {
				my @L = split (/\s+/, $l);
				if (($L[0] eq "REF") or ($L[0] eq "RQ")) { $repObjects{$L[2]} = 1; }
				if (($L[0] eq "QUEUE") or ($L[0] eq "RQ")) { $queueObjects{$L[2]} = 1; }
			}
		}
		close I;
	}
}

sub DumpAndPrint {
	local *O = shift;
	my $object = shift;
	my $varname = shift;

	use Data::Dumper;

	my $dump = Data::Dumper->new([$object], [$varname]);
	$dump->Indent(1);
	my $ptext = $dump->Dump;

	print O "my ", $ptext;
}


sub PrintHeader {
	local *O = shift;
	print O "#!/usr/local/bin/perl
#
# sqlscripts.pm 25/08/2002
#
# cafeterra : data flow and data replication management
# Copyright (C) 2001  Abdellaziz TALEB
#
#This program is free software; you can redistribute it and/or
#modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation; either version 2
#of the License, or (at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#
use 5.005;
use strict;
package InitObjAndData;
";
}

ProcessFiles();
open (O, ">", "InitSqlScript.pm");
PrintHeader(*O);
DumpAndPrint(*O, $str, "sqlObjects");
DumpAndPrint(*O, $drop, "sqlDropObjects");
DumpAndPrint(*O, $data, "sqlData");
DumpAndPrint(*O, \%repObjects, "repObjects");
DumpAndPrint(*O, \%queueObjects, "queueObjects");

print O 'sub new { bless {}, "sqlscript"; }', "\n\n";
print O 'sub SqlData { return $sqlData }', "\n\n";
print O 'sub SqlObjects { return $sqlObjects }', "\n\n";
print O 'sub SqlDropObjects { return $sqlDropObjects }', "\n\n";
print O 'sub RepObjects { return $repObjects }', "\n\n";
print O 'sub QueueObjects { return $queueObjects }', "\n\n1;\n";
close O;
