#!/usr/local/bin/perl
#
# cafPg 27/07/2002
#
# cafeterra : data flow and data replication management
# Copyright (C) 2001  Abdellaziz TALEB
#
#This program is free software; you can redistribute it and/or
#modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation; either version 2
#of the License, or (at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#
use 5.005;

package cafdPg;
 
@ISA = ("refDBI");
use strict;

use DBI;

sub NewConnection {
	my $class = shift;
	$class = ref($class) || $class;
	my $db = shift;

	my $dbh;

	my $dbdsn = $db->{dbidsn} || $db->{connector}{dbidsn};

	unless ($dbdsn) {
		$dbdsn = "dbi:Pg:dbname=" . $db->{connector}{externalname};
		if ($db->{server}) {
			$dbdsn .= ";host=" . $db->{server}{host_name} if ($db->{server}{host_name});
			$dbdsn .= ";host=" . $db->{server}{host_address} unless ($db->{server}{host_name});
		}
		$dbdsn .= ";port=" . $db->{connector}{port} if ($db->{connector}{port});
	}

#	print STDERR "connecting to $dbdsn with $db->{user}{username}, $db->{user}{password} AutoCommit => $db->{_ATTRS}{AutoCommit}, RaiseError => $db->{_ATTRS}{RaiseError}, PrintError => $db->{_ATTRS}{PrintError} ";
	my $drvAttrs = { AutoCommit => $db->{_ATTRS}{AutoCommit}, RaiseError => $db->{_ATTRS}{RaiseError}, PrintError => $db->{_ATTRS}{PrintError} };
	eval {
		$dbh = DBI->connect($dbdsn, $db->{user}{username}, $db->{user}{password}, $drvAttrs); #$db->{_ATTRS});
	};

	die "cafPg->connect $dbdsn : $@" . join(" - ", %$db) if ($@ || (! $dbh));

	$db->{dbidsn} = $dbdsn;
	my $self = { dbh => $dbh, db => $db, };

	bless $self, $class;
}

sub describe {
	my $self = shift;
	my $tablename = shift;
	my $owner = shift;
	my $type = shift;

	my $query = cafQry->new();
	$query->query("SELECT a.attname AS COLUMN_NAME, upper(t.typname) AS DATA_TYPE, a.attlen AS COLUMN_SIZE,
							0 AS DECIMAL_DIGITS, a.attnum AS ORDINAL_POSITION, a.atttypmod AS LENGTH_VARCHAR,
							a.attnotnull AS IS_NULLABLE
						FROM pg_class c, pg_attribute a, pg_type t, pg_user u
						WHERE c.relname = lower(?) and a.attnum > 0 and a.attrelid = c.oid
							and c.relowner = u.usesysid and u.usename = (?)
							and a.atttypid = t.oid ORDER BY a.attnum");

	$query->bindvars([$tablename, $owner]);

	my $rows = $self->hexecfetchall($query);

	$query = cafQry->new();
   $query->query("SELECT
        ic.relname AS INDEX_NAME,
        a.attname  AS COLUMN_NAME,
        a.attnum   AS COLUMN_POSITION,
        i.indisunique AS UNIQUE_KEY,
        i.indisprimary AS PRIMARY_KEY
         FROM
        pg_class bc,
        pg_class ic,
        pg_index i,
        pg_attribute a,
        pg_user u
      WHERE
        i.indrelid = bc.oid
        and i.indexrelid = ic.oid
        and
        (
        i.indkey[0] = a.attnum
        or
        i.indkey[1] = a.attnum
        or
        i.indkey[2] = a.attnum
        or
        i.indkey[3] = a.attnum
        or
        i.indkey[4] = a.attnum
        or
        i.indkey[5] = a.attnum
        or
        i.indkey[6] = a.attnum
        or
        i.indkey[7] = a.attnum
        )
        and a.attrelid = bc.oid
        and i.indproc = '0'::oid
        and bc.relname = lower(?)
        and (i.indisunique = 1::bool or i.indisprimary = 1::bool)
        and ic.relowner = u.usesysid and u.usename = (?)
        ORDER BY primary_key desc, index_name, column_name, column_position");

	$query->bindvars([$tablename, $owner]);
	my $pkrows = $self->hexecfetchall($query);

	my $pkname = "";

	my $i = -1;
	my @ret;
	my $index = "";
	foreach my $row (@$rows) {
		my $len = $row->{column_size} || -1;
		my $scale; # = $row->{column_size};
		if ($row->{data_type} eq 'NUMERIC') {
			$len = ($row->{length_varchar} >> 16) & 0xffff;
			$scale = ($row->{length_varchar} - 4) & 0xffff;
		}
		elsif ($len > 0) { }
		elsif ($row->{length_varchar} > 12) { $len = $row->{length_varchar} - 4; }
		else { $len = -1; }
		
		$ret[++$i] = {
			externalname => $row->{column_name},
			name         => $row->{column_name},
			objectlabel  => $row->{column_name},
			dataformat   => undef,
			status       => 'online',
			datatypeid   => $row->{data_type},
			datalength   => $len, #$row->{column_size},
			datascale    => $scale, #$row->{decimal_digits},
			fieldorder   => $row->{ordinal_position} * 10,
			fieldpos     => $row->{ordinal_position},
			nullable     => $row->{is_nullable},
			defaultvalue => $row->{column_def},
			Remarks      => $row->{remarks},
		};

		foreach my $pk (@$pkrows) {
			$index = $pk->{index_name} if (! $index);
			last if ($pk->{index_name} ne $index);
			if ($pk->{column_name} eq $ret[$i]->{externalname}) {
				$ret[$i]->{keyposition} = $pk->{column_position}; last;
			}
		}
	}
	return \@ret;
}

sub sysdatefunc {
	return ("now()");
}

sub todatefunc {
	return ("to_timestamp");
}

sub generatechartodate {
	my $self = shift;
	my $col = shift;

	return ":c_$col->{name}" unless ($col->{datatypeid}  =~ /TIME|DATE/);
	unless ($col->{dataformat}) {
		$col->{dataformat} = "YYYY/MM/DD HH24:MI:SS" if ($col->{datatypeid} =~ /SQL_TIMESTAMP/);
		$col->{dataformat} = "YYYY/MM/DD" if ($col->{datatypeid} =~ /SQL_DATE/);
		$col->{dataformat} = "HH24:MI:SS" if ($col->{datatypeid} =~ "SQL_TIME");
	}

	return ("to_date(:c_$col->{name}, '$col->{dataformat}')");
}
		
sub generatedatetochar {
	my $self = shift;
	my $col = shift;

	return $col->{externalname} unless ($col->{datatypeid}  =~ /TIME|DATE/);
	unless ($col->{dataformat}) {
		$col->{dataformat} = "YYYY/MM/DD HH24:MI:SS" if ($col->{datatypeid} =~ /SQL_TIMESTAMP/);
		$col->{dataformat} = "YYYY/MM/DD" if ($col->{datatypeid} =~ /SQL_DATE/);
		$col->{dataformat} = "HH24:MI:SS" if ($col->{datatypeid} =~ "SQL_TIME");
	}

	return ("to_char($col->{externalname}, '$col->{dataformat}')");
}

sub gencolalis {
	my $self = shift;
	my $alias = shift;
	return "AS $alias";
}

sub __generateselect {
	my $self = shift;
	my $command = shift;
	my $connector = shift;
	my $container = shift;
	my $fields = shift;
	my $class = ref($self) || $self;

	my $query = "#select statement generated by $class\n\nSELECT ";
	my $sep = "";
	my $where = "";
	my $chunk;
	my $wsep = "WHERE ";
	my $qlen = 0;
	my $wlen = 0;

	foreach my $col (@$fields) {
		next if ($col->{localfield} eq "yes");
		$chunk = "$sep" . $self->generatedatetochar($col) . " AS \@$col->{name}";
		$query .= $chunk;
		$sep = ", ";

		$qlen += length($chunk);
		if ($qlen > 50) { $query .= "\n\t\t"; $qlen = 10; }

		if ($col->{keyposition}) {
			$chunk = "$wsep$col->{externalname} = " . $self->generatechartodate($col);
			$where .= $chunk;
			$wlen += length($chunk);
			if ($wlen > 50) { $where .= "\n\t\t"; $wlen = 10; }
			$wsep = " and ";
		}
	}

	return "$query\n\tfrom $container->{externalname}\n\t$where";
}

sub DescribeInternal {
	my $self = shift;
	my $tablename = shift;
	my $owner = shift;
	my $type = shift;

	my $query = cafQry->new();
	$query->query("SELECT a.attname AS COLUMN_NAME, upper(t.typname) AS DATA_TYPE, a.attlen AS COLUMN_SIZE,
							0 AS DECIMAL_DIGITS, a.attnum AS ORDINAL_POSITION, a.atttypmod AS LENGTH_VARCHAR,
							a.attnotnull AS IS_NULLABLE
						FROM pg_class c, pg_attribute a, pg_type t, pg_user u
						WHERE c.relname = lower(?) and a.attnum > 0 and a.attrelid = c.oid
							and c.relowner = u.usesysid and u.usename = (?)
							and a.atttypid = t.oid ORDER BY a.attnum");

	$query->bindvars([$tablename, $owner]);

	my $rows = $self->hexecfetchall($query);

	$query = cafQry->new();
	$query->query("SELECT
		ic.relname AS INDEX_NAME,
		a.attname  AS COLUMN_NAME,
		a.attnum   AS COLUMN_POSITION,
		i.indisunique AS UNIQUE_KEY,
		i.indisprimary AS PRIMARY_KEY
		FROM
		pg_class bc,
		pg_class ic,
		pg_index i,
		pg_attribute a,
		pg_user u
		WHERE
		i.indrelid = bc.oid
		and i.indexrelid = ic.oid
		and
		(
		i.indkey[0] = a.attnum
		or
		i.indkey[1] = a.attnum
		or
		i.indkey[2] = a.attnum
		or
		i.indkey[3] = a.attnum
		or
		i.indkey[4] = a.attnum
		or
		i.indkey[5] = a.attnum
		or
		i.indkey[6] = a.attnum
		or
		i.indkey[7] = a.attnum
		)
		and a.attrelid = bc.oid
		and i.indproc = '0'::oid
		and bc.relname = lower(?)
		and ic.relowner = u.usesysid and u.usename = (?)
		ORDER BY index_name, column_position, column_name");
#/*		and (i.indisunique = 1::bool or i.indisprimary = 1::bool)*/

	$query->bindvars([$tablename, $owner]);
	my $pkrows = $self->hexecfetchall($query);

	my $pkname = "";

	my $i = -1;
	my @ret;
	my $index = "";
	foreach my $row (@$rows) {
		my $len = $row->{column_size} || -1;
		my $scale; # = $row->{column_size};
		if ($row->{data_type} eq 'NUMERIC') {
			$len = ($row->{length_varchar} >> 16) & 0xffff;
			$scale = ($row->{length_varchar} - 4) & 0xffff;
		}
		elsif ($len > 0) { }
		elsif ($row->{length_varchar} > 12) { $len = $row->{length_varchar} - 4; }
		else { $len = -1; }
		
		$ret[++$i] = {
			colname      => $row->{column_name},
			datatype     => $row->{data_type},
			datalength   => $len, #$row->{column_size},
			datascale    => $scale, #$row->{decimal_digits},
			fieldpos     => $row->{ordinal_position},
			nullable     => $row->{is_nullable},
			defaultvalue => $row->{column_def},
		};

	}

	my ($iret, $pkret, $tmpret) = ({}, {}, []);
	foreach my $pk (@$pkrows) {
		if ($pk->{index_name} ne $index) {

			if ($pk->{primary_key}) {
				$pkret->{name} = $pk->{index_name};
				$pkret->{cols} = [];
				$tmpret = $pkret->{cols};
			}
			else {
				$iret->{$pk->{index_name}} = { name => $pk->{index_name}, unique => $pk->{unique_key}, cols => [] };
				$tmpret = $iret->{$pk->{index_name}}{cols};
			}
			$index = $pk->{index_name};
		}
		push @$tmpret, $pk->{ column_name };
	}
	return { columns => \@ret, pk => $pkret, indexes => $iret };
}

1;
