#!/usr/local/bin/perl
#
# cafCGI.pm 25/08/2002
#
# cafeterra : data flow and data replication management
# Copyright (C) 2001  Abdellaziz TALEB
#
#This program is free software; you can redistribute it and/or
#modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation; either version 2
#of the License, or (at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#
use 5.005;
use strict;
package cafCGI;

use CGI;

# @CGI = ('CGI');

my $cgi = new CGI;

sub new {
	my $class = shift;
	$class = ref($class) || $class;
	bless {}, $class;
}

sub param {
	my $self = shift;
	my $par  = shift;
	my $format = shift || 's';
 
	my $val = $cgi->param($par);
	if ($format eq "s") { return $val; }
	else {
		my @ar = split("\0", $val);
		if ($format eq "a") { return @ar; }
		elsif ($format eq "r") { return \@ar; }
		else { return $ar[$format]; }
	}
}

sub hashparam {
	my $self = shift;
	my $ret = {};
	while (@_) {
		my $key = shift;
		$ret->{$key} = $self->param($key);
	}
	$ret;
}

sub httpparam {
	my $self = shift;
	my $par  = shift;
	my $format = shift || 's';
 
	my $val = $cgi->http($par);
	if ($format eq "s") { return $val; }
	else {
		my @ar = split("\0", $val);
		if ($format eq "a") { return @ar; }
		elsif ($format eq "r") { return \@ar; }
		else { return $ar[$format]; }
	}
}
 
sub language {
	my $self = shift;
 
	my $default = 'EN';
	if (@_) { $default = shift; }
	my $lang = $self->httpparam('HTTP_ACCEPT_LANGUAGE', 0);
 
	$lang = $default unless ($lang);
	$lang =~ s/^(..).*/$1/g;
	return uc($lang);
 
}
 
sub ipaddress {
	$cgi->remote_host();
}

sub cgisub {
	my $self = shift;
	my $sub = shift;
	$cgi->$sub (@_);
}

sub printheader {
	my $self = shift;
 
	$cgi->header(@_);
}


1;
