#!/usr/local/bin/perl
#
# Users.pm 25/08/2002
#
# cafeterra : data flow and data replication management
# Copyright (C) 2001  Abdellaziz TALEB
#
#This program is free software; you can redistribute it and/or
#modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation; either version 2
#of the License, or (at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#
use 5.005;
use strict;
use  File::stat;
use  Fcntl ':mode';
use Cwd;
package cafInstall;

@cafInstall::ISA = ('cafPage');

# fName => "userid", fType => "atom", fMand => 1, fMin =>, fMax =>, fisList =>,
my $editfields = [
	{fName => "_contextid", fType => "string", fMand => 1, fMin => 3, dMax => 30 },
	{fName => "_contextlabel", fType => "string", fMand => 1, fMin => 3, dMax => 30 },
	{fName => "_ctxttype", fType => "string", fMand => 1, fMin => 3, dMax => 30 },
	{fName => "_masterdsn", fType => "string", fMand => 1, fMin => 3, dMax => 30 },
	{fName => "_masteruser", fType => "string", fMand => 1, fMin => 3, dMax => 30 },
	{fName => "_masterpwd", fType => "password", fMand => 1, fMin => 3, dMax => 30 },
	{fName => "_contextdbname", fType => "string", fMand => 1, fMin => 3, dMax => 30 },
	{fName => "_createdb", fType => "string", fMand => 1, fMin => 3, dMax => 30 },
	{fName => "_contextdsn", fType => "string", fMand => 1, fMin => 3, dMax => 30 },
	{fName => "_contextuser", fType => "string", fMand => 1, fMin => 3, dMax => 30 },
	{fName => "_contextpwd", fType => "password", fMand => 1, fMin => 3, dMax => 30 },
	{fName => "_createdbuser", fType => "string", fMand => 1, fMin => 3, dMax => 30 },
	{fName => "_basedir", fType => "string", fMand => 1, fMin => 3, dMax => 30 },
	{fName => "_httpdpath", fType => "string", fMand => 1, fMin => 3, dMax => 30 },
	{fName => "_cgialias", fType => "string", fMand => 1, fMin => 3, dMax => 30 },
	{fName => "_docalias", fType => "string", fMand => 1, fMin => 3, dMax => 30 },
	{fName => "_dropobjects", fType => "string", fMand => 1, fMin => 3, dMax => 30 },
	{fName => "_ignoreobjerr", fType => "string", fMand => 1, fMin => 3, dMax => 30 },
	{fName => "_ignoredataerr", fType => "string", fMand => 1, fMin => 3, dMax => 30 },
	{fName => "_printerrors", fType => "string", fMand => 1, fMin => 3, dMax => 30 },
	];
 
my $perlModules = {
Mandatory => [
		[ "Time::ParseDate", "Mandatory module" ],
		[ "CGI", "Mandatory module" ],
		[ "Cwd", "Mandatory module" ],
		[ "Data::Dumper", "Mandatory module" ],
		[ "DBD::Pg", "Mandatory module" ],
		[ "DBI", "Mandatory module" ],
		[ "Fcntl", "Mandatory module" ],
		[ "File::Basename", "Mandatory module" ],
		[ "File::Spec", "Mandatory module" ],
		[ "File::stat", "Mandatory module" ],
		[ "File::Temp", "Mandatory module" ],
		[ "Getopt::Long", "Mandatory module" ],
		[ "IO::File", "Mandatory module" ],
		[ "IO::Handle", "Mandatory module" ],
		[ "IO::Scalar", "Mandatory module" ],
		[ "Mail::Sender", "Mandatory module" ],
		[ "Schedule::Cron", "Mandatory module" ],
	],
SoapMand => [
		[ "SOAP::Lite", "If you plan to run Cafeterra SOAP services" ],
		[ "SOAP::Transport::HTTP", "If you plan to run Cafeterra SOAP services" ],
		[ "SOAP::Transport::TCP", "If you plan to run Cafeterra SOAP services" ],
		[ "IO::SessionSet", "If you plan to run Cafeterra SOAP services" ],
	],
ProxyMand => [
		[ "DBD::Proxy", "If you plan to use Proxying functionnality" ],
		[ "DBI::ProxyServer", "If you plan to use Proxying functionnality" ],
		[ "RPC::PlServer::Test", "If you plan to use Proxying functionnality" ],
	],
Others => [
		[ "DBD::mysql", "If you plan to access to MySql databases" ],
		[ "DBD::LDAP", "If you plan to access to LDAP databases" ],
		[ "Net::LDAP", "If you plan to access to LDAP databases" ],
		[ "DBD::Oracle", "If you plan to access to Oracle databases" ],
		[ "SQL::Eval", "Mandatory to process text files including XML, HTML, HPRIM etc ..." ],
		[ "SQL::Statement", "If you plan to process text files including XML, HTML, HPRIM etc ..." ],
		[ "DBD::AnyData", "If you plan to process text files including XML, HTML, HPRIM etc ..." ],
		[ "Spreadsheet::ParseExcel", "If you plan to process Excel Files" ],
		[ "Spreadsheet::ParseExcel::SaveParser", "If you plan to process Excel Files" ],
		[ "DBD::Excel", "If you plan to process Excel Files" ],
		[ "DBD::CSV", "If you plan to process CSV Files" ],
		[ "HTML::Simple", "If you plan to process HTML files" ],
		[ "HTML::TokeParser::Simple", "If you plan to process HTML files" ],
		[ "HTTP::Request", "If you plan to retrieve data using HTTP protocol" ],
		[ "HTTP::Status", "If you plan to retrieve data using HTTP protocol" ],
		[ "LWP::UserAgent", "If you plan to retrieve data using HTTP protocol" ],
		[ "Net::FTP", "If you plan to retrieve data using HTTP protocol" ],
		[ "Net::HTTP", "If you plan to retrieve data using HTTP protocol" ],
		[ "XML::Parser", "If you plan to process XML Files" ],
		[ "XML::Simple", "If you plan to process XML Files" ],
	],
OneNeeded => [
		[ "'sys/ioctl.ph' 'ioctl.ph' POSIX", "One of those is needed to use The Internal Cron system" ],
	],
};

sub GetConfig {
	my $self = shift;
	my $context = shift || "cgi";
	$context = "cgi" if ($context =~ /desing/i);
	my $required = $context . "conf";

	eval "require $required";

	my $cwd = Cwd->getcwd();
	return { basedir => $cwd } if ($@);
	
	my $conf;
	if ($context eq 'cgi') { $conf = conf->new(); }
	else { $conf = CTXTCFG->new(); }

	my $db = $conf->refdb();
	my $dsn = $db->{connector}{dbidsn};
	my $user = $db->{user}{username};
	my $pass = $db->{user}{password};
	my $basedir = $conf->wd();

	return { dsn => $dsn, user => $user, pass => $pass, basedir => $basedir }
}

sub TestPerlModules {
	my $self = shift;
	my @results;
	foreach my $key (keys %$perlModules) {
		my $mods = $perlModules->{$key};
		foreach my $mod (@$mods) {
			my $notfound = 1;
			if ($key eq "OneNeeded") {
				my @mods2 = split (/\s+/, $mod->[0]);
				foreach my $mod2 (@mods2) {
					$notfound = 0;
					my $evalstr = "require $mod2;";
					eval $evalstr;
					last unless ($@);
					$notfound = 1;
				}
			}
			else {
				my $evalstr = "require $mod->[0];";
				eval $evalstr;
				$notfound = 0 unless ($@);
			}
			if ($notfound) { push @results, { _code => $mod->[0], _text => $mod->[1] }; }
		}
	}
	$self->_datavar("_result", \@results);
}

my %fileAccessMasks = (
	'cgi'            => 0755,
	'PM'             => 0755,
	'index.pl'       => 0755,
	'conf.pm'        => 0644,
	'mains'          => 0555,
	'connectors'     => 0555,
	'cgi'            => 0555,
	'EN'             => 0555,
	'FR'             => 0555,
	'PM'             => 0555,
	'connectors'     => 0555,
	'install'        => 0555,
	'Oracle'         => 0555,
	'Pg'             => 0555,
	'mains'          => 0555,
	'migration'      => 0555,
	'site'           => 0555,
	'images'         => 0555,
	'models'         => 0555,
	'control'        => 0555,
	'tools'          => 0555,
	'scripts'        => 0555,
	'sql'            => 0555,
	'tools'          => 0555,
);


sub FileAccessLoop {
	my $self = shift;
	my $uid = shift;
	my $file = shift;
	my $invalid = shift;


	return if ($file eq 'DOCS');
	my $cwd = Cwd->getcwd();
	my $err = "";
	my $sep ="";
	my $sf = File::stat::stat ($file);
	if ($sf->uid() != $uid) { my $rowner = getpwuid($sf->uid()) || $sf->uid(); $err .= $sep . "Inavlid owner $rowner"; $sep = ","; }
	my $mode = $sf->mode & 0777;
	if ( -d $file) { #$isdir) {
		my $mask = $fileAccessMasks{$file};
		$mask ||= 0755;
		unless (($mode & $mask) >= $mask) { $err .= sprintf( "%sInvalid mode %0.4o (instead of %0.4o)", $sep, $mode, $mask); $sep = ","; }
		if ($err) { push @$invalid, { _code => "$cwd", _text => $err . " for directory $file"}; }
#		if ($err) {
#			 push @$invalid, $err . " for directory $file (in $cwd)";
#		}
		if (opendir(D, $file)) {
			my @files = readdir(D);
			close D;
			chdir $file;
			foreach my $f (@files) { next if ($f =~ /^\./); $self->FileAccessLoop($uid, $f, $invalid); }
			chdir("..");
		}
	}
	else {
		my $mask = $fileAccessMasks{$file};
		$mask ||= 0444;
		unless (($mode & $mask) >= $mask) { $err .= sprintf( "%sInvalid mode %0.4o (instead of %0.4o)", $sep, $mode, $mask); $sep = ","; }
		if ($err) { push @$invalid, { _code => "$cwd", _text => $err . " for file $file"}; }
	}
}

sub FileAccess {
	my $self = shift;
	my $owner = shift;
	my $homeDir = shift;

	my $invalid = [];
	my $uid = getpwnam($owner) || $owner;
	$self->FileAccessLoop($uid, $homeDir, $invalid);
	$self->_datavar("_result", $invalid);
	return $invalid;
}

sub ServerOwner {
	my $self = shift;
	my $owner = getpwuid($<);
}

sub IsUserExists {
	my $self = shift;
	my $user = shift;
	my $dbh = shift;

	my $queryText = "select username, usecreatedb, usesuper, usecatupd from pg_user where username = '$user'";
	my $query = $dbh->newquery();
	my $query->query($queryText);
	my $rows = $dbh->hexecfetchall($query);
	my $err;
	
	if ($rows->[0]{username} eq $user) {
		my $isaDba = ($rows->[0]{usecreatedb}) and ($rows->[0]{usesuper}) and ($rows->[0]{usesuper});
		if (not $isaDba) { $err = "User $user is not a Dba"; }
	}
	else {$err = "User $user doe's not exists"; }
	
	return $err;
}

sub IsDbExists {
	my $self = shift;
	my $dsn = shift;
	my $user = shift;
	my $pass = shift;

	my $db = {
		connector => { driverid   => "Pg",  protocolid => "DBI", dbidsn => $dsn, },
		user      => { username   => $user, password   => $pass, },
		_ATTRS    => { PrintError => 0,     RaiseError => 1,     AutoCommit => 1, _FLOWDIR => "/tmp",
		},
	};
	return refDBI->Connect($db);
}

sub CreateDbUser {
	my $self = shift;
	my $dbh = shift;
	my $user = shift;
	my $pass = shift;

	my $queryText = "create user $user with password '$pass' createdb, createuser";

	my $query = $dbh->newquery();
	$query->query($queryText);
	$dbh->executefinish($query);
}

sub CreateDb {
	my $self = shift;
	my $cdbname = $self->_datavar("_contextdbname");;

	my $queryText = "create database $cdbname";

	my ($cdsn, $cuser, $cpwd) = ($self->_datavar("_contextdsn"), $self->_datavar("_contextuser"), $self->_datavar("_contextpwd"));
	my ($mdsn, $muser, $mpwd) = ($self->_datavar("_masterdsn"), $self->_datavar("_masteruser"), $self->_datavar("_masterpwd"));
	my ($createdb, $createdbuser) = ($self->_datavar("_createdb"), $self->_datavar("_createdbuser"));
	if ($createdb) {
		my $dbh = $self->_systemvar("_MASTERDBH_");
		my $query = $dbh->newquery();
		$query->query($queryText);
		eval { $dbh->executefinish($query); };
		if ($@) { cafDbg->pusherror("CREATE DB $cdbname; $@<BR><I>$queryText</I>"); return 1; }
	}
	if ($createdbuser) {
		my $dbh = $self->IsDbExists($cdsn, $muser, $mpwd);

		eval { $self->CreateDbUser($dbh, $cuser, $cpwd); };
		if ($@) { cafDbg->pusherror("CREATE USER DB $cuser\@$cdbname; $@"); return 1; }
		$dbh->disconnect();

#		$self->_systemvar("_CONTEXTDBH_", $self->IsDbExists($cdsn, $cuser, $cpwd));
	}
	if (! $self->_systemvar("_CONTEXTDBH_")) {
		eval { $self->_systemvar("_CONTEXTDBH_", $self->IsDbExists($cdsn, $cuser, $cpwd)); };
		if ($@) { cafDbg->pusherror("CONNECT TO DB $cdbname using $cuser; $@"); return 1; }
	}
	
}

sub InitialObjects {
	my $self = shift;
	my $dbh = $self->_systemvar("_CONTEXTDBH_");
	my $ignoreObjErr = $self->_datavar("_ignoreobjerr");
	my $ignoreDataErr = $self->_datavar("_ignoredataerr");
	my $dropObjects = $self->_datavar("_dropobjects");
	my $dropObjects = $self->_datavar("_dropobjects");
	my $printErrors = $self->_datavar("_printerrors");

	my $installInfo = $self->_datavar("_installinfo");
	my $results = $self->_datavar("_result");

	my $errCount = 0;
	my $objCount = 0;
	my $sqlCount = 0;
	my $errText;

	require install::Pg::InitSqlScript;
	my $initObjAndData = InitObjAndData->new();

	my $objects = $self->_datavar("_ctxttype") eq "design" ? InitObjAndData->RepObjects() : InitObjAndData->QueueObjects();
	my $objQueries = InitObjAndData->SqlObjects();
	my $dataQueries = InitObjAndData->SqlData();
	my $dropObjectsQueries = InitObjAndData->SqlDropObjects();

	my $query = $dbh->newquery();
	foreach my $object (keys %$objects) {
		my $queries = $objQueries->{$object} || [];
		$objCount++;
		my $i = 0;
		my $sql = $dropObjectsQueries->{$object};
		if ($dropObjects and $sql) {
			$query->clear();
			$query->query($sql);
			$query->mylabel("drop.$object.$i");
			eval { $dbh->executefinish($query); };
		}
		foreach my $sql (@$queries) {
			$query->clear();
			$query->query($sql);
			$query->mylabel("obj.$object.$i");
			eval { $dbh->executefinish($query); };
			if ($@) {
				$errCount++;
				if ($ignoreObjErr) {
					if ($printErrors) {
						push @$results, { _code => "obj.$object.$i", _text => "$@<BR><I>$sql</I>" };
					}
				}
				else { cafDbg->pusherror("obj.$object.$i; $@<BR><I>$sql</I>"); return 1; }
			}
			$i++;
		}
	}

	if ($errCount) { $errText = "$objCount created with $errCount error(s)"; }
	else { $errText = "$objCount created successfully !"; }
	push @$installInfo, $errText;

	$errCount = 0;
	$objCount = 0;
	$sqlCount = 0;
	foreach my $object (keys %$objects) {
		my $queries = $dataQueries->{$object} || [];
		my $i = 0;
		$sqlCount++;
		foreach my $sql (@$queries) {
			$query->clear();
			$query->query($sql);
			$query->mylabel("data.$object.$i");
			eval { $dbh->executefinish($query); };

			if ($@) {
				$errCount++;
				if ($ignoreObjErr) {
					if ($printErrors) {
						push @$results, { _code => "data.$object.$i", _text => "$@<BR><I>$sql</I>" };
					}
				}
				else { cafDbg->pusherror("data.$object.$i; $@<BR><I>$sql</I>"); return 1; }
			}
			$i++;
		}
	}

	if ($errCount) { $errText = "$sqlCount initialisation queries executed with $errCount error(s)" }
	else { $errText = "$sqlCount initialisation queries executed successfully !"; }
	push @$installInfo, $errText;
}

sub CreateDirAndConfig {
	my $self = shift;

	my $design = $self->_datavar("_ctxttype") eq "design" ? 1 : 0;
	my $basedir = $self->_datavar("_basedir");
	my $cgialias = $self->_datavar("_cgialias");
	my $docalias = $self->_datavar("_docalias");
	my $httpdpath = $self->_datavar("_httpdpath");
	my $contextLabel = $self->_datavar("_contextlabel");
	my $installInfo = $self->_datavar("_installinfo");

	my ($cdsn, $cuser, $cpwd) = ($self->_datavar("_contextdsn"), $self->_datavar("_contextuser"), $self->_datavar("_contextpwd"));
	my ($mdsn, $muser, $mpwd) = ($self->_datavar("_masterdsn"), $self->_datavar("_masteruser"), $self->_datavar("_masterpwd"));

	$cuser = $muser unless ($cuser);
	$cpwd = $mpwd unless($cpwd);

	my $dir = $design ? "" : $self->_datavar("_contextid");
	$dir =~ s/[^[:alnum:]_]//g;
	if ($dir and ($dir !~ /^[[:alpha:]]/)) { $dir = "_$dir"; }
	my $contextid = $dir;

	if ($dir) { mkdir $dir; }

	local $/;
	$/ = undef;
	$dir = "cgi" unless ($dir);
	if (! open (I, "<install/Pg/httpdconf.tpl")) {
		cafDbg->pusherror("httpdconf; Unable to open file install/Pg/httpdconf.tpl");
		return 1;
	}
	my $httpddirective =<I>;
	close(I);

	$httpddirective =~ s/CGIALIAS/$cgialias/g;
	$httpddirective =~ s/DOCALIAS/$docalias/g;
	$httpddirective =~ s!CAFDIR/cgi!$basedir/$dir!g;
	$httpddirective =~ s/CAFDIR/$basedir/g;
 
	if ( ! open (O, ">$dir/httpdconf.inc")) {
		cafDbg->pusherror("httpdconf; Unable to open file $dir/httpdconf.inc for write");
		return 1;
	}
	print O $httpddirective;
	close (O);

	chmod 0666, "$dir/httpdconf.inc";

	if (! open (I, "<install/Pg/conf.pm.tpl")) {
		cafDbg->pusherror("httpdconf; Unable to open file install/Pg/conf.pm.tpl");
		return 1;
	}
	undef $/;
	my $content = <I>;
	close (I);
	$content =~ s/CTXTCFG/conf/g if ($design);
	$content =~ s/my \$version *= *"[^"]*";/my \$version = "020004";/g;
	$content =~ s/my \$refdsn *= *"dbi:Pg:dbname=cafeterraq;host=localhost;port=5432";/my \$refdsn = "$cdsn";/;
	$content =~ s/my \$refuser *= *"aliphe";/my \$refuser = "$cuser";/;
	$content =~ s/my \$refpass *= *"aliphe";/my \$refpass = "$cpwd";/;
	$content =~ s/my \$cafsite *= *"cafsite";/my \$cafsite = "$docalias";/;
	$content =~ s/my \$basedir *= *"\/home\/app\/cafeterra";/my \$basedir = "$basedir";/;
	$content =~ s/my \$contextid *= *"default";/my \$contextid = "$contextid";/;
	$content =~ s/my \$contextlabel *= *"Default context";/my \$contextlabel = "$contextLabel";/;
	if (! open (O, ">$dir/conf.pm")) {
		cafDbg->pusherror("httpdconf; Unable to open file $dir/conf.pm for write");
		return 1;
	}
	print O $content;
	close O;
	chmod 0644, "$dir/conf.pm";

	if (! open (I, "<install/Pg/index.pl.tpl")) {
		cafDbg->pusherror("httpdconf; Unable to open file install/Pg/index.pl.tpl");
		return 1;
	}
	$content = <I>;
	close (I);
 
	my $use = $dir . "::conf";
	$content =~ s/use default::conf;/use $use;/;
	$content =~ s/CTXTCFG/conf/g if ($design);
 
	if (! open (O, ">$dir/index.pl")) {
		cafDbg->pusherror("httpdconf; Unable to open file $dir/index.pl for write");
		return 1;
	}
	print O $content;
	close (O);
	chmod 0755, "$dir/index.pl";
 
   	my $inchttpd = "$basedir/$dir/httpdconf.inc";
 
	open IN, "<$httpdpath";
	$content = <IN>;
	close IN;
 
	if ($content =~ /$inchttpd/) {
		push @$installInfo, "<P><FONT COLOR=\"red\" SIZE=+1><B>\n DO NOT FORGET TO RESTART APACHE\n</B></FONT>\n";
	}
	else {
		my $errText;
		if (open OUT, ">>$httpdpath") {
			print OUT "#Aliases for Cafeterra web interface\nInclude $inchttpd\n";
			close OUT;
			$errText = "$httpdpath was modified<P><FONT COLOR=\"red\" SIZE=+1><B>\n DO NOT FORGET TO RESTART APACHE\n</B></FONT>\n";
		}
		else {
			$errText = "<FONT COLOR=\"red\">Unable to modify $httpdpath</FONT>;<BR>";
			$errText .= "please add manually the fellowing 2 lines to your $httpdpath\n";
			$errText .= "<P><B><I>#Aliases for Cafeterra web interface<BR>\nInclude $inchttpd<B><I>\n";
			$errText .= "<P><FONT COLOR=\"red\" SIZE=+1><B>\n DO NOT FORGET TO RESTART APACHE\n</B></FONT>\n";
		}

		push @$installInfo, $errText;
	}



}

sub TestDba {
	my $self = shift;
	my $user = shift;
	my $pass = shift;
	my $dsn   = shift;


	createUser();
	connectNewUser();
	createDb();
	createObjects();
	insertData();
	
}

sub TestHttpdConf {
	my $self = shift;
	my $httpdconf = shift;

	return if ($httpdconf and (-f $httpdconf));
	$httpdconf = "";
	my $defaulthttpdconf = "/etc/httpd/conf/commonhttpd.conf";
	unless (-f $defaulthttpdconf) { $defaulthttpdconf = "/usr/local/apache/conf/commonhttpd.conf"; }
	unless (-f $defaulthttpdconf) { $defaulthttpdconf = "/usr/local/apache/conf/httpd.conf"; }
	unless (-f $defaulthttpdconf) { $defaulthttpdconf = "/etc/httpd/conf/httpd.conf"; }
	$httpdconf ||= $defaulthttpdconf; #"/etc/httpd/conf/commonhttpd.conf";
}

sub startpage {
	my $self = shift;

	$self->_hiddenvar ("_pagetype", "INSTALL");
	my $cgi =  $self->{_system}{_cgi};
	my $dbh =  $self->{_system}{_dbh};
	my $conf =  $self->{_system}{_conf};
	my $curraction = $self->_hiddenvar ("_curraction");
#	if (($curraction ne "create") and ($curraction ne "search") and ($curraction ne "checkpm")) {$curraction = 'search' }
	if ('search;checkpm;create;checkfp' !~ $curraction) {$curraction = 'search'; }
	unless($curraction) { $curraction = 'search'; }
	$self->_hiddenvar ("_curraction", $curraction);
	my $meth_name = "meth_$curraction";

	my $actiondetail = $self->_hiddenvar ("_actiondetail");
	unless ($actiondetail) { $actiondetail = 'search', $self->_hiddenvar ("_actiondetail", $actiondetail); }

	$self->_datavar("_installinfo", []);
	$self->_datavar("_result", []);
	$self->$meth_name($cgi, $dbh, $conf);
}

sub meth_search {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;

	my $pwd = Cwd->getcwd();
	$self->_getcheckfields ($cgi, $editfields);
	$self->_datavar("_basedir", $pwd) unless ($self->_datavar("_basedir"));
	$self->_datavar("_httpdpath", $self->TestHttpdConf($self->_datavar("_httpdpath")));
}

sub PrimaryChecks {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;

	my $err = 0;

	my $ctxttype = $self->_datavar("_ctxttype");
	my $contextid = $self->_datavar("_contextid");
	$contextid =~ s/[^[:alnum:]_]//;
	if ($contextid and ($contextid !~ /^[[:alpha:]]/)) { $contextid = "_$contextid"; }
	$self->_datavar("_contextid", $contextid);
	my $c = $contextid || "No Name Given";

	if (($contextid eq "cgi") or ($contextid eq "design")) { $contextid = ""; }
	if (! $contextid and ($ctxttype eq "prod")) {
		cafDbg->pusherror("Context Id; Invalid context id ($c) for production environnement");
		$err++;
	}
	if (($contextid) and ($ctxttype eq "design")) {
		cafDbg->pusherror("Context Id; Invalid context id ($c) for design environnement");
		$err++;
	}

	if (! ($self->_datavar("_cgialias") and $self->_datavar("_docalias"))) {
		cafDbg->pusherror("HTTP aliases; you must supply cgialias and docalias");
	}
	my $basedir = $self->_datavar("_basedir");
	if (!$basedir) {
		cafDbg->pusherror("Base directory; you must supply base directory for cafeterra installation");
	}
	elsif (! -d $basedir) {
		cafDbg->pusherror("Base directory; $basedir is not a directory");
	}
	elsif (! -w $basedir) {
		cafDbg->pusherror("Base directory; $basedir must be writable for the user " . getpwuid($<));
	}
	elsif (!(-d "$basedir/cgi" and -d "$basedir/connectors" and -d "$basedir/tools" and -d "$basedir/mains")) {
		cafDbg->pusherror("Base directory; cafeterra is not installed on $basedir");
	}
	if ($self->_datavar("_createdb")) {
		my ($dsn, $user, $pwd) = ($self->_datavar("_masterdsn"), $self->_datavar("_masteruser"), $self->_datavar("_masterpwd"));
		if ($dsn) {
			my $dbh;
			eval { $dbh = $self->IsDbExists($dsn, $user, $pwd); };
			if (!$dbh or $@) {
				my $e = "Master database; Enable to connect to the master database";
				$e .= "<BR> ==> DRIVER ERROR : $@";
				$e =~ s/ at connectors.cafd.*//;
				cafDbg->pusherror($e);
				$err++;
			}
			else {
				$self->_systemvar("_MASTERDBH_", $dbh); $self->_datavar("_createdb", "yes");

				my $createdbuser = $self->_datavar("_createdbuser");
				my ($cdsn, $cuser, $cpwd) = ($self->_datavar("_contextdsn"), $self->_datavar("_contextuser"), $self->_datavar("_contextpwd"));
				my $cdbname = $self->_datavar("_contextdbname");
				if (not ($cdbname and $cdsn)) {
					cafDbg->pusherror("Context database; you must supply a context database name and dsn for the new database");
				}
				if ($createdbuser) {
					if (not ($cuser and $cpwd)) {
						cafDbg->pusherror("Context database; you must supply user and password for the new database user");
					}
				}
				else {
					$cuser = $user unless ($cuser);
					$cpwd = $pwd unless ($cpwd);
					if (not ($cuser and $cpwd)) {
						cafDbg->pusherror("Context database; you must supply user and password for the context database");
					}
					else {
						$self->_datavar("_contextuser", $cuser);
						$self->_datavar("_contextpwd", $cpwd);
					}
				}
			}
		}
		else {
			cafDbg->pusherror("Master database; you must supply a master database (postgres or template) to create a new database");
		}
	}
	else {
		my ($dsn, $cuser, $cpwd) = ($self->_datavar("_contextdsn"), $self->_datavar("_contextuser"), $self->_datavar("_contextpwd"));
		my ($user, $pwd);
		my $dbh;
		my $createdbuser;
		if ($dsn) {
			if ($createdbuser = $self->_datavar("_createdbuser")) {
				($user, $pwd) = ($self->_datavar("_masteruser"), $self->_datavar("_masterpwd"));
				if (not ($user and $pwd)) {
					cafDbg->pusherror("Context database; you must supply a master user to create a nex user");
					$err++;
				}
				else { ($user, $pwd) = ($cuser, $cpwd); }
			}
			eval { $dbh = $self->IsDbExists($dsn, $user, $pwd); };
			if (!$dbh or $@) {
				my $e = "Context database; Enable to connect to the context database";
				$e .= "<BR> ==> DRIVER ERROR : $@";
				$e =~ s/ at connectors.cafd.*$//s;
				cafDbg->pusherror($e);
				$err++;
			}
			else {
				if ($createdbuser) { $dbh->disconnect(); }
				else { $self->_systemvar("_CONTEXTDBH_", $dbh); }
			}
		}
		else {
			cafDbg->pusherror("Context database; you must supply a context database, or create if it doesn't exist");
		}
	}

	$err;
}

sub meth_checkpm {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;

	my $actiondetail = $self->_hiddenvar ("_actiondetail");
	$self->_getcheckfields ($cgi, $editfields);

	my $ret = $self->PrimaryChecks($cgi, $dbh, $conf);
#	if ($ret) {
		my $dbh;
		if ($dbh = $self->_systemvar("_CONTEXTDBH_")) { $dbh->disconnect(); }
		if ($dbh = $self->_systemvar("_MASTERDBH_")) { $dbh->disconnect(); }
		#return undef;
#	}
	
	$self->TestPerlModules();
}

sub meth_checkfp {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;

	my $actiondetail = $self->_hiddenvar ("_actiondetail");
	$self->_getcheckfields ($cgi, $editfields);

	my $ret = $self->PrimaryChecks($cgi, $dbh, $conf);
#	if ($ret) {
		my $dbh;
		if ($dbh = $self->_systemvar("_CONTEXTDBH_")) { $dbh->disconnect(); }
		if ($dbh = $self->_systemvar("_MASTERDBH_")) { $dbh->disconnect(); }
		#return undef;
#	}
	
	$self->FileAccess($<, $self->_datavar("_basedir"));

}

sub meth_create {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;

	my $actiondetail = $self->_hiddenvar ("_actiondetail");
	$self->_getcheckfields ($cgi, $editfields);

	my $ret = $self->PrimaryChecks($cgi, $dbh, $conf);
	if ($ret) {
		my $dbh;
		if ($dbh = $self->_systemvar("_CONTEXTDBH_")) { $dbh->disconnect(); }
		if ($dbh = $self->_systemvar("_MASTERDBH_")) { $dbh->disconnect(); }
		return undef;
	}

	$self->CreateDb();
	$self->InitialObjects();
	$self->CreateDirAndConfig();
	

}


1;
