#!/usr/local/bin/perl
#
# cafPage.pm 25/08/2002
#
# cafeterra : data flow and data replication management
# Copyright (C) 2001  Abdellaziz TALEB
#
#This program is free software; you can redistribute it and/or
#modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation; either version 2
#of the License, or (at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#
use 5.005;
use strict;
use Data::Dumper;
use connectors::ObjHier;
use Cwd;
use File::Basename;
use File::stat;

package CafImport;

@CafImport::ISA = ('cafPage');

# fName => "contextid", fType => "atom", fMand => 1, fMin =>, fMax =>, fisList =>,
my $editfields = [
	{ fName => "exportid", fType => "atom", fMand => 1, fMin => 3, dMax => 30 },
	{ fName => "patobjectid", fType => "atom", fMand => 1, fMin => 3, dMax => 30 },
	{ fName => "ignoreimported", fType => "atom", fMand => 1, fMin => 3, dMax => 30 },
	{ fName => "uniquenames", fType => "atom", fMand => 1, fMin => 3, dMax => 30 },
	];
 
sub startpage {
	my $self = shift;

	$self->_hiddenvar ("_pagetype", "NORMAL");
	my $cgi =  $self->{_system}{_cgi};
	my $dbh =  $self->{_system}{_dbh};
	my $conf =  $self->{_system}{_conf};
	$self->_hiddenvar ("_pagetype", "SEARCH") if $cgi->param("_searchcall");
	my $curraction = $self->_hiddenvar ("_curraction");
	unless ($curraction) { $curraction = 'search', $self->_hiddenvar ("_curraction", $curraction); }
	my $meth_name = "meth_$curraction";

	my $actiondetail = $self->_hiddenvar ("_actiondetail");
	unless ($actiondetail) { $actiondetail = 'search', $self->_hiddenvar ("_actiondetail", $actiondetail); }

	$self->_datavar("_importinfo", []);
	$self->$meth_name($cgi, $dbh, $conf);

}

sub CheckFields {
	my $self = shift;
	my $exportid = $self->_datavar("exportid");
	$exportid =~ s/[^[:alnum:]_]//g;
	if (!$exportid) { cafDbg->pusherror("exportid; You must supply an id to your export site"); }
	elsif ($exportid and ($exportid !~ /^[[:alpha:]]/)) { $exportid = "_$exportid"; }
	$self->_datavar("exportid", $exportid);
}

sub meth_search {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;
	$self->_getcheckfields ($cgi, $editfields);
#	$self->CheckFields();

	my $actiondetail = $self->_hiddenvar ("_actiondetail");
	if ($actiondetail eq "search") {$self->_datavar("ignoreimported", "yes"); }
	
	my $exportid = $self->_datavar("exportid") || "[[:alnum:]_].*";
	my $patobjectid = $self->_datavar("patobjectid") || "[[:digit:]]+";
	my $ignoreimported = $self->_datavar("ignoreimported");


	my $cwd = Cwd->getcwd();
	chdir $conf->wd();
	opendir D, "exports";
	my @files = readdir(D);
	my @filesToImport;
	close (D);

	my $pat = $exportid . "_" . $patobjectid;
	$pat .= "_[[:digit:]_]+.pm";
	mkdir "exports" unless ("exports");
	chdir "exports";
	foreach my $f (@files) {
		chomp $f;
		if ($f =~ /^$pat/) {
			my %fileToImport;
			open I, $f;
			if (-f "$f.done") {
				next if ($ignoreimported);
				my $sf = File::stat::stat("$f.done");
				$fileToImport{lastimportdate} = cafUtils->datetime1($sf->mtime());
			}
			push (@filesToImport, \%fileToImport) if ($fileToImport{object_id});
			while (my $l = <I>) {
				chomp ($l);
				if ($l =~ /#USER COMMENT *= (.*)/) { $fileToImport{usercomment} = $1; }
				elsif ($l =~ /#EXPORT DATE *= (.*)/) { $fileToImport{exportdate} = $1; }
				elsif ($l =~ /#CAFETERRA VERSION *= (.*)/) { $fileToImport{cafversion} = $1; }
				elsif ($l =~ /#OBJECT TYPE *= (.*)/) { $fileToImport{object_type} = $1; }
				elsif ($l =~ /#OBJECT ID *= (.*)/) { $fileToImport{object_id} = $1; }
				elsif ($l =~ /#OBJECT LABEL *= (.*)/) { $fileToImport{objectlabel} = $1; }
				elsif ($l =~ /#PACKAGE NAME *= (.*)/) { $fileToImport{packagename} = $1; }
				elsif ($l =~ /#CONTEXT *= (.*)/) { $fileToImport{context} = $1; }
				elsif ($l =~ /#FILENAME/) { $fileToImport{filename} = $f; last; }
			}
			close I;
			push (@filesToImport, \%fileToImport) if ($fileToImport{object_id});
		}
	}
				
	my $objcounts = $cgi->param("_listexportedobjectscount");
	my @selectedObjects;
	my $exportedobjects = [];
	my %checkedObjects;
	for (my $i = 0; $i <= $objcounts; $i++) {
		my $objectid;
		next unless ($objectid = $cgi->param("filename_$i"));
		$checkedObjects{$objectid} = { import_it => $cgi->param("import_$i"), forceimport => $cgi->param("forceimport_$i") };
		push @selectedObjects, $objectid;
	}

	foreach my $obj (@filesToImport) {
		next unless ($obj);
		$obj->{import_it} = $checkedObjects{$obj->{filename}}{import_it};
		$obj->{forceimport} = $checkedObjects{$obj->{filename}}{forceimport};
	}
	$self->_hiddenvar ("_listexportedobjectscount", $#filesToImport);
	$self->{_filestoimport} = \@filesToImport; 

	$self->{list1count} = -1 unless (defined($self->{list1count}));
	$self->{list1count} += 1;
}


sub updateobject {
	my $dbh = shift;
	my $object_id = shift;
	my $params = shift;
	my $qfunc1 = shift;
	my $qfunc2 = shift;

	my $q = $dbh->newquery($params);
	$q->$qfunc1();
	my $ret = $dbh->executefinish($q);
	if ($ret <= 0) {
		$q->$qfunc2();
		$ret = $dbh->executefinish($q);
		if ($ret <= 0) {
			$dbh->rollback();
			die "Error while importing $object_id " . $q->query();
		}
	}
}

sub updateimports {
	my $dbh = shift;
	my $context = shift;
	my $object_id = shift;
	my $theobject = shift;
	my $objects = shift;

	my $datformat = "YYYY/MM/DD HH24:MI:SS";


	my $q = $dbh->newquery();
	my $lastm = $objects->{$object_id}{last_modified};
	my $ext_id = $object_id;
	my $loc_id = $objects->{$object_id}{local_id};
	$q->query("UPDATE imports set last_modified = to_timestamp('$lastm', '$datformat'), 
		last_imported = now(), local_id = $loc_id
		WHERE contextid = '$context' AND external_id = $ext_id");
	my $ret = $dbh->executefinish($q);
	if ($ret <= 0) {
		$q->query("INSERT INTO imports (contextid, external_id, local_id, last_modified)
			VALUES ('$context', $ext_id, $loc_id, to_timestamp('$lastm', '$datformat'))");
		$ret = $dbh->executefinish($q);
		if ($ret <= 0) {
			$dbh->rollback();
			die "Error while importing $object_id " . $q->query();
		}
	}
}

sub ImportObject {
	my $self = shift;
	my $dbh = shift;
	my $configPar = shift;
	my %config = %$configPar;

	my $datformat = "YYYY/MM/DD HH24:MI:SS";

	my $opackage = $config{opackage};
	my $inc = 'exports::' . $config{ofile};
	$inc =~ s/.pm$//;
	eval "require $inc";
	die $@ if ($@);

	my $migrobjs = $opackage->objectsrefs();


	my $objectCount = 0;
	my $objects = $migrobjs->{objects};
	my $himports = {};
	my $thedump = $migrobjs->{thedump};
	my $attributes = $migrobjs->{attributes};
	my $otherobj = $migrobjs->{otherobj};
	my $objscr = $migrobjs->{objscr};
	my $mapping = $migrobjs->{mapping};
 
	my $objectlist;
	my $sep = "";

	require Data::Dumper;
	require connectors::refDBI;
	require tools::cafDbg;
	foreach my $object_id (keys %$objects) {
		$objects->{$object_id}{last_epochmodified} = cafUtils->parsedatetime3($objects->{$object_id}{last_modified}, UK => 1);
		$objectlist .= "$sep$object_id";
		$sep = ", ";
		$objectCount++;
#		print "$obj, $thedump->{$obj}{type} LAST MODIFIED $objects->{$obj}\n";
	}
	my $q = $dbh->newquery();
	$q->query("SELECT contextid, external_id, local_id, to_char(first_imported, '$datformat') AS first_imported,
		to_char(last_imported, '$datformat') AS last_imported, to_char(last_modified, '$datformat') AS last_modified
		FROM imports
		WHERE contextid = '$config{context}' AND external_id in ($objectlist)");
	my $importedobjs = $dbh->hexecfetchall($q) || [];
	foreach my $obj (@$importedobjs) {
		if ($config{force}) { $obj->{last_epochmodified} = 0; }
		else {
			$obj->{last_epochmodified} = cafUtils->parsedatetime3($obj->{last_modified}, UK => 1);
			$obj->{last_epochmodified} = 1 unless ($obj->{last_epochmodified});
		}
		$himports->{$obj->{external_id}} = $obj;
	}

	foreach my $object_id (keys %$objects) {
		if ($himports->{$object_id}{local_id}) {
			$objects->{$object_id}{local_id} = $himports->{$object_id}{local_id};
		}
		else {
			$objects->{$object_id}{local_id} = $dbh->nextseq("objects");
			$himports->{$object_id}{local_id} = $objects->{$object_id}{local_id};
		}

	}

	foreach my $object_id (keys %$objects) {
		unless ($himports and ($himports->{$object_id}{last_epochmodified} >= $objects->{$object_id}{last_epochmodified})) {
			my $theobject = $thedump->{$object_id};
			my $otype = $theobject->{type};
			$otype = "scripts" if ($otype =~ /^perl|^sql/);
			if ($theobject->{parent_id} and ($theobject->{parent_id} > 0)) {
				$theobject->{parent_id} = $objects->{$theobject->{parent_id}}{local_id};
			}
			if ($otype eq "subflow") {
				$theobject->{flow_id} = $theobject->{parent_id};
				$theobject->{container_id} = $objects->{$theobject->{container_id}}{local_id};
				$theobject->{container_id} = -1 unless ($theobject->{container_id});
			}

			$theobject->{object_id} = $objects->{$object_id}{local_id};

			if ($config{uniquenames}) {
				$theobject->{name} = substr($theobject->{name}, 0, 49 - length($theobject->{object_id}));
				$theobject->{name} =~ s/\s*$//;
				$theobject->{name} .= $theobject->{object_id};
			}

			updateobject ($dbh, $object_id, $theobject, "uobject", "iobject");
			updateobject ($dbh, $object_id, $theobject, "u$otype", "i$otype");
			if ($theobject->{type} eq 'sql') {
				$theobject->{parsetext} = $theobject->{parsetext}{parsetext} if (ref($theobject->{parsetext}));
				updateobject ($dbh, $object_id, $theobject, "upscripts", "ipscripts");
			}

			updateimports($dbh, $config{context}, $object_id, $theobject, $objects);
		}
	}

	foreach my $obj_id (keys %$attributes) {
		next if ($himports->{$obj_id}{last_epochmodified} >= $objects->{$obj_id}{last_epochmodified});
		my $object_id = $objects->{$obj_id}{local_id};
		my $ret = $dbh->updateattributes($object_id, $attributes->{$obj_id});
		die "Unable to update attributes for $object_id" if ($ret <= 0);
	}

	foreach my $obj_id (keys %$mapping) {
		next if ($himports->{$obj_id}{last_epochmodified} >= $objects->{$obj_id}{last_epochmodified});
		my $object_id = $objects->{$obj_id}{local_id};
		foreach my $so (@{$mapping->{$obj_id}}) {
			$so->{subflow_id} = $object_id;
			$so->{outgofield_id} = $objects->{$so->{outgofield_id}}{local_id};
			if ($so->{incomfield_id}) { $so->{incomfield_id} = $objects->{$so->{incomfield_id}}{local_id}; }
			else { $so->{incomfield_id} = -1; }
			$so->{script_id} = $objects->{$so->{script_id}}{local_id} if ($so->{script_id});
		}
		my $ret = $dbh->updatemymapping($object_id, $mapping->{$obj_id});
		die "Unable to update mapping for $object_id" if ($ret <= 0);
	}

	foreach my $obj_id (keys %$objscr) {
		next if ($himports->{$obj_id}{last_epochmodified} >= $objects->{$obj_id}{last_epochmodified});
		my $object_id = $objects->{$obj_id}{local_id};
		foreach my $so (@{$objscr->{$obj_id}}) {
			$so->{object_id} = $object_id;
			$so->{script_id} = $objects->{$so->{script_id}}{local_id};
		}
		my $ret = $dbh->updatemyscripts($object_id, $objscr->{$obj_id});
		die "Unable to update attributes for $object_id" if ($ret <= 0);
	}

	foreach my $obj_id (keys %$otherobj) {
		next if ($himports->{$obj_id}{last_epochmodified} >= $objects->{$obj_id}{last_epochmodified});
		my $object_id = $objects->{$obj_id}{local_id};
		next unless ($object_id);
		my @oorel;
		foreach my $oo (@{$objscr->{$obj_id}}) {
			#	$oo->{parent_id} = $object_id;
			#	$oo->{child_id} = $objects->{$oo->{child_id}}{local_id};
#			print "updatemyobjects for : $object_id => $oo->{child_id} / $objects->{$oo->{child_id}}{local_id}\n";
			next unless ($object_id and $oo->{child_id} and $objects->{$oo->{child_id}}{local_id});
			push @oorel, {parent_id => $object_id, child_id => $objects->{$oo->{child_id}}{local_id} };

		}
		my $ret;
		eval {
			$ret = $dbh->updatemyobjects($object_id, \@oorel); #$otherobj->{$obj_id});
		};
		die "Unable to update attributes for $object_id $@" if (($ret <= 0) || $@);
	}


	
	my $cwd = Cwd->getcwd();
	chdir $config{opath};
	my $now = time();
	my $donefile = $config{ofile} . "done";
	if (-f "$donefile") {
		utime $now, $now, $donefile;
	}
	else {
		open O, ">$donefile";
		print O cafUtils->datetime1(), "\n";
		close O;
	}
	chdir $cwd;
	$dbh->rollback();
#	$dbh->commit();
#	$dbh->disconnect();
	$objectCount;

};

sub meth_edit {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;

	$self->_getcheckfields ($cgi, $editfields);

	my $actiondetail = $self->_hiddenvar ("_actiondetail");

	my $cwd = Cwd->getcwd();
	chdir $conf->wd();
	chdir "exports";
	my $expdir = Cwd->getcwd();
	chdir $cwd;


	my $objcounts = $cgi->param("_listexportedobjectscount");
	my @selectedObjects;
	my $exportedobjects = [];
	my %checkedObjects;
	my $importInfo = $self->_datavar("_importinfo");
	my $textInfo;
	for (my $i = 0; $i <= $objcounts; $i++) {
		my $objectid;
		next unless ($objectid = $cgi->param("object_id_$i"));
		$checkedObjects{$objectid} = $cgi->param("import_$i");
		if ($checkedObjects{$objectid}) {
			my %config;
			$config{opath}       = $expdir;
			$config{ofile}       = $cgi->param("filename_$i");
			$config{opackage}    = $cgi->param("packagename_$i");
			$config{context}     = $cgi->param("context_$i");
			$config{force}       = $cgi->param("forceimport_$i");
			$config{uniquenames} = $self->_datavar("uniquenames");
			$config{objecttype}  = $cgi->param("objecttype_$i");
			my $importCount;
			eval { $importCount = $self->ImportObject($dbh, \%config); };
			if ($importCount) {
				$checkedObjects{$objectid} = undef;
				$textInfo = "<FONT COLOR=red><B>$config{objecttype} Object $objectid</B></FONT> was successfully imported from the file ";
				$textInfo .= "<B>$config{ofile}</B> in directory $expdir. Subsequently $importCount objects were imported";
				push (@$importInfo, $textInfo);
			}
			else {
				$textInfo = "$config{objecttype} Object $objectid; Error while importing Object";
				$textInfo .= "from the file <B>$config{ofile}</B> in directory $expdir :<BR><BR>$@";
				push @$importInfo, $textInfo;
			}
		}
		push @selectedObjects, $objectid;
	}

	return ($self->meth_search($cgi, $dbh, $conf));
	if ($#selectedObjects > -1) {
		my $query = $dbh->newquery({ object_id => \@selectedObjects });
		$query->sobjectlist();
		$exportedobjects = $dbh->hexecfetchall($query, 1) || [];
	}
	foreach my $obj (@$exportedobjects) { next unless ($obj); $obj->{export_it} = $checkedObjects{$obj->{object_id}}; }
	unshift @$exportedobjects, ({},{},{});
	$self->_hiddenvar ("_listexportedobjectscount", $#$exportedobjects);
	$self->{_exportedobjects} = $exportedobjects; 

	$self->{list1count} = -1 unless (defined($self->{list1count}));
	$self->{list1count} += 1;
	$self->_hiddenvar ("_objectid", "");
	$self->_setnavinfo("list1");
}

1;
