--echo #
--echo # Range optimizer
--echo #

CREATE TABLE t1 (a INET4, INDEX(a));
SHOW CREATE TABLE t1;

DELIMITER $$;
FOR i IN 0..255
DO
  INSERT INTO t1 VALUES (CONCAT('0.0.0.', i));
END FOR
$$
DELIMITER ;$$
SELECT * FROM t1 WHERE a='0.0.0.255';
EXPLAIN SELECT * FROM t1 WHERE a='0.0.0.255';
SELECT * FROM t1 WHERE a='garbage';
EXPLAIN SELECT * FROM t1 WHERE a='garbage';

SELECT * FROM t1 WHERE a>='0.0.0.254';
EXPLAIN SELECT * FROM t1 WHERE a>='0.0.0.254';
SELECT * FROM t1 WHERE a>='garbage';
EXPLAIN SELECT * FROM t1 WHERE a>='garbage';

SELECT * FROM t1 WHERE a IN ('0.0.0.128','0.0.0.160','0.0.0.240');
EXPLAIN SELECT * FROM t1 WHERE a IN ('0.0.0.128','0.0.0.160','0.0.0.240');
SELECT * FROM t1 WHERE a IN ('0.0.0.128','0.0.0.160','garbage');
EXPLAIN SELECT * FROM t1 WHERE a IN ('0.0.0.128','0.0.0.160','garbage');

SELECT * FROM t1 WHERE a BETWEEN '0.0.0.128' AND '0.0.0.129';
EXPLAIN SELECT * FROM t1 WHERE a BETWEEN '0.0.0.128' AND '0.0.0.129';
SELECT * FROM t1 WHERE a BETWEEN '0.0.0.128' AND 'garbage';
EXPLAIN SELECT * FROM t1 WHERE a BETWEEN '0.0.0.128' AND 'garbage';

SELECT * FROM t1 WHERE a=CAST('0.0.0.255' AS INET4);
EXPLAIN EXTENDED SELECT * FROM t1 WHERE a=CAST('0.0.0.255' AS INET4);

DROP TABLE t1;
