/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.BodyLoweringPass;
import org.jetbrains.kotlin.backend.common.CompilationExceptionKt;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBodyBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.IrElementBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrDeclarationBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrValueParameterBuilder;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOriginImpl;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrLocalDelegatedPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00122\u00020\u0001:\u0002\u0011\u0012B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/PropertyReferenceLowering;", "Lorg/jetbrains/kotlin/backend/common/BodyLoweringPass;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "referenceBuilderSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "localDelegateBuilderSymbol", "jsClassSymbol", "throwISE", "lower", "", "irBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "PropertyReferenceTransformer", "Companion", "backend.js"})
@SourceDebugExtension(value={"SMAP\nPropertyReferenceLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PropertyReferenceLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/PropertyReferenceLowering\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,277:1\n1863#2,2:278\n*S KotlinDebug\n*F\n+ 1 PropertyReferenceLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/PropertyReferenceLowering\n*L\n42#1:278,2\n*E\n"})
public final class PropertyReferenceLowering
implements BodyLoweringPass {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JsIrBackendContext context;
    @NotNull
    private final IrSimpleFunctionSymbol referenceBuilderSymbol;
    @NotNull
    private final IrSimpleFunctionSymbol localDelegateBuilderSymbol;
    @NotNull
    private final IrSimpleFunctionSymbol jsClassSymbol;
    @NotNull
    private final IrSimpleFunctionSymbol throwISE;
    @NotNull
    private static final IrDeclarationOriginImpl PROPERTY_REFERENCE_FACTORY = new IrDeclarationOriginImpl("PROPERTY_REFERNCE_FACTORY", false, 2, null);

    public PropertyReferenceLowering(@NotNull JsIrBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.referenceBuilderSymbol = this.context.getKpropertyBuilder();
        this.localDelegateBuilderSymbol = this.context.getKlocalDelegateBuilder();
        this.jsClassSymbol = this.context.getIntrinsics().getJsClass();
        this.throwISE = this.context.getIr().getSymbols().getThrowISE();
    }

    @Override
    public void lower(@NotNull IrBody irBody, @NotNull IrDeclaration container) {
        IrDeclarationParent currentParent;
        List<IrDeclaration> newDeclarations;
        Intrinsics.checkNotNullParameter((Object)irBody, (String)"irBody");
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        IrDeclarationParent irDeclarationParent = container instanceof IrDeclarationParent ? (IrDeclarationParent)((Object)container) : null;
        if (irDeclarationParent == null) {
            irDeclarationParent = container.getParent();
        }
        if (!(newDeclarations = new PropertyReferenceTransformer(currentParent = irDeclarationParent).process(irBody)).isEmpty()) {
            IrFile file2 = IrUtilsKt.getFile(container);
            Iterable $this$forEach$iv = newDeclarations;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IrDeclaration it = (IrDeclaration)element$iv;
                boolean bl = false;
                it.setParent(file2);
            }
            file2.getDeclarations().addAll((Collection<IrDeclaration>)newDeclarations);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/PropertyReferenceLowering$Companion;", "", "<init>", "()V", "PROPERTY_REFERENCE_FACTORY", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOriginImpl;", "getPROPERTY_REFERENCE_FACTORY", "()Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOriginImpl;", "backend.js"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IrDeclarationOriginImpl getPROPERTY_REFERENCE_FACTORY() {
            return PROPERTY_REFERENCE_FACTORY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J&\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0010H\u0002J&\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0010H\u0002J.\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0010H\u0002J\f\u0010\u001f\u001a\u00020\u0018*\u00020\u0016H\u0002J\f\u0010 \u001a\u00020\u0018*\u00020\u0018H\u0002J\u0010\u0010!\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020\u0016H\u0016J\u0010\u0010#\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020$H\u0002R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/PropertyReferenceLowering$PropertyReferenceTransformer;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "currentParent", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;", "<init>", "(Lorg/jetbrains/kotlin/ir/backend/js/lower/PropertyReferenceLowering;Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;)V", "getCurrentParent", "()Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;", "setCurrentParent", "(Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;)V", "newDeclarations", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "getNewDeclarations", "()Ljava/util/List;", "process", "", "irBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "buildFactoryFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "reference", "Lorg/jetbrains/kotlin/ir/expressions/IrPropertyReference;", "buildGetterLambda", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "factory", "boundValueParameters", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "buildSetterLambda", "buildAccessorLambda", "accessor", "nameExpression", "getJsTypeConstructor", "visitPropertyReference", "expression", "visitLocalDelegatedPropertyReference", "Lorg/jetbrains/kotlin/ir/expressions/IrLocalDelegatedPropertyReference;", "buildLocalDelegateLambda", "backend.js"})
    @SourceDebugExtension(value={"SMAP\nPropertyReferenceLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PropertyReferenceLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/PropertyReferenceLowering$PropertyReferenceTransformer\n+ 2 declarationBuilders.kt\norg/jetbrains/kotlin/ir/builders/declarations/DeclarationBuildersKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ExpressionHelpers.kt\norg/jetbrains/kotlin/ir/builders/ExpressionHelpersKt\n+ 5 IrBuilder.kt\norg/jetbrains/kotlin/ir/builders/IrBlockBodyBuilder\n+ 6 MemoryOptimizedCollectionUtil.kt\norg/jetbrains/kotlin/utils/MemoryOptimizedCollectionUtilKt\n+ 7 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,277:1\n237#2,4:278\n345#2,4:286\n237#2,4:326\n237#2,4:347\n1567#3:282\n1598#3,3:283\n1601#3:290\n808#3,11:303\n626#3,12:314\n1628#3,3:331\n416#4,10:291\n416#4,10:334\n416#4,10:351\n72#5,2:301\n72#5,2:344\n72#5,2:361\n16#6:330\n1#7:346\n*S KotlinDebug\n*F\n+ 1 PropertyReferenceLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/PropertyReferenceLowering$PropertyReferenceTransformer\n*L\n59#1:278,4\n70#1:286,4\n139#1:326,4\n252#1:347,4\n69#1:282\n69#1:283,3\n69#1:290\n137#1:303,11\n137#1:314,12\n148#1:331,3\n89#1:291,10\n157#1:334,10\n262#1:351,10\n89#1:301,2\n157#1:344,2\n262#1:361,2\n148#1:330\n*E\n"})
    private final class PropertyReferenceTransformer
    extends IrElementTransformerVoid {
        @NotNull
        private IrDeclarationParent currentParent;
        @NotNull
        private final List<IrDeclaration> newDeclarations;

        public PropertyReferenceTransformer(IrDeclarationParent currentParent) {
            Intrinsics.checkNotNullParameter((Object)currentParent, (String)"currentParent");
            this.currentParent = currentParent;
            this.newDeclarations = new ArrayList();
        }

        @NotNull
        public final IrDeclarationParent getCurrentParent() {
            return this.currentParent;
        }

        public final void setCurrentParent(@NotNull IrDeclarationParent irDeclarationParent) {
            Intrinsics.checkNotNullParameter((Object)irDeclarationParent, (String)"<set-?>");
            this.currentParent = irDeclarationParent;
        }

        @NotNull
        public final List<IrDeclaration> getNewDeclarations() {
            return this.newDeclarations;
        }

        @NotNull
        public final List<IrDeclaration> process(@NotNull IrBody irBody) {
            Intrinsics.checkNotNullParameter((Object)irBody, (String)"irBody");
            IrElementTransformerVoidKt.transformChildrenVoid(irBody, this);
            return this.newDeclarations;
        }

        /*
         * WARNING - void declaration
         */
        private final IrSimpleFunction buildFactoryFunction(IrPropertyReference reference2) {
            void $this$buildFactoryFunction_u24lambda_u244_u24lambda_u243;
            void $this$buildFactoryFunction_u24lambda_u244;
            IrCall irCall;
            void this_$iv$iv;
            void $this$irBlockBody_u24default$iv;
            void arg;
            Object object;
            Object item$iv$iv;
            IrBuilderWithScope $this$mapIndexedTo$iv$iv;
            IrProperty property = (IrProperty)((IrPropertySymbol)reference2.getSymbol()).getOwner();
            IrFactory $this$buildFun$iv = PropertyReferenceLowering.this.context.getIrFactory();
            boolean $i$f$buildFun22 = false;
            IrFunctionBuilder $this$buildFun_u24lambda_u2420$iv = new IrFunctionBuilder();
            boolean bl = false;
            Object $this$buildFactoryFunction_u24lambda_u240 = $this$buildFun_u24lambda_u2420$iv;
            boolean bl2 = false;
            ((IrElementBuilder)$this$buildFactoryFunction_u24lambda_u240).setStartOffset(reference2.getStartOffset());
            ((IrElementBuilder)$this$buildFactoryFunction_u24lambda_u240).setEndOffset(reference2.getEndOffset());
            ((IrFunctionBuilder)$this$buildFactoryFunction_u24lambda_u240).setReturnType(reference2.getType());
            ((IrDeclarationBuilder)$this$buildFactoryFunction_u24lambda_u240).setName(Name.identifier(property.getName().asString() + "$factory"));
            ((IrDeclarationBuilder)$this$buildFactoryFunction_u24lambda_u240).setOrigin(Companion.getPROPERTY_REFERENCE_FACTORY());
            IrSimpleFunction factoryDeclaration = DeclarationBuildersKt.buildFunction($this$buildFun$iv, $this$buildFun_u24lambda_u2420$iv);
            Object[] $i$f$buildFun22 = new IrExpression[]{reference2.getDispatchReceiver(), reference2.getExtensionReceiver()};
            List boundArguments = kotlin.collections.CollectionsKt.listOfNotNull((Object[])$i$f$buildFun22);
            Iterable $this$mapIndexed$iv = boundArguments;
            boolean $i$f$mapIndexed = false;
            $this$buildFactoryFunction_u24lambda_u240 = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            Iterator iterator2 = $this$mapIndexedTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void i;
                int n;
                item$iv$iv = iterator2.next();
                if ((n = index$iv$iv++) < 0) {
                    kotlin.collections.CollectionsKt.throwIndexOverflow();
                }
                IrExpression irExpression = (IrExpression)item$iv$iv;
                int n2 = n;
                object = destination$iv$iv;
                boolean bl3 = false;
                boolean $i$f$buildValueParameter = false;
                IrValueParameterBuilder $this$buildValueParameter_u24lambda_u2430$iv = new IrValueParameterBuilder();
                boolean bl4 = false;
                IrValueParameterBuilder $this$buildFactoryFunction_u24lambda_u242_u24lambda_u241 = $this$buildValueParameter_u24lambda_u2430$iv;
                boolean bl5 = false;
                $this$buildFactoryFunction_u24lambda_u242_u24lambda_u241.setType(arg.getType());
                $this$buildFactoryFunction_u24lambda_u242_u24lambda_u241.setIndex((int)i);
                $this$buildFactoryFunction_u24lambda_u242_u24lambda_u241.setName(Name.identifier("$b" + (int)i));
                object.add(DeclarationBuildersKt.buildValueParameter(((IrDeclaration)factoryDeclaration).getFactory(), $this$buildValueParameter_u24lambda_u2430$iv, (IrDeclarationParent)((Object)((IrDeclaration)factoryDeclaration))));
            }
            List valueParameters = (List)destination$iv$iv;
            factoryDeclaration.setValueParameters(valueParameters);
            IrType irType = reference2.getType();
            Intrinsics.checkNotNull((Object)irType, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.types.IrSimpleType");
            int arity = ((IrSimpleType)irType).getArguments().size() - 1;
            DeclarationIrBuilder irBuilder = LowerUtilsKt.createIrBuilder$default(PropertyReferenceLowering.this.context, (IrSymbol)factoryDeclaration.getSymbol(), 0, 0, 6, null);
            $this$mapIndexedTo$iv$iv = irBuilder;
            PropertyReferenceLowering propertyReferenceLowering2 = PropertyReferenceLowering.this;
            int startOffset$iv = $this$irBlockBody_u24default$iv.getStartOffset();
            int endOffset$iv = $this$irBlockBody_u24default$iv.getEndOffset();
            boolean $i$f$irBlockBody = false;
            item$iv$iv = new IrBlockBodyBuilder($this$irBlockBody_u24default$iv.getContext(), $this$irBlockBody_u24default$iv.getScope(), startOffset$iv, endOffset$iv);
            boolean $i$f$blockBody = false;
            arg = this_$iv$iv;
            object = factoryDeclaration;
            boolean bl6 = false;
            IrCall $i$f$buildValueParameter = irCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$buildFactoryFunction_u24lambda_u244, propertyReferenceLowering2.referenceBuilderSymbol);
            IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$buildFactoryFunction_u24lambda_u244;
            void var20_30 = $this$buildFactoryFunction_u24lambda_u244;
            boolean bl7 = false;
            $this$buildFactoryFunction_u24lambda_u244_u24lambda_u243.putValueArgument(0, this.nameExpression(reference2));
            $this$buildFactoryFunction_u24lambda_u244_u24lambda_u243.putValueArgument(1, ExpressionHelpersKt.irInt$default((IrBuilderWithScope)$this$buildFactoryFunction_u24lambda_u244, arity, null, 2, null));
            $this$buildFactoryFunction_u24lambda_u244_u24lambda_u243.putValueArgument(2, this.getJsTypeConstructor(reference2));
            $this$buildFactoryFunction_u24lambda_u244_u24lambda_u243.putValueArgument(3, this.buildGetterLambda(factoryDeclaration, reference2, valueParameters));
            $this$buildFactoryFunction_u24lambda_u244_u24lambda_u243.putValueArgument(4, this.buildSetterLambda(factoryDeclaration, reference2, valueParameters));
            Unit unit = Unit.INSTANCE;
            var20_30.unaryPlus(ExpressionHelpersKt.irReturn(irBuilderWithScope, irCall));
            ((IrFunction)object).setBody(this_$iv$iv.doBuild());
            this.newDeclarations.add(factoryDeclaration);
            return factoryDeclaration;
        }

        private final IrExpression buildGetterLambda(IrSimpleFunction factory, IrPropertyReference reference2, List<? extends IrValueParameter> boundValueParameters) {
            Object object = reference2.getGetter();
            if (object == null || (object = (IrSimpleFunction)object.getOwner()) == null) {
                CompilationExceptionKt.compilationException("Getter expected", reference2);
                throw null;
            }
            Object getter2 = object;
            return this.buildAccessorLambda(factory, (IrSimpleFunction)getter2, reference2, boundValueParameters);
        }

        private final IrExpression buildSetterLambda(IrSimpleFunction factory, IrPropertyReference reference2, List<? extends IrValueParameter> boundValueParameters) {
            IrPropertyReference irPropertyReference = reference2;
            PropertyReferenceLowering propertyReferenceLowering2 = PropertyReferenceLowering.this;
            IrPropertyReference $this$buildSetterLambda_u24lambda_u245 = irPropertyReference;
            boolean bl = false;
            Object object = $this$buildSetterLambda_u24lambda_u245.getSetter();
            if (object == null || (object = (IrSimpleFunction)object.getOwner()) == null) {
                return IrConstImpl.Companion.constNull($this$buildSetterLambda_u24lambda_u245.getStartOffset(), $this$buildSetterLambda_u24lambda_u245.getEndOffset(), propertyReferenceLowering2.context.getIrBuiltIns().getNothingNType());
            }
            Object setter2 = object;
            return this.buildAccessorLambda(factory, (IrSimpleFunction)setter2, reference2, boundValueParameters);
        }

        /*
         * WARNING - void declaration
         */
        private final IrExpression buildAccessorLambda(IrSimpleFunction factory, IrSimpleFunction accessor, IrPropertyReference reference2, List<? extends IrValueParameter> boundValueParameters) {
            int n;
            void $this$buildAccessorLambda_u24lambda_u249;
            void this_$iv$iv;
            Object object;
            void $this$mapTo$iv$iv;
            void $this$single$iv;
            void $this$filterIsInstanceTo$iv$iv;
            String string2;
            IrSimpleFunctionSymbol irSimpleFunctionSymbol = accessor.getSymbol();
            if (Intrinsics.areEqual((Object)irSimpleFunctionSymbol, (Object)reference2.getGetter())) {
                string2 = "get";
            } else if (Intrinsics.areEqual((Object)irSimpleFunctionSymbol, (Object)reference2.getSetter())) {
                string2 = "set";
            } else {
                CompilationExceptionKt.compilationException("Unexpected accessor", accessor);
                throw null;
            }
            String superName = string2;
            IrType irType = reference2.getType();
            Intrinsics.checkNotNull((Object)irType, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.types.IrSimpleType");
            IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull((IrSimpleType)irType);
            if (irClassSymbol == null) {
                CompilationExceptionKt.compilationException("Simple type expected", reference2);
                throw null;
            }
            IrClassSymbol classifier = irClassSymbol;
            Iterable $this$filterIsInstance$iv = ((IrClass)classifier.getOwner()).getDeclarations();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof IrSimpleFunction)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$single = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$single$iv) {
                IrSimpleFunction it = (IrSimpleFunction)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName().asString(), (Object)superName)) continue;
                if (found$iv) {
                    throw new IllegalArgumentException("Collection contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv = true;
            }
            if (!found$iv) {
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            IrSimpleFunction supperAccessor = single$iv;
            IrFactory $this$buildFun$iv = PropertyReferenceLowering.this.context.getIrFactory();
            boolean $i$f$buildFun = false;
            IrFunctionBuilder $this$buildFun_u24lambda_u2420$iv = new IrFunctionBuilder();
            boolean $i$a$-run-DeclarationBuildersKt$buildFun$1$iv22 = false;
            IrFunctionBuilder $this$buildAccessorLambda_u24lambda_u247 = $this$buildFun_u24lambda_u2420$iv;
            boolean bl = false;
            $this$buildAccessorLambda_u24lambda_u247.setStartOffset(reference2.getStartOffset());
            $this$buildAccessorLambda_u24lambda_u247.setEndOffset(reference2.getEndOffset());
            $this$buildAccessorLambda_u24lambda_u247.setReturnType(supperAccessor.getReturnType());
            $this$buildAccessorLambda_u24lambda_u247.setName(supperAccessor.getName());
            IrSimpleFunction function2 = DeclarationBuildersKt.buildFunction($this$buildFun$iv, $this$buildFun_u24lambda_u2420$iv);
            function2.setParent(factory);
            Collection $this$memoryOptimizedMap$iv = supperAccessor.getValueParameters();
            boolean $i$f$memoryOptimizedMap = false;
            Iterable $i$a$-run-DeclarationBuildersKt$buildFun$1$iv22 = $this$memoryOptimizedMap$iv;
            Collection destination$iv$iv2 = new ArrayList($this$memoryOptimizedMap$iv.size());
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv;
                object = destination$iv$iv2;
                boolean bl2 = false;
                object.add(IrUtilsKt.copyTo$default((IrValueParameter)it, function2, null, 0, 0, 0, null, null, null, null, null, false, false, false, 8190, null));
            }
            List unboundValueParameters = CollectionsKt.compactIfPossible((List)destination$iv$iv2);
            function2.setValueParameters(unboundValueParameters);
            int arity = unboundValueParameters.size();
            int total = arity + boundValueParameters.size();
            int b = 0;
            int u = 0;
            DeclarationIrBuilder irBuilder = LowerUtilsKt.createIrBuilder$default(PropertyReferenceLowering.this.context, (IrSymbol)function2.getSymbol(), 0, 0, 6, null);
            IrBuilderWithScope $this$irBlockBody_u24default$iv = irBuilder;
            int startOffset$iv = $this$irBlockBody_u24default$iv.getStartOffset();
            int endOffset$iv = $this$irBlockBody_u24default$iv.getEndOffset();
            boolean $i$f$irBlockBody = false;
            IrBlockBodyBuilder irBlockBodyBuilder = new IrBlockBodyBuilder($this$irBlockBody_u24default$iv.getContext(), $this$irBlockBody_u24default$iv.getScope(), startOffset$iv, endOffset$iv);
            boolean $i$f$blockBody = false;
            void var21_39 = this_$iv$iv;
            object = function2;
            boolean bl3 = false;
            IrCall irAccessorCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$buildAccessorLambda_u24lambda_u249, accessor.getSymbol());
            if (accessor.getDispatchReceiverParameter() != null) {
                IrExpression irExpression;
                if (reference2.getDispatchReceiver() != null) {
                    n = b;
                    b = n + 1;
                    irExpression = ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$buildAccessorLambda_u24lambda_u249, boundValueParameters.get(n));
                } else {
                    n = u;
                    u = n + 1;
                    irExpression = ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$buildAccessorLambda_u24lambda_u249, (IrValueDeclaration)unboundValueParameters.get(n));
                }
                irAccessorCall.setDispatchReceiver(irExpression);
            }
            if (accessor.getExtensionReceiverParameter() != null) {
                IrExpression irExpression;
                if (reference2.getExtensionReceiver() != null) {
                    n = b;
                    b = n + 1;
                    irExpression = ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$buildAccessorLambda_u24lambda_u249, boundValueParameters.get(n));
                } else {
                    n = u;
                    u = n + 1;
                    irExpression = ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$buildAccessorLambda_u24lambda_u249, (IrValueDeclaration)unboundValueParameters.get(n));
                }
                irAccessorCall.setExtensionReceiver(irExpression);
            }
            if (u < unboundValueParameters.size()) {
                n = u;
                u = n + 1;
                irAccessorCall.putValueArgument(0, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$buildAccessorLambda_u24lambda_u249, (IrValueDeclaration)unboundValueParameters.get(n)));
            }
            int n2 = n = u == arity ? 1 : 0;
            if (_Assertions.ENABLED && n == 0) {
                String string3 = "Assertion failed";
                throw new AssertionError((Object)string3);
            }
            int n3 = n = u + b == total ? 1 : 0;
            if (_Assertions.ENABLED && n == 0) {
                String string4 = "Assertion failed";
                throw new AssertionError((Object)string4);
            }
            $this$buildAccessorLambda_u24lambda_u249.unaryPlus(ExpressionHelpersKt.irReturn((IrBuilderWithScope)$this$buildAccessorLambda_u24lambda_u249, irAccessorCall));
            ((IrFunction)object).setBody(this_$iv$iv.doBuild());
            return BuildersKt.IrFunctionExpressionImpl(reference2.getStartOffset(), reference2.getEndOffset(), PropertyReferenceLowering.this.context.getIrBuiltIns().getAnyType(), function2, IrStatementOrigin.Companion.getLAMBDA());
        }

        private final IrExpression nameExpression(IrPropertyReference $this$nameExpression) {
            String string2 = ((IrProperty)((IrPropertySymbol)$this$nameExpression.getSymbol()).getOwner()).getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
            String propertyName = string2;
            return IrConstImpl.Companion.string($this$nameExpression.getStartOffset(), $this$nameExpression.getEndOffset(), PropertyReferenceLowering.this.context.getIrBuiltIns().getStringType(), propertyName);
        }

        private final IrExpression getJsTypeConstructor(IrExpression $this$getJsTypeConstructor) {
            IrCallImpl irCall = new IrCallImpl($this$getJsTypeConstructor.getStartOffset(), $this$getJsTypeConstructor.getEndOffset(), ((IrSimpleFunction)PropertyReferenceLowering.this.jsClassSymbol.getOwner()).getReturnType(), PropertyReferenceLowering.this.jsClassSymbol, 1, 0, null, null, 192, null);
            irCall.putTypeArgument(0, $this$getJsTypeConstructor.getType());
            return irCall;
        }

        @Override
        @NotNull
        public IrExpression visitPropertyReference(@NotNull IrPropertyReference expression2) {
            IrCallImpl irCallImpl;
            block3: {
                int n;
                IrExpression it;
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                IrSimpleFunction factoryFunction = this.buildFactoryFunction(expression2);
                boolean bl2 = bl = expression2.getValueArgumentsCount() == 0;
                if (_Assertions.ENABLED && !bl) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                IrCallImpl $this$visitPropertyReference_u24lambda_u2412 = irCallImpl = new IrCallImpl(expression2.getStartOffset(), expression2.getEndOffset(), expression2.getType(), factoryFunction.getSymbol(), expression2.getTypeArgumentsCount(), factoryFunction.getValueParameters().size(), null, null, 192, null);
                boolean bl3 = false;
                int n2 = $this$visitPropertyReference_u24lambda_u2412.getTypeArgumentsCount();
                for (int ti = 0; ti < n2; ++ti) {
                    $this$visitPropertyReference_u24lambda_u2412.putTypeArgument(ti, expression2.getTypeArgument(ti));
                }
                int vi = 0;
                IrExpression irExpression = expression2.getDispatchReceiver();
                if (irExpression != null) {
                    it = irExpression;
                    boolean bl4 = false;
                    n = vi;
                    vi = n + 1;
                    $this$visitPropertyReference_u24lambda_u2412.putValueArgument(n, it);
                }
                IrExpression irExpression2 = expression2.getExtensionReceiver();
                if (irExpression2 == null) break block3;
                it = irExpression2;
                boolean bl5 = false;
                n = vi;
                vi = n + 1;
                $this$visitPropertyReference_u24lambda_u2412.putValueArgument(n, it);
            }
            return irCallImpl;
        }

        @Override
        @NotNull
        public IrExpression visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
            IrLocalDelegatedPropertyReference irLocalDelegatedPropertyReference = expression2;
            PropertyReferenceLowering propertyReferenceLowering2 = PropertyReferenceLowering.this;
            IrLocalDelegatedPropertyReference $this$visitLocalDelegatedPropertyReference_u24lambda_u2413 = irLocalDelegatedPropertyReference;
            boolean bl = false;
            IrCallImpl builderCall = new IrCallImpl($this$visitLocalDelegatedPropertyReference_u24lambda_u2413.getStartOffset(), $this$visitLocalDelegatedPropertyReference_u24lambda_u2413.getEndOffset(), $this$visitLocalDelegatedPropertyReference_u24lambda_u2413.getType(), propertyReferenceLowering2.localDelegateBuilderSymbol, $this$visitLocalDelegatedPropertyReference_u24lambda_u2413.getTypeArgumentsCount(), 4, null, null, 192, null);
            String string2 = ((IrLocalDelegatedProperty)((IrLocalDelegatedPropertySymbol)expression2.getSymbol()).getOwner()).getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
            String localName = string2;
            boolean isMutable = expression2.getSetter() != null;
            IrLocalDelegatedPropertyReference irLocalDelegatedPropertyReference2 = expression2;
            PropertyReferenceLowering propertyReferenceLowering3 = PropertyReferenceLowering.this;
            IrLocalDelegatedPropertyReference $this$visitLocalDelegatedPropertyReference_u24lambda_u2414 = irLocalDelegatedPropertyReference2;
            boolean bl2 = false;
            builderCall.putValueArgument(0, IrConstImpl.Companion.string($this$visitLocalDelegatedPropertyReference_u24lambda_u2414.getStartOffset(), $this$visitLocalDelegatedPropertyReference_u24lambda_u2414.getEndOffset(), propertyReferenceLowering3.context.getIrBuiltIns().getStringType(), localName));
            builderCall.putValueArgument(1, this.getJsTypeConstructor(expression2));
            builderCall.putValueArgument(2, IrConstImpl.Companion.boolean($this$visitLocalDelegatedPropertyReference_u24lambda_u2414.getStartOffset(), $this$visitLocalDelegatedPropertyReference_u24lambda_u2414.getEndOffset(), propertyReferenceLowering3.context.getIrBuiltIns().getBooleanType(), isMutable));
            builderCall.putValueArgument(3, this.buildLocalDelegateLambda(expression2));
            return builderCall;
        }

        /*
         * WARNING - void declaration
         */
        private final IrExpression buildLocalDelegateLambda(IrLocalDelegatedPropertyReference expression2) {
            void this_$iv$iv;
            void $this$buildLocalDelegateLambda_u24lambda_u2417;
            void $this$buildFun$iv;
            IrVariable delegatedVar = (IrVariable)expression2.getDelegate().getOwner();
            Object object = PropertyReferenceLowering.this.context.getIrFactory();
            PropertyReferenceLowering propertyReferenceLowering2 = PropertyReferenceLowering.this;
            boolean $i$f$buildFun22 = false;
            IrFunctionBuilder $this$buildFun_u24lambda_u2420$iv = new IrFunctionBuilder();
            boolean bl = false;
            IrFunctionBuilder $this$buildLocalDelegateLambda_u24lambda_u2415 = $this$buildFun_u24lambda_u2420$iv;
            boolean bl2 = false;
            $this$buildLocalDelegateLambda_u24lambda_u2415.setStartOffset(expression2.getStartOffset());
            $this$buildLocalDelegateLambda_u24lambda_u2415.setEndOffset(expression2.getEndOffset());
            $this$buildLocalDelegateLambda_u24lambda_u2415.setReturnType(propertyReferenceLowering2.context.getIrBuiltIns().getNothingType());
            $this$buildLocalDelegateLambda_u24lambda_u2415.setName(Name.identifier(delegatedVar.getName() + "$stub"));
            IrSimpleFunction function2 = DeclarationBuildersKt.buildFunction((IrFactory)$this$buildFun$iv, $this$buildFun_u24lambda_u2420$iv);
            function2.setParent(this.currentParent);
            object = LowerUtilsKt.createIrBuilder$default(PropertyReferenceLowering.this.context, (IrSymbol)function2.getSymbol(), 0, 0, 6, null);
            propertyReferenceLowering2 = PropertyReferenceLowering.this;
            Object $i$f$buildFun22 = object;
            IrSimpleFunction irSimpleFunction = function2;
            boolean bl3 = false;
            IrBuilderWithScope $this$irBlockBody_u24default$iv = (IrBuilderWithScope)$this$buildLocalDelegateLambda_u24lambda_u2417;
            int startOffset$iv = $this$irBlockBody_u24default$iv.getStartOffset();
            int endOffset$iv = $this$irBlockBody_u24default$iv.getEndOffset();
            boolean $i$f$irBlockBody = false;
            IrBlockBodyBuilder irBlockBodyBuilder = new IrBlockBodyBuilder($this$irBlockBody_u24default$iv.getContext(), $this$irBlockBody_u24default$iv.getScope(), startOffset$iv, endOffset$iv);
            boolean $i$f$blockBody = false;
            void $this$buildLocalDelegateLambda_u24lambda_u2417_u24lambda_u2416 = this_$iv$iv;
            boolean bl4 = false;
            $this$buildLocalDelegateLambda_u24lambda_u2417_u24lambda_u2416.unaryPlus(ExpressionHelpersKt.irReturn((IrBuilderWithScope)$this$buildLocalDelegateLambda_u24lambda_u2417_u24lambda_u2416, ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$buildLocalDelegateLambda_u24lambda_u2417_u24lambda_u2416, propertyReferenceLowering2.throwISE)));
            irSimpleFunction.setBody(this_$iv$iv.doBuild());
            object = expression2;
            propertyReferenceLowering2 = PropertyReferenceLowering.this;
            Object $this$buildLocalDelegateLambda_u24lambda_u2418 = object;
            boolean bl5 = false;
            return BuildersKt.IrFunctionExpressionImpl($this$buildLocalDelegateLambda_u24lambda_u2418.getStartOffset(), $this$buildLocalDelegateLambda_u24lambda_u2418.getEndOffset(), propertyReferenceLowering2.context.getIrBuiltIns().getAnyType(), function2, IrStatementOrigin.Companion.getLAMBDA());
        }
    }
}

