"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _constants = require("../utils/constants");
var _lodash = _interopRequireDefault(require("lodash"));
var _helpers = require("../../common/helpers");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

let metricsCounter = _lodash.default.cloneDeep(_constants.DEFAULT_METRICS_COUNTER);
class MetricsService {
  async getMetrics(_context, _request, response) {
    const metricsSnapshot = {
      ...metricsCounter
    };
    metricsCounter = _lodash.default.cloneDeep(_constants.DEFAULT_METRICS_COUNTER);
    return response.custom({
      statusCode: 200,
      body: {
        ok: true,
        response: metricsSnapshot
      }
    });
  }
  async updateMetrics(_context, request, response) {
    const metrics = request.body;
    metricsCounter = (0, _helpers.aggregateMetrics)(metrics, metricsCounter);
    return response.ok({
      body: metricsCounter
    });
  }
}
exports.default = MetricsService;
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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