/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.net;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import net.wimpi.modbus.net.TCPConnectionHandler;
import net.wimpi.modbus.net.TCPSlaveConnection;
import net.wimpi.modbus.net.TCPSlaveConnectionFactory;
import net.wimpi.modbus.util.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModbusTCPListener
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(ModbusTCPListener.class);
    private static int c_RequestCounter = 0;
    private ServerSocket m_ServerSocket = null;
    private ThreadPool m_ThreadPool;
    private Thread m_Listener;
    private int m_Port = 502;
    private int m_FloodProtection = 5;
    private boolean m_Listening;
    private InetAddress m_Address;
    private TCPSlaveConnectionFactory m_ConnectionFactory;
    private static final int REQUESTS_TOGC = 10;

    private static InetAddress getLocalHost() {
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    public ModbusTCPListener(int poolsize, TCPSlaveConnectionFactory connectionFactory) {
        this(poolsize, ModbusTCPListener.getLocalHost(), connectionFactory);
    }

    public ModbusTCPListener(int poolsize) {
        this(poolsize, new TCPSlaveConnectionFactoryImpl());
    }

    public ModbusTCPListener(int poolsize, InetAddress addr, TCPSlaveConnectionFactory connectionFactory) {
        this.m_ThreadPool = new ThreadPool(poolsize);
        this.m_Address = addr;
        this.m_ConnectionFactory = connectionFactory;
    }

    public ModbusTCPListener(int poolsize, InetAddress addr) {
        this(poolsize, addr, new TCPSlaveConnectionFactoryImpl());
    }

    public void setPort(int port) {
        this.m_Port = port;
    }

    public int getLocalPort() {
        if (this.m_ServerSocket == null) {
            return -1;
        }
        return this.m_ServerSocket.getLocalPort();
    }

    public void setAddress(InetAddress addr) {
        this.m_Address = addr;
    }

    public void start() {
        this.m_Listener = new Thread(this);
        this.m_Listener.start();
        this.m_Listening = true;
    }

    public void stop() {
        this.m_Listening = false;
        try {
            this.m_ServerSocket.close();
            this.m_Listener.join();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        try {
            this.m_ServerSocket = new ServerSocket(this.m_Port, this.m_FloodProtection, this.m_Address);
            logger.debug("Listenening to {} (Port {})", (Object)this.m_ServerSocket.toString(), (Object)this.m_Port);
            do {
                Socket incoming = this.m_ServerSocket.accept();
                logger.debug("Making new connection {}", (Object)incoming.toString());
                if (this.m_Listening) {
                    this.m_ThreadPool.execute(new TCPConnectionHandler(this.m_ConnectionFactory.create(incoming)));
                    this.count();
                    continue;
                }
                incoming.close();
            } while (this.m_Listening);
        }
        catch (SocketException iex) {
            if (!this.m_Listening) {
                return;
            }
            iex.printStackTrace();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean isListening() {
        return this.m_Listening;
    }

    private void count() {
        if (++c_RequestCounter == 10) {
            System.gc();
            c_RequestCounter = 0;
        }
    }

    public static class TCPSlaveConnectionFactoryImpl
    implements TCPSlaveConnectionFactory {
        @Override
        public TCPSlaveConnection create(Socket socket) {
            return new TCPSlaveConnection(socket);
        }
    }
}

