/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.entity.internal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.log.LoggingHelper;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.property.access.spi.Getter;
import org.hibernate.property.access.spi.Setter;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.InitializerData;
import org.hibernate.sql.results.graph.InitializerParent;
import org.hibernate.sql.results.graph.entity.EntityInitializer;
import org.hibernate.sql.results.graph.entity.internal.AbstractBatchEntitySelectFetchInitializer;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;
import org.hibernate.type.Type;

public class BatchEntityInsideEmbeddableSelectFetchInitializer
extends AbstractBatchEntitySelectFetchInitializer<BatchEntityInsideEmbeddableSelectFetchInitializerData> {
    protected final Setter referencedModelPartSetter;
    protected final AttributeMapping[] rootEmbeddableAttributes;
    protected final Getter[] rootEmbeddableGetters;
    protected final Type[] rootEmbeddablePropertyTypes;
    public static final Serializable BATCH_PROPERTY = new Serializable(){

        public String toString() {
            return "<batch>";
        }

        public Object readResolve() {
            return BATCH_PROPERTY;
        }
    };

    public BatchEntityInsideEmbeddableSelectFetchInitializer(InitializerParent<?> parentAccess, ToOneAttributeMapping referencedModelPart, NavigablePath fetchedNavigable, EntityPersister concreteDescriptor, DomainResult<?> keyResult, boolean affectedByFilter, AssemblerCreationState creationState) {
        super(parentAccess, referencedModelPart, fetchedNavigable, concreteDescriptor, keyResult, affectedByFilter, creationState);
        this.referencedModelPartSetter = referencedModelPart.getAttributeMetadata().getPropertyAccess().getSetter();
        String rootEmbeddablePropertyName = BatchEntityInsideEmbeddableSelectFetchInitializer.getRootEmbeddablePropertyName(this.owningEntityInitializer, parentAccess, referencedModelPart);
        this.rootEmbeddableAttributes = this.getParentEntityAttributes(rootEmbeddablePropertyName);
        Getter[] getters = new Getter[this.rootEmbeddableAttributes.length];
        for (int i = 0; i < this.rootEmbeddableAttributes.length; ++i) {
            if (this.rootEmbeddableAttributes[i] == null) continue;
            getters[i] = this.rootEmbeddableAttributes[i].getAttributeMetadata().getPropertyAccess().getGetter();
        }
        this.rootEmbeddableGetters = getters;
        this.rootEmbeddablePropertyTypes = this.getParentEntityAttributeTypes(rootEmbeddablePropertyName);
    }

    @Override
    protected InitializerData createInitializerData(RowProcessingState rowProcessingState) {
        return new BatchEntityInsideEmbeddableSelectFetchInitializerData(this, rowProcessingState);
    }

    protected Type[] getParentEntityAttributeTypes(String attributeName) {
        EntityPersister entityDescriptor = this.owningEntityInitializer.getEntityDescriptor();
        Type[] attributeTypes = new Type[entityDescriptor.getRootEntityDescriptor().getSubclassEntityNames().size()];
        this.initializeAttributeType(attributeTypes, entityDescriptor, attributeName);
        for (EntityMappingType subMappingType : entityDescriptor.getSubMappingTypes()) {
            this.initializeAttributeType(attributeTypes, subMappingType.getEntityPersister(), attributeName);
        }
        return attributeTypes;
    }

    protected void initializeAttributeType(Type[] attributeTypes, EntityPersister entityDescriptor, String attributeName) {
        if (this.rootEmbeddableAttributes[entityDescriptor.getSubclassId()] != null) {
            attributeTypes[entityDescriptor.getSubclassId()] = entityDescriptor.getPropertyType(attributeName);
        }
    }

    @Override
    protected void registerToBatchFetchQueue(BatchEntityInsideEmbeddableSelectFetchInitializerData data) {
        super.registerToBatchFetchQueue(data);
        data.setInstance(BATCH_PROPERTY);
    }

    @Override
    public void initializeInstance(BatchEntityInsideEmbeddableSelectFetchInitializerData data) {
        RowProcessingState rowProcessingState;
        Object owningData;
        int owningEntitySubclassId;
        AttributeMapping rootEmbeddableAttribute;
        super.initializeInstance(data);
        if (data.getInstance() == BATCH_PROPERTY && (rootEmbeddableAttribute = this.rootEmbeddableAttributes[owningEntitySubclassId = this.owningEntityInitializer.getConcreteDescriptor(owningData = this.owningEntityInitializer.getData(rowProcessingState = data.getRowProcessingState())).getSubclassId()]) != null) {
            HashMap<EntityKey, List<ParentInfo>> toBatchLoad = data.toBatchLoad;
            if (toBatchLoad == null) {
                toBatchLoad = data.toBatchLoad = new HashMap();
            }
            toBatchLoad.computeIfAbsent(data.entityKey, key -> new ArrayList()).add(new ParentInfo(this.owningEntityInitializer.getTargetInstance(owningData), this.parent.getResolvedInstance(rowProcessingState), rootEmbeddableAttribute.getStateArrayPosition(), owningEntitySubclassId));
        }
    }

    @Override
    protected void registerResolutionListener(BatchEntityInsideEmbeddableSelectFetchInitializerData data) {
    }

    @Override
    public void endLoading(BatchEntityInsideEmbeddableSelectFetchInitializerData data) {
        super.endLoading(data);
        HashMap<EntityKey, List<ParentInfo>> toBatchLoad = data.toBatchLoad;
        if (toBatchLoad != null) {
            for (Map.Entry<EntityKey, List<ParentInfo>> entry : toBatchLoad.entrySet()) {
                EntityKey entityKey = entry.getKey();
                List<ParentInfo> parentInfos = entry.getValue();
                SharedSessionContractImplementor session = data.getRowProcessingState().getSession();
                SessionFactoryImplementor factory = session.getFactory();
                PersistenceContext persistenceContext = session.getPersistenceContextInternal();
                Object loadedInstance = BatchEntityInsideEmbeddableSelectFetchInitializer.loadInstance(entityKey, this.toOneMapping, this.affectedByFilter, session);
                for (ParentInfo parentInfo : parentInfos) {
                    Object parentEntityInstance = parentInfo.parentEntityInstance;
                    EntityEntry parentEntityEntry = persistenceContext.getEntry(parentEntityInstance);
                    this.referencedModelPartSetter.set(parentInfo.parentInstance, loadedInstance);
                    Object[] loadedState = parentEntityEntry.getLoadedState();
                    if (loadedState == null) continue;
                    int parentEntitySubclassId = parentInfo.parentEntitySubclassId;
                    Object rootEmbeddable = this.rootEmbeddableGetters[parentEntitySubclassId].get(parentEntityInstance);
                    loadedState[parentInfo.propertyIndex] = this.rootEmbeddablePropertyTypes[parentEntitySubclassId].deepCopy(rootEmbeddable, factory);
                }
            }
            data.toBatchLoad = null;
        }
    }

    protected static String getRootEmbeddablePropertyName(EntityInitializer<?> firstEntityInitializer, InitializerParent<?> parent, ToOneAttributeMapping referencedModelPart) {
        NavigablePath entityPath = firstEntityInitializer.getNavigablePath();
        NavigablePath navigablePath = parent.getNavigablePath();
        if (navigablePath == entityPath) {
            return referencedModelPart.getPartName();
        }
        while (navigablePath.getParent() != entityPath) {
            navigablePath = navigablePath.getParent();
        }
        return navigablePath.getLocalName();
    }

    @Override
    public String toString() {
        return "BatchEntityInsideEmbeddableSelectFetchInitializer(" + LoggingHelper.toLoggableString(this.getNavigablePath()) + ")";
    }

    private static class ParentInfo {
        private final Object parentEntityInstance;
        private final Object parentInstance;
        private final int propertyIndex;
        private final int parentEntitySubclassId;

        public ParentInfo(Object parentEntityInstance, Object parentInstance, int propertyIndex, int parentEntitySubclassId) {
            this.parentEntityInstance = parentEntityInstance;
            this.parentInstance = parentInstance;
            this.propertyIndex = propertyIndex;
            this.parentEntitySubclassId = parentEntitySubclassId;
        }
    }

    public static class BatchEntityInsideEmbeddableSelectFetchInitializerData
    extends AbstractBatchEntitySelectFetchInitializer.AbstractBatchEntitySelectFetchInitializerData {
        private HashMap<EntityKey, List<ParentInfo>> toBatchLoad;

        public BatchEntityInsideEmbeddableSelectFetchInitializerData(BatchEntityInsideEmbeddableSelectFetchInitializer initializer, RowProcessingState rowProcessingState) {
            super(initializer, rowProcessingState);
        }
    }
}

