/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.clean;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsDefault;
import org.jetbrains.kotlin.js.backend.ast.JsEmpty;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsIf;
import org.jetbrains.kotlin.js.backend.ast.JsLabel;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsSwitch;
import org.jetbrains.kotlin.js.backend.ast.JsSwitchMember;
import org.jetbrains.kotlin.js.backend.ast.JsTry;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContextImpl;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\b\u001a\u00020\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/js/inline/clean/EmptyStatementElimination;", "", "root", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "<init>", "(Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;)V", "hasChanges", "", "apply", "js.translator"})
public final class EmptyStatementElimination {
    @NotNull
    private final JsStatement root;
    private boolean hasChanges;

    public EmptyStatementElimination(@NotNull JsStatement root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        this.root = root;
    }

    public final boolean apply() {
        new JsVisitorWithContextImpl(this){
            final /* synthetic */ EmptyStatementElimination this$0;
            {
                this.this$0 = $receiver;
            }

            public boolean visit(JsFunction x, JsContext<?> ctx) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
                return false;
            }

            public void endVisit(JsLabel x, JsContext<JsNode> ctx) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
                if (MetadataProperties.getSynthetic(x)) {
                    JsStatement jsStatement = x.getStatement();
                    Intrinsics.checkNotNullExpressionValue((Object)jsStatement, (String)"getStatement(...)");
                    if (this.isEmpty(jsStatement)) {
                        ctx.replaceMe((JsNode)x.getStatement());
                        EmptyStatementElimination.access$setHasChanges$p(this.this$0, true);
                    }
                }
            }

            public void endVisit(JsBlock x, JsContext<?> ctx) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
                List<JsStatement> list = x.getStatements();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getStatements(...)");
                this.processStatements(list);
            }

            public void endVisit(JsIf x, JsContext<JsNode> ctx) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
                JsStatement jsStatement = x.getThenStatement();
                Intrinsics.checkNotNullExpressionValue((Object)jsStatement, (String)"getThenStatement(...)");
                boolean thenEmpty = this.isEmpty(jsStatement);
                JsStatement jsStatement2 = x.getElseStatement();
                if (jsStatement2 != null) {
                    JsStatement it = jsStatement2;
                    boolean bl2 = false;
                    bl = this.isEmpty(it);
                } else {
                    bl = true;
                }
                boolean elseEmpty = bl;
                if (thenEmpty && elseEmpty) {
                    EmptyStatementElimination.access$setHasChanges$p(this.this$0, true);
                    ctx.replaceMe((JsNode)JsAstUtils.asSyntheticStatement(x.getIfExpression()));
                } else if (elseEmpty) {
                    if (x.getElseStatement() != null) {
                        EmptyStatementElimination.access$setHasChanges$p(this.this$0, true);
                        x.setElseStatement(null);
                    }
                } else if (thenEmpty) {
                    EmptyStatementElimination.access$setHasChanges$p(this.this$0, true);
                    JsStatement jsStatement3 = x.getElseStatement();
                    Intrinsics.checkNotNull((Object)jsStatement3);
                    x.setThenStatement(jsStatement3);
                    x.setElseStatement(null);
                    x.setIfExpression(JsAstUtils.notOptimized(x.getIfExpression()));
                }
            }

            public void endVisit(JsTry x, JsContext<JsNode> ctx) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
                JsBlock finallyBlock = x.getFinallyBlock();
                if (x.getTryBlock().isEmpty()) {
                    EmptyStatementElimination.access$setHasChanges$p(this.this$0, true);
                    JsBlock jsBlock = finallyBlock;
                    ctx.replaceMe(jsBlock != null ? (JsNode)jsBlock : (JsNode)JsEmpty.INSTANCE);
                }
            }

            public void endVisit(JsSwitch x, JsContext<JsNode> ctx) {
                block14: {
                    Object object;
                    block13: {
                        boolean bl;
                        block11: {
                            JsSwitchMember it;
                            T element$iv;
                            boolean $i$f$all;
                            Iterable $this$all$iv;
                            block12: {
                                boolean bl2;
                                block10: {
                                    Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                                    Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
                                    for (JsSwitchMember jsSwitchMember : x.getCases()) {
                                        List<JsStatement> list = jsSwitchMember.getStatements();
                                        Intrinsics.checkNotNullExpressionValue(list, (String)"getStatements(...)");
                                        this.processStatements(list);
                                    }
                                    List<JsSwitchMember> list = x.getCases();
                                    Intrinsics.checkNotNullExpressionValue(list, (String)"getCases(...)");
                                    if (!(CollectionsKt.lastOrNull(list) instanceof JsDefault)) break block12;
                                    List<JsSwitchMember> list2 = x.getCases();
                                    Intrinsics.checkNotNullExpressionValue(list2, (String)"getCases(...)");
                                    $this$all$iv = CollectionsKt.dropLast(list2, (int)1);
                                    $i$f$all = false;
                                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                                        bl2 = true;
                                    } else {
                                        object = $this$all$iv.iterator();
                                        while (object.hasNext()) {
                                            element$iv = object.next();
                                            it = (JsSwitchMember)element$iv;
                                            boolean bl3 = false;
                                            if (it.getStatements().isEmpty()) continue;
                                            bl2 = false;
                                            break block10;
                                        }
                                        bl2 = true;
                                    }
                                }
                                if (bl2) break block13;
                            }
                            List<JsSwitchMember> list = x.getCases();
                            Intrinsics.checkNotNullExpressionValue(list, (String)"getCases(...)");
                            $this$all$iv = list;
                            $i$f$all = false;
                            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                                bl = true;
                            } else {
                                object = $this$all$iv.iterator();
                                while (object.hasNext()) {
                                    element$iv = object.next();
                                    it = (JsSwitchMember)element$iv;
                                    boolean bl4 = false;
                                    if (it.getStatements().isEmpty()) continue;
                                    bl = false;
                                    break block11;
                                }
                                bl = true;
                            }
                        }
                        if (!bl) break block14;
                    }
                    EmptyStatementElimination.access$setHasChanges$p(this.this$0, true);
                    Object[] objectArray = new JsStatement[]{JsAstUtils.asSyntheticStatement(x.getExpression())};
                    List replacement = CollectionsKt.mutableListOf((Object[])objectArray);
                    List<JsSwitchMember> list = x.getCases();
                    Intrinsics.checkNotNullExpressionValue(list, (String)"getCases(...)");
                    JsSwitchMember jsSwitchMember = (JsSwitchMember)CollectionsKt.lastOrNull(list);
                    if (jsSwitchMember != null) {
                        Object $this$endVisit_u24lambda_u243 = object = jsSwitchMember;
                        boolean bl = false;
                        List<JsStatement> list3 = ((JsSwitchMember)$this$endVisit_u24lambda_u243).getStatements();
                        Intrinsics.checkNotNullExpressionValue(list3, (String)"getStatements(...)");
                        replacement.addAll((Collection)list3);
                    }
                    ctx.replaceMe((JsNode)new JsBlock(replacement));
                }
            }

            private final void processStatements(List<JsStatement> statements) {
                for (IndexedValue indexedValue : CollectionsKt.reversed((Iterable)CollectionsKt.withIndex((Iterable)statements))) {
                    int index = indexedValue.component1();
                    JsStatement statement = (JsStatement)indexedValue.component2();
                    if (statement instanceof JsEmpty) {
                        statements.remove(index);
                        EmptyStatementElimination.access$setHasChanges$p(this.this$0, true);
                        continue;
                    }
                    if (!(statement instanceof JsBlock)) continue;
                    statements.remove(index);
                    List<JsStatement> list = ((JsBlock)statement).getStatements();
                    Intrinsics.checkNotNullExpressionValue(list, (String)"getStatements(...)");
                    statements.addAll(index, (Collection<JsStatement>)list);
                }
            }

            private final boolean isEmpty(JsStatement statement) {
                return statement instanceof JsBlock && ((JsBlock)statement).isEmpty() || statement instanceof JsEmpty;
            }
        }.accept((JsNode)this.root);
        return this.hasChanges;
    }

    public static final /* synthetic */ void access$setHasChanges$p(EmptyStatementElimination $this, boolean bl) {
        $this.hasChanges = bl;
    }
}

