/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.nativeplatform.internal.incremental.sourceparser;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.gradle.language.nativeplatform.internal.Expression;
import org.gradle.language.nativeplatform.internal.IncludeType;
import org.gradle.language.nativeplatform.internal.incremental.sourceparser.AbstractInclude;

public class IncludeWithMacroFunctionCallExpression
extends AbstractInclude {
    private final String name;
    private final boolean isImport;
    private final ImmutableList<Expression> arguments;

    public IncludeWithMacroFunctionCallExpression(String name, boolean isImport, ImmutableList<Expression> arguments) {
        this.name = name;
        this.isImport = isImport;
        this.arguments = arguments;
    }

    public IncludeType getType() {
        return IncludeType.MACRO_FUNCTION;
    }

    public String getValue() {
        return this.name;
    }

    public boolean isImport() {
        return this.isImport;
    }

    @Override
    public List<Expression> getArguments() {
        return this.arguments;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        IncludeWithMacroFunctionCallExpression other = (IncludeWithMacroFunctionCallExpression)obj;
        return this.name.equals(other.name) && this.isImport == other.isImport && this.arguments.equals(other.arguments);
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.arguments.hashCode();
    }
}

