/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.flow.layoutprocessor;

import java.util.ArrayList;
import org.jfree.layouting.namespace.NamespaceDefinition;
import org.jfree.layouting.util.AttributeMap;
import org.jfree.report.DataFlags;
import org.jfree.report.DataSourceException;
import org.jfree.report.ReportProcessingException;
import org.jfree.report.flow.ReportStructureRoot;
import org.jfree.report.flow.ReportTarget;

public class BufferedReportTarget
implements ReportTarget,
Cloneable {
    private static final int MTH_START_REPORT = 1;
    private static final int MTH_START_ELEMENT = 2;
    private static final int MTH_PROCESS_TEXT = 3;
    private static final int MTH_PROCESS_CONTENT = 4;
    private static final int MTH_END_ELEMENT = 5;
    private static final int MTH_END_REPORT = 6;
    private ReportTarget target;
    private ArrayList calls = new ArrayList();

    public ReportTarget getTarget() {
        return this.target;
    }

    public void setTarget(ReportTarget reportTarget) {
        this.target = reportTarget;
    }

    @Override
    public void startReport(ReportStructureRoot reportStructureRoot) throws DataSourceException, ReportProcessingException {
        this.calls.add(new RecordedCall(1, reportStructureRoot));
    }

    @Override
    public void startElement(AttributeMap attributeMap) throws DataSourceException, ReportProcessingException {
        try {
            this.calls.add(new RecordedCall(2, attributeMap.clone()));
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new ReportProcessingException("Failed to clone attributes", cloneNotSupportedException);
        }
    }

    @Override
    public void processText(String string) throws DataSourceException, ReportProcessingException {
        this.calls.add(new RecordedCall(3, string));
    }

    @Override
    public void processContent(DataFlags dataFlags) throws DataSourceException, ReportProcessingException {
        this.calls.add(new RecordedCall(4, dataFlags));
    }

    @Override
    public void endElement(AttributeMap attributeMap) throws DataSourceException, ReportProcessingException {
        try {
            this.calls.add(new RecordedCall(5, attributeMap.clone()));
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new ReportProcessingException("Failed to clone attributes", cloneNotSupportedException);
        }
    }

    @Override
    public void endReport(ReportStructureRoot reportStructureRoot) throws DataSourceException, ReportProcessingException {
        this.calls.add(new RecordedCall(6, reportStructureRoot));
    }

    @Override
    public String getExportDescriptor() {
        return this.target.getExportDescriptor();
    }

    @Override
    public NamespaceDefinition getNamespaceByUri(String string) {
        return this.target.getNamespaceByUri(string);
    }

    @Override
    public void commit() throws ReportProcessingException {
    }

    public void close(ReportTarget reportTarget) throws ReportProcessingException, DataSourceException {
        RecordedCall[] recordedCallArray = this.calls.toArray(new RecordedCall[this.calls.size()]);
        block8: for (int i = 0; i < recordedCallArray.length; ++i) {
            RecordedCall recordedCall = recordedCallArray[i];
            switch (recordedCall.getMethod()) {
                case 1: {
                    reportTarget.startReport((ReportStructureRoot)recordedCall.getParameters());
                    continue block8;
                }
                case 2: {
                    reportTarget.startElement((AttributeMap)recordedCall.getParameters());
                    continue block8;
                }
                case 3: {
                    reportTarget.processText((String)recordedCall.getParameters());
                    continue block8;
                }
                case 4: {
                    reportTarget.processContent((DataFlags)recordedCall.getParameters());
                    continue block8;
                }
                case 5: {
                    reportTarget.endElement((AttributeMap)recordedCall.getParameters());
                    continue block8;
                }
                case 6: {
                    reportTarget.endReport((ReportStructureRoot)recordedCall.getParameters());
                    continue block8;
                }
                default: {
                    throw new IllegalStateException("Invalid call recorded.");
                }
            }
        }
    }

    public Object clone() {
        try {
            BufferedReportTarget bufferedReportTarget = (BufferedReportTarget)super.clone();
            bufferedReportTarget.calls = (ArrayList)this.calls.clone();
            return bufferedReportTarget;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException("Clone failed");
        }
    }

    public static class RecordedCall {
        private int methodId;
        private Object parameters;

        public RecordedCall(int n, Object object) {
            this.methodId = n;
            this.parameters = object;
        }

        public int getMethod() {
            return this.methodId;
        }

        public Object getParameters() {
            return this.parameters;
        }
    }
}

