/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer;

import java.util.logging.Logger;
import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.State;
import org.jfree.layouting.StateException;
import org.jfree.layouting.StatefullComponent;
import org.jfree.layouting.layouter.content.ContentToken;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.layouter.context.PageContext;
import org.jfree.layouting.normalizer.content.NormalizationException;
import org.jfree.layouting.renderer.Renderer;

public class PrintingRenderer
implements Renderer {
    private static final Logger logger = Logger.getLogger(PrintingRenderer.class.getName());
    private Renderer parent;

    public PrintingRenderer(Renderer renderer) {
        this.parent = renderer;
    }

    @Override
    public void startedDocument(PageContext pageContext) {
        logger.config("<document>");
        this.parent.startedDocument(pageContext);
    }

    @Override
    public void startedFlow(LayoutContext layoutContext) throws NormalizationException {
        logger.config("<flow tag='" + layoutContext.getTagName() + "' namespace='" + layoutContext.getNamespace() + "'>");
        this.parent.startedFlow(layoutContext);
    }

    @Override
    public void startedTable(LayoutContext layoutContext) throws NormalizationException {
        logger.config("<table tag='" + layoutContext.getTagName() + "' namespace='" + layoutContext.getNamespace() + "'>");
        this.parent.startedTable(layoutContext);
    }

    @Override
    public void startedTableSection(LayoutContext layoutContext) throws NormalizationException {
        logger.config("<table-section tag='" + layoutContext.getTagName() + "' namespace='" + layoutContext.getNamespace() + "'>");
        this.parent.startedTableSection(layoutContext);
    }

    @Override
    public void startedTableRow(LayoutContext layoutContext) throws NormalizationException {
        logger.config("<table-row tag='" + layoutContext.getTagName() + "' namespace='" + layoutContext.getNamespace() + "'>");
        this.parent.startedTableRow(layoutContext);
    }

    @Override
    public void startedTableCell(LayoutContext layoutContext) throws NormalizationException {
        logger.config("<table-cell tag='" + layoutContext.getTagName() + "' namespace='" + layoutContext.getNamespace() + "'>");
        this.parent.startedTableCell(layoutContext);
    }

    @Override
    public void startedBlock(LayoutContext layoutContext) throws NormalizationException {
        logger.config("<block tag='" + layoutContext.getTagName() + "' namespace='" + layoutContext.getNamespace() + "'>");
        this.parent.startedBlock(layoutContext);
    }

    @Override
    public void startedMarker(LayoutContext layoutContext) throws NormalizationException {
        logger.config("<marker tag='" + layoutContext.getTagName() + "' namespace='" + layoutContext.getNamespace() + "'>");
        this.parent.startedMarker(layoutContext);
    }

    @Override
    public void startedRootInline(LayoutContext layoutContext) throws NormalizationException {
        logger.config("<paragraph tag='" + layoutContext.getTagName() + "' namespace='" + layoutContext.getNamespace() + "'>");
        this.parent.startedRootInline(layoutContext);
    }

    @Override
    public void startedInline(LayoutContext layoutContext) throws NormalizationException {
        logger.config("<inline tag='" + layoutContext.getTagName() + "' namespace='" + layoutContext.getNamespace() + "'>");
        this.parent.startedInline(layoutContext);
    }

    @Override
    public void addContent(LayoutContext layoutContext, ContentToken contentToken) throws NormalizationException {
        logger.config("<content>" + contentToken + "</content>");
        this.parent.addContent(layoutContext, contentToken);
    }

    @Override
    public void finishedInline() throws NormalizationException {
        logger.config("</inline>");
        this.parent.finishedInline();
    }

    @Override
    public void finishedRootInline() throws NormalizationException {
        logger.config("</paragraph>");
        this.parent.finishedRootInline();
    }

    @Override
    public void finishedMarker() throws NormalizationException {
        logger.config("</marker>");
        this.parent.finishedMarker();
    }

    @Override
    public void finishedBlock() throws NormalizationException {
        logger.config("</block>");
        this.parent.finishedBlock();
    }

    @Override
    public void finishedTableCell() throws NormalizationException {
        logger.config("</table-cell>");
        this.parent.finishedTableCell();
    }

    @Override
    public void finishedTableRow() throws NormalizationException {
        logger.config("</table-row>");
        this.parent.finishedTableRow();
    }

    @Override
    public void finishedTableSection() throws NormalizationException {
        logger.config("</table-section>");
        this.parent.finishedTableSection();
    }

    @Override
    public void finishedTable() throws NormalizationException {
        logger.config("</table>");
        this.parent.finishedTable();
    }

    @Override
    public void finishedFlow() throws NormalizationException {
        logger.config("</flow>");
        this.parent.finishedFlow();
    }

    @Override
    public void finishedDocument() throws NormalizationException {
        logger.config("</document>");
        this.parent.finishedDocument();
    }

    @Override
    public void startedTableColumnGroup(LayoutContext layoutContext) throws NormalizationException {
        logger.config("<table-column-group>");
        this.parent.startedTableColumnGroup(layoutContext);
    }

    @Override
    public void startedTableColumn(LayoutContext layoutContext) throws NormalizationException {
        logger.config("<table-column>");
        this.parent.startedTableColumn(layoutContext);
    }

    @Override
    public void finishedTableColumnGroup() throws NormalizationException {
        logger.config("</table-column-group>");
        this.parent.finishedTableColumnGroup();
    }

    @Override
    public void finishedTableColumn() throws NormalizationException {
        logger.config("</table-column>");
        this.parent.finishedTableColumn();
    }

    @Override
    public void handlePageBreak(PageContext pageContext) {
        logger.config("<!-- PAGEBREAK ENCOUNTERED -->");
        this.parent.handlePageBreak(pageContext);
    }

    @Override
    public void startedPassThrough(LayoutContext layoutContext) throws NormalizationException {
        logger.config("<pass-through>");
        this.parent.startedPassThrough(layoutContext);
    }

    @Override
    public void addPassThroughContent(LayoutContext layoutContext, ContentToken contentToken) throws NormalizationException {
        logger.config("<pass-through-content>" + contentToken + "</pass-through-content>");
        this.parent.addPassThroughContent(layoutContext, contentToken);
    }

    @Override
    public void finishedPassThrough() throws NormalizationException {
        logger.config("</pass-through>");
        this.parent.finishedPassThrough();
    }

    @Override
    public State saveState() throws StateException {
        return new PrintingRendererState(this.parent);
    }

    @Override
    public void startedTableCaption(LayoutContext layoutContext) throws NormalizationException {
        logger.config("<table-caption>");
        this.parent.startedTableCaption(layoutContext);
    }

    @Override
    public void finishedTableCaption() throws NormalizationException {
        logger.config("</table-caption>");
        this.parent.finishedTableCaption();
    }

    private static class PrintingRendererState
    implements State {
        private State parentState;

        private PrintingRendererState(Renderer renderer) throws StateException {
            this.parentState = renderer.saveState();
        }

        @Override
        public StatefullComponent restore(LayoutProcess layoutProcess) throws StateException {
            return new PrintingRenderer((Renderer)this.parentState.restore(layoutProcess));
        }
    }
}

