/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.serialization.signature;

import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.serialization.DeclarationTable;
import org.jetbrains.kotlin.backend.common.serialization.signature.IdSignatureComputer;
import org.jetbrains.kotlin.backend.common.serialization.signature.PublicIdSignatureComputer;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.symbols.IrFileSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.ir.util.KotlinMangler;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\nJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0016\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013J+\u0010\u0017\u001a\u0002H\u0018\"\u0004\b\u0000\u0010\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u00180\u001cH\u0016\u00a2\u0006\u0002\u0010\u001dJ\u0018\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0016\u0010!\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013J\f\u0010\"\u001a\u00020\u0013*\u00020#H\u0002J\f\u0010$\u001a\u00020\u0013*\u00020%H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010&\u001a\u00020\u0013*\u0004\u0018\u00010#8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/signature/IdSignatureFactory;", "Lorg/jetbrains/kotlin/backend/common/serialization/signature/IdSignatureComputer;", "publicSignatureBuilder", "Lorg/jetbrains/kotlin/backend/common/serialization/signature/PublicIdSignatureComputer;", "table", "Lorg/jetbrains/kotlin/backend/common/serialization/DeclarationTable;", "startIndex", "", "<init>", "(Lorg/jetbrains/kotlin/backend/common/serialization/signature/PublicIdSignatureComputer;Lorg/jetbrains/kotlin/backend/common/serialization/DeclarationTable;I)V", "(Lorg/jetbrains/kotlin/backend/common/serialization/signature/PublicIdSignatureComputer;Lorg/jetbrains/kotlin/backend/common/serialization/DeclarationTable;)V", "mangler", "Lorg/jetbrains/kotlin/ir/util/KotlinMangler$IrMangler;", "computeSignature", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "composeSignatureForDeclaration", "compatibleMode", "", "localIndex", "", "scopeIndex", "inFile", "R", "file", "Lorg/jetbrains/kotlin/ir/symbols/IrFileSymbol;", "block", "Lkotlin/Function0;", "(Lorg/jetbrains/kotlin/ir/symbols/IrFileSymbol;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "composeContainerIdSignature", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;", "composeFileLocalIdSignature", "isOverridableFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "isOverridableProperty", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "hasDispatchReceiver", "getHasDispatchReceiver", "(Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;)Z", "ir.serialization.common"})
@SourceDebugExtension(value={"SMAP\nIdSignatureFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdSignatureFactory.kt\norg/jetbrains/kotlin/backend/common/serialization/signature/IdSignatureFactory\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,285:1\n1#2:286\n*E\n"})
public final class IdSignatureFactory
implements IdSignatureComputer {
    @NotNull
    private final PublicIdSignatureComputer publicSignatureBuilder;
    @NotNull
    private final DeclarationTable table;
    @NotNull
    private final KotlinMangler.IrMangler mangler;
    private long localIndex;
    private int scopeIndex;

    public IdSignatureFactory(@NotNull PublicIdSignatureComputer publicSignatureBuilder, @NotNull DeclarationTable table, int startIndex) {
        Intrinsics.checkNotNullParameter((Object)publicSignatureBuilder, (String)"publicSignatureBuilder");
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        this.publicSignatureBuilder = publicSignatureBuilder;
        this.table = table;
        this.mangler = this.publicSignatureBuilder.getMangler();
        this.localIndex = startIndex;
        this.scopeIndex = startIndex;
    }

    public IdSignatureFactory(@NotNull PublicIdSignatureComputer publicSignatureBuilder, @NotNull DeclarationTable table) {
        Intrinsics.checkNotNullParameter((Object)publicSignatureBuilder, (String)"publicSignatureBuilder");
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        this(publicSignatureBuilder, table, 0);
    }

    @Override
    @NotNull
    public IdSignature computeSignature(@NotNull IrDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        return this.publicSignatureBuilder.computeSignature(declaration);
    }

    @NotNull
    public final IdSignature composeSignatureForDeclaration(@NotNull IrDeclaration declaration, boolean compatibleMode) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        KotlinMangler.IrMangler $this$composeSignatureForDeclaration_u24lambda_u240 = this.mangler;
        boolean bl = false;
        return $this$composeSignatureForDeclaration_u24lambda_u240.isExported(declaration, compatibleMode) ? this.publicSignatureBuilder.composePublicIdSignature(declaration, compatibleMode) : this.composeFileLocalIdSignature(declaration, compatibleMode);
    }

    @Override
    public <R> R inFile(@Nullable IrFileSymbol file2, @NotNull Function0<? extends R> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        return this.publicSignatureBuilder.inFile(file2, block);
    }

    private final IdSignature composeContainerIdSignature(IrDeclarationParent container, boolean compatibleMode) {
        IdSignature idSignature;
        IrDeclarationParent irDeclarationParent = container;
        if (irDeclarationParent instanceof IrPackageFragment) {
            String string2 = ((IrPackageFragment)container).getPackageFqName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
            idSignature = new IdSignature.CommonSignature(string2, "", null, 0L, null);
        } else if (irDeclarationParent instanceof IrDeclaration) {
            idSignature = this.table.signatureByDeclaration((IrDeclaration)((Object)container), compatibleMode, false);
        } else {
            throw new IllegalStateException(("Unexpected container " + RenderIrElementKt.render$default(container, null, 1, null)).toString());
        }
        return idSignature;
    }

    @NotNull
    public final IdSignature composeFileLocalIdSignature(@NotNull IrDeclaration declaration, boolean compatibleMode) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        KotlinMangler.IrMangler $this$composeFileLocalIdSignature_u24lambda_u241 = this.mangler;
        boolean bl2 = false;
        boolean bl3 = bl = !$this$composeFileLocalIdSignature_u24lambda_u241.isExported(declaration, compatibleMode);
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        return this.table.privateDeclarationSignature(declaration, compatibleMode, (Function0<? extends IdSignature>)((Function0)() -> IdSignatureFactory.composeFileLocalIdSignature$lambda$6(declaration, this, compatibleMode)));
    }

    private final boolean isOverridableFunction(IrSimpleFunction $this$isOverridableFunction) {
        return !DescriptorVisibilities.isPrivate($this$isOverridableFunction.getVisibility()) && this.getHasDispatchReceiver($this$isOverridableFunction);
    }

    private final boolean isOverridableProperty(IrProperty $this$isOverridableProperty) {
        return !DescriptorVisibilities.isPrivate($this$isOverridableProperty.getVisibility()) && (this.getHasDispatchReceiver($this$isOverridableProperty.getGetter()) || this.getHasDispatchReceiver($this$isOverridableProperty.getSetter()));
    }

    private final boolean getHasDispatchReceiver(IrSimpleFunction $this$hasDispatchReceiver) {
        IrSimpleFunction irSimpleFunction = $this$hasDispatchReceiver;
        return (irSimpleFunction != null ? irSimpleFunction.getDispatchReceiverParameter() : null) != null;
    }

    /*
     * WARNING - void declaration
     */
    private static final IdSignature composeFileLocalIdSignature$lambda$6(IrDeclaration $declaration, IdSignatureFactory this$0, boolean $compatibleMode) {
        IdSignature idSignature;
        block13: {
            IrDeclaration irDeclaration2;
            block19: {
                long l;
                Object p;
                Object object;
                block21: {
                    IrDeclarationParent parent2;
                    block20: {
                        block16: {
                            Object object2;
                            block18: {
                                block17: {
                                    block15: {
                                        block14: {
                                            block12: {
                                                irDeclaration2 = $declaration;
                                                if (!(irDeclaration2 instanceof IrValueDeclaration)) break block12;
                                                int n = this$0.scopeIndex;
                                                this$0.scopeIndex = n + 1;
                                                idSignature = new IdSignature.ScopeLocalDeclaration(n, ((IrValueDeclaration)$declaration).getName().asString());
                                                break block13;
                                            }
                                            if (!(irDeclaration2 instanceof IrAnonymousInitializer)) break block14;
                                            int n = this$0.scopeIndex;
                                            this$0.scopeIndex = n + 1;
                                            idSignature = new IdSignature.ScopeLocalDeclaration(n, "ANON INIT");
                                            break block13;
                                        }
                                        if (!(irDeclaration2 instanceof IrLocalDelegatedProperty)) break block15;
                                        int n = this$0.scopeIndex;
                                        this$0.scopeIndex = n + 1;
                                        idSignature = new IdSignature.ScopeLocalDeclaration(n, ((IrLocalDelegatedProperty)$declaration).getName().asString());
                                        break block13;
                                    }
                                    if (!(irDeclaration2 instanceof IrField)) break block16;
                                    object2 = ((IrField)$declaration).getCorrespondingPropertySymbol();
                                    if (object2 == null) break block17;
                                    IrPropertySymbol it = object2;
                                    boolean bl = false;
                                    IdSignature idSignature2 = this$0.composeSignatureForDeclaration((IrDeclaration)it.getOwner(), $compatibleMode);
                                    object2 = idSignature2;
                                    if (idSignature2 != null) break block18;
                                }
                                object2 = this$0.composeContainerIdSignature(((IrField)$declaration).getParent(), $compatibleMode);
                            }
                            Object p2 = object2;
                            ++this$0.localIndex;
                            idSignature = new IdSignature.FileLocalSignature((IdSignature)p2, this$0.localIndex, null, 4, null);
                            break block13;
                        }
                        if (!(irDeclaration2 instanceof IrSimpleFunction)) break block19;
                        parent2 = ((IrSimpleFunction)$declaration).getParent();
                        object = ((IrSimpleFunction)$declaration).getCorrespondingPropertySymbol();
                        if (object == null) break block20;
                        IrPropertySymbol it = object;
                        boolean bl = false;
                        IdSignature idSignature3 = this$0.composeSignatureForDeclaration((IrDeclaration)it.getOwner(), $compatibleMode);
                        object = idSignature3;
                        if (idSignature3 != null) break block21;
                    }
                    object = this$0.composeContainerIdSignature(parent2, $compatibleMode);
                }
                Object object3 = p = object;
                if (this$0.isOverridableFunction((IrSimpleFunction)$declaration)) {
                    void $this$composeFileLocalIdSignature_u24lambda_u246_u24lambda_u244;
                    KotlinMangler.IrMangler irMangler = this$0.mangler;
                    Object object4 = object3;
                    boolean bl = false;
                    long l2 = $this$composeFileLocalIdSignature_u24lambda_u246_u24lambda_u244.signatureMangle($declaration, $compatibleMode);
                    object3 = object4;
                    l = l2;
                } else {
                    l = ++this$0.localIndex;
                }
                String string2 = RenderIrElementKt.render$default($declaration, null, 1, null);
                long l3 = l;
                Object object5 = object3;
                idSignature = new IdSignature.FileLocalSignature((IdSignature)object5, l3, string2);
                break block13;
            }
            if (irDeclaration2 instanceof IrProperty) {
                long l;
                IrDeclarationParent parent3 = ((IrProperty)$declaration).getParent();
                IdSignature idSignature4 = this$0.composeContainerIdSignature(parent3, $compatibleMode);
                if (this$0.isOverridableProperty((IrProperty)$declaration)) {
                    void $this$composeFileLocalIdSignature_u24lambda_u246_u24lambda_u245;
                    KotlinMangler.IrMangler irMangler = this$0.mangler;
                    IdSignature idSignature5 = idSignature4;
                    boolean bl = false;
                    long l4 = $this$composeFileLocalIdSignature_u24lambda_u246_u24lambda_u245.signatureMangle($declaration, $compatibleMode);
                    idSignature4 = idSignature5;
                    l = l4;
                } else {
                    l = ++this$0.localIndex;
                }
                String string3 = RenderIrElementKt.render$default($declaration, null, 1, null);
                long l5 = l;
                IdSignature idSignature6 = idSignature4;
                idSignature = new IdSignature.FileLocalSignature(idSignature6, l5, string3);
            } else {
                ++this$0.localIndex;
                idSignature = new IdSignature.FileLocalSignature(this$0.composeContainerIdSignature($declaration.getParent(), $compatibleMode), this$0.localIndex, RenderIrElementKt.render$default($declaration, null, 1, null));
            }
        }
        return idSignature;
    }
}

