/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.internal.commands;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.internal.commands.AutomationCommand;
import org.openhab.core.automation.internal.commands.AutomationCommandsPluggable;

@NonNullByDefault
public class AutomationCommandRemove
extends AutomationCommand {
    private @Nullable String id;
    private @Nullable URL url;

    public AutomationCommandRemove(String command, String[] params, int providerType, AutomationCommandsPluggable autoCommands) {
        super(command, params, providerType, autoCommands);
    }

    @Override
    public String execute() {
        String id = this.id;
        URL url = this.url;
        if (!"SUCCESS".equals(this.parsingResult) || id == null || url == null) {
            return this.parsingResult;
        }
        switch (this.providerType) {
            case 3: {
                return this.autoCommands.remove(3, url);
            }
            case 2: {
                return this.autoCommands.remove(2, url);
            }
            case 1: {
                if ("removeRule".equals(this.command)) {
                    return this.autoCommands.removeRule(id);
                }
                if (!"removeRules".equals(this.command)) break;
                return this.autoCommands.removeRules(id);
            }
        }
        return "FAIL";
    }

    private @Nullable URL initURL(String parameterValue) {
        try {
            return new URL(parameterValue);
        }
        catch (MalformedURLException mue) {
            File f = new File(parameterValue);
            if (f.isFile()) {
                try {
                    return f.toURI().toURL();
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    @Override
    protected String parseOptionsAndParameters(String[] parameterValues) {
        boolean getUrl = true;
        boolean getId = true;
        if (this.providerType == 1) {
            getUrl = false;
        } else {
            getId = false;
        }
        String[] stringArray = parameterValues;
        int n = parameterValues.length;
        int n2 = 0;
        while (n2 < n) {
            String parameterValue = stringArray[n2];
            if (parameterValue != null) {
                if ("-st".equals(parameterValue)) {
                    this.st = true;
                } else {
                    if (parameterValue.charAt(0) == '-') {
                        return String.format("Unsupported option: %s", parameterValue);
                    }
                    if (getUrl) {
                        this.url = this.initURL(parameterValue);
                        if (this.url != null) {
                            getUrl = false;
                        }
                    } else if (getId) {
                        this.id = parameterValue;
                        if (this.id != null) {
                            getId = false;
                        }
                    } else {
                        return String.format("Unsupported parameter: %s", parameterValue);
                    }
                }
            }
            ++n2;
        }
        if (getUrl) {
            return "Missing source URL parameter!";
        }
        if (getId) {
            return "Missing UID parameter!";
        }
        return "SUCCESS";
    }
}

