/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.management;

import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.vertx.http.runtime.management.ManagementConfig;
import io.quarkus.vertx.http.runtime.security.AbstractPathMatchingHttpSecurityPolicy;
import io.quarkus.vertx.http.runtime.security.BasicAuthenticationMechanism;
import io.quarkus.vertx.http.runtime.security.HttpSecurityRecorder;
import io.quarkus.vertx.http.runtime.security.ManagementInterfaceHttpAuthorizer;
import io.quarkus.vertx.http.runtime.security.ManagementPathMatchingHttpSecurityPolicy;
import io.quarkus.vertx.http.runtime.security.RolesMapping;
import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import jakarta.enterprise.inject.spi.CDI;
import java.lang.annotation.Annotation;
import java.util.function.Supplier;

@Recorder
public class ManagementSecurityRecorder {
    public RuntimeValue<HttpSecurityRecorder.AuthenticationHandler> managementAuthenticationHandler(boolean proactiveAuthentication) {
        return new RuntimeValue((Object)new HttpSecurityRecorder.AuthenticationHandler(proactiveAuthentication));
    }

    public Handler<RoutingContext> getAuthenticationHandler(RuntimeValue<HttpSecurityRecorder.AuthenticationHandler> handlerRuntimeValue) {
        return (Handler)handlerRuntimeValue.getValue();
    }

    public void initializeAuthenticationHandler(RuntimeValue<HttpSecurityRecorder.AuthenticationHandler> handler, ManagementConfig managementConfig, BeanContainer beanContainer) {
        ((HttpSecurityRecorder.AuthenticationHandler)handler.getValue()).init((AbstractPathMatchingHttpSecurityPolicy)beanContainer.beanInstance(ManagementPathMatchingHttpSecurityPolicy.class, new Annotation[0]), RolesMapping.of(managementConfig.auth().rolesMapping()));
    }

    public Handler<RoutingContext> permissionCheckHandler() {
        return new Handler<RoutingContext>(){
            private volatile ManagementInterfaceHttpAuthorizer authorizer;

            public void handle(RoutingContext event) {
                if (this.authorizer == null) {
                    this.authorizer = (ManagementInterfaceHttpAuthorizer)CDI.current().select(ManagementInterfaceHttpAuthorizer.class, new Annotation[0]).get();
                }
                this.authorizer.checkPermission(event);
            }
        };
    }

    public Supplier<?> setupBasicAuth() {
        return new Supplier<BasicAuthenticationMechanism>(){

            @Override
            public BasicAuthenticationMechanism get() {
                return new BasicAuthenticationMechanism(null, false);
            }
        };
    }
}

