/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.cluster.infinispan;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.event.CacheEntryCreatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryRemovedEvent;
import org.jboss.logging.Logger;
import org.keycloak.cluster.ClusterEvent;
import org.keycloak.cluster.ClusterListener;
import org.keycloak.cluster.ClusterProvider;
import org.keycloak.cluster.ExecutionResult;
import org.keycloak.cluster.infinispan.LockEntry;
import org.keycloak.cluster.infinispan.TaskCallback;
import org.keycloak.cluster.infinispan.WrapperClusterEvent;
import org.keycloak.common.util.ConcurrentMultivaluedHashMap;
import org.keycloak.common.util.Retry;
import org.keycloak.common.util.SecretGenerator;
import org.keycloak.common.util.Time;
import org.keycloak.connections.infinispan.TopologyInfo;
import org.keycloak.models.sessions.infinispan.CacheDecorators;

public class InfinispanClusterProvider
implements ClusterProvider {
    protected static final Logger logger = Logger.getLogger(InfinispanClusterProvider.class);
    public static final String CLUSTER_STARTUP_TIME_KEY = "cluster-start-time";
    public static final String TASK_KEY_PREFIX = "task::";
    private final int clusterStartupTime;
    private final String myAddress;
    private final String mySite;
    private final Cache<String, Object> workCache;
    private final ConcurrentMultivaluedHashMap<String, ClusterListener> listeners = new ConcurrentMultivaluedHashMap();
    private final ConcurrentMap<String, TaskCallback> taskCallbacks = new ConcurrentHashMap<String, TaskCallback>();
    private final ExecutorService localExecutor;

    public InfinispanClusterProvider(int clusterStartupTime, TopologyInfo topologyInfo, Cache<String, Object> workCache, ExecutorService localExecutor) {
        this.myAddress = topologyInfo.getMyNodeName();
        this.mySite = topologyInfo.getMySiteName();
        this.clusterStartupTime = clusterStartupTime;
        this.workCache = workCache;
        this.localExecutor = localExecutor;
    }

    public int getClusterStartupTime() {
        return this.clusterStartupTime;
    }

    public void close() {
    }

    public <T> ExecutionResult<T> executeIfNotExecuted(String taskKey, int taskTimeoutInSeconds, Callable<T> task) {
        String cacheKey = TASK_KEY_PREFIX + taskKey;
        boolean locked = this.tryLock(cacheKey, taskTimeoutInSeconds);
        if (locked) {
            try {
                T result = task.call();
                ExecutionResult executionResult = ExecutionResult.executed(result);
                return executionResult;
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new RuntimeException("Unexpected exception when executed task " + taskKey, e);
            }
            finally {
                this.removeFromCache(cacheKey);
            }
        }
        return ExecutionResult.notExecuted();
    }

    public Future<Boolean> executeIfNotExecutedAsync(String taskKey, int taskTimeoutInSeconds, Callable task) {
        TaskCallback newCallback = new TaskCallback();
        TaskCallback callback = this.registerTaskCallback(TASK_KEY_PREFIX + taskKey, newCallback);
        if (newCallback == callback) {
            Callable<Boolean> wrappedTask = () -> {
                boolean executed = this.executeIfNotExecuted(taskKey, taskTimeoutInSeconds, task).isExecuted();
                if (!executed) {
                    logger.infof("Task already in progress on other cluster node. Will wait until it's finished", new Object[0]);
                }
                callback.getTaskCompletedLatch().await(taskTimeoutInSeconds, TimeUnit.SECONDS);
                return callback.isSuccess();
            };
            Future<Boolean> future = this.localExecutor.submit(wrappedTask);
            callback.setFuture(future);
        } else {
            logger.infof("Task already in progress on this cluster node. Will wait until it's finished", new Object[0]);
        }
        return callback.getFuture();
    }

    TaskCallback registerTaskCallback(String taskKey, TaskCallback callback) {
        TaskCallback existing = this.taskCallbacks.putIfAbsent(taskKey, callback);
        return existing == null ? callback : existing;
    }

    private boolean tryLock(String cacheKey, int taskTimeoutInSeconds) {
        LockEntry myLock = new LockEntry(this.myAddress);
        LockEntry existingLock = (LockEntry)this.workCache.putIfAbsent((Object)cacheKey, (Object)myLock, Time.toMillis((long)taskTimeoutInSeconds), TimeUnit.MILLISECONDS);
        if (existingLock != null) {
            if (logger.isTraceEnabled()) {
                logger.tracef("Task %s in progress already by node %s. Ignoring task.", (Object)cacheKey, (Object)existingLock.node());
            }
            return false;
        }
        if (logger.isTraceEnabled()) {
            logger.tracef("Successfully acquired lock for task %s. Our node is %s", (Object)cacheKey, (Object)myLock.node());
        }
        return true;
    }

    private void removeFromCache(String cacheKey) {
        Retry.executeWithBackoff(iteration -> {
            CacheDecorators.ignoreReturnValues(this.workCache).remove((Object)cacheKey);
            if (logger.isTraceEnabled()) {
                logger.tracef("Task %s removed from the cache", (Object)cacheKey);
            }
        }, (int)10, (int)10);
    }

    public void registerListener(String taskKey, ClusterListener task) {
        this.listeners.add((Object)taskKey, (Object)task);
    }

    public void notify(String taskKey, ClusterEvent event, boolean ignoreSender, ClusterProvider.DCNotify dcNotify) {
        this.notify(taskKey, Collections.singleton(event), ignoreSender, dcNotify);
    }

    public void notify(String taskKey, Collection<? extends ClusterEvent> events, boolean ignoreSender) {
        this.notify(taskKey, events, ignoreSender, ClusterProvider.DCNotify.ALL_DCS);
    }

    public void notify(String taskKey, Collection<? extends ClusterEvent> events, boolean ignoreSender, ClusterProvider.DCNotify dcNotify) {
        if (events == null || events.isEmpty()) {
            return;
        }
        WrapperClusterEvent wrappedEvent = WrapperClusterEvent.wrap(taskKey, events, this.myAddress, this.mySite, dcNotify, ignoreSender);
        String eventKey = SecretGenerator.getInstance().generateSecureID();
        if (logger.isTraceEnabled()) {
            logger.tracef("Sending event with key %s: %s", (Object)eventKey, events);
        }
        CacheDecorators.ignoreReturnValues(this.workCache).put((Object)eventKey, (Object)wrappedEvent, 120L, TimeUnit.SECONDS);
    }

    private void eventReceived(String key, Object obj) {
        List myListeners;
        if (!(obj instanceof WrapperClusterEvent)) {
            if (obj == null && !key.startsWith(TASK_KEY_PREFIX)) {
                logger.warnf("Event object wasn't available in remote cache after event was received. Event key: %s", (Object)key);
            }
            return;
        }
        WrapperClusterEvent event = (WrapperClusterEvent)obj;
        if (event.rejectEvent(this.myAddress, this.mySite)) {
            return;
        }
        String eventKey = event.getEventKey();
        if (logger.isTraceEnabled()) {
            logger.tracef("Received event: %s", (Object)event);
        }
        if ((myListeners = (List)this.listeners.get((Object)eventKey)) != null) {
            for (ClusterEvent clusterEvent : event.getDelegateEvents()) {
                myListeners.forEach(clusterEvent);
            }
        }
    }

    void taskFinished(String taskKey) {
        TaskCallback callback = (TaskCallback)this.taskCallbacks.remove(taskKey);
        if (callback != null) {
            if (logger.isDebugEnabled()) {
                logger.debugf("Finished task '%s' with '%b'", (Object)taskKey, (Object)true);
            }
            callback.setSuccess(true);
            callback.getTaskCompletedLatch().countDown();
        }
    }

    @Listener(observation=Listener.Observation.POST)
    public class CacheEntryListener {
        @CacheEntryCreated
        public void cacheEntryCreated(CacheEntryCreatedEvent<String, Object> event) {
            InfinispanClusterProvider.this.eventReceived((String)event.getKey(), event.getValue());
        }

        @CacheEntryModified
        public void cacheEntryModified(CacheEntryModifiedEvent<String, Object> event) {
            InfinispanClusterProvider.this.eventReceived((String)event.getKey(), event.getNewValue());
        }

        @CacheEntryRemoved
        public void cacheEntryRemoved(CacheEntryRemovedEvent<String, Object> event) {
            InfinispanClusterProvider.this.taskFinished((String)event.getKey());
        }
    }
}

