/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream.impl.local;

import io.reactivex.rxjava3.core.Flowable;
import java.lang.invoke.MethodHandles;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.ToIntFunction;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.infinispan.AdvancedCache;
import org.infinispan.BaseCacheStream;
import org.infinispan.Cache;
import org.infinispan.CacheStream;
import org.infinispan.cache.impl.AbstractDelegatingCache;
import org.infinispan.commons.util.Closeables;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.IteratorMapper;
import org.infinispan.context.Flag;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.stream.impl.local.AbstractLocalCacheStream;
import org.infinispan.util.LazyConcatIterator;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.reactivestreams.Publisher;

public class PersistenceKeyStreamSupplier<K>
implements AbstractLocalCacheStream.StreamSupplier<K, Stream<K>> {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private final Cache<K, ?> cache;
    private final ToIntFunction<Object> toIntFunction;
    private final CacheStream<K> inMemoryStream;
    private final PersistenceManager persistenceManager;

    public PersistenceKeyStreamSupplier(Cache<K, ?> cache, ToIntFunction<Object> toIntFunction, CacheStream<K> inMemoryStream, PersistenceManager persistenceManager) {
        this.cache = cache;
        this.toIntFunction = toIntFunction;
        this.inMemoryStream = inMemoryStream;
        this.persistenceManager = persistenceManager;
    }

    @Override
    public Stream<K> buildStream(IntSet segmentsToFilter, Set<?> keysToFilter, boolean parallel) {
        Stream stream;
        if (keysToFilter != null) {
            if (log.isTraceEnabled()) {
                log.tracef("Applying key filtering %s", keysToFilter);
            }
            AdvancedCache<K, ?> advancedCache = AbstractDelegatingCache.unwrapCache(this.cache).getAdvancedCache().withFlags(Flag.CACHE_MODE_LOCAL);
            stream = (parallel ? keysToFilter.parallelStream() : keysToFilter.stream()).filter(arg_0 -> advancedCache.containsKey(arg_0));
            if (segmentsToFilter != null && this.toIntFunction != null) {
                if (log.isTraceEnabled()) {
                    log.tracef("Applying segment filter %s", segmentsToFilter);
                }
                stream = stream.filter(k -> {
                    int segment = this.toIntFunction.applyAsInt(k);
                    boolean isPresent = segmentsToFilter.contains(segment);
                    if (log.isTraceEnabled()) {
                        log.tracef("Is key %s present in segment %d? %b", k, segment, isPresent);
                    }
                    return isPresent;
                });
            }
        } else {
            Publisher<Object> publisher;
            BaseCacheStream inMemoryStream = this.inMemoryStream;
            HashSet seenKeys = new HashSet(2048);
            if (segmentsToFilter != null) {
                inMemoryStream = inMemoryStream.filterKeySegments(segmentsToFilter);
                publisher = this.persistenceManager.publishKeys(segmentsToFilter, k -> !seenKeys.contains(k), PersistenceManager.AccessMode.BOTH);
            } else {
                publisher = this.persistenceManager.publishKeys(k -> !seenKeys.contains(k), PersistenceManager.AccessMode.BOTH);
            }
            IteratorMapper localIterator = new IteratorMapper((Iterator)Closeables.iterator(inMemoryStream), k -> {
                seenKeys.add(k);
                return k;
            });
            Flowable flowable = Flowable.fromPublisher(publisher);
            LazyConcatIterator iterator = new LazyConcatIterator(localIterator, () -> org.infinispan.util.Closeables.iterator(flowable, 128));
            Iterable iterable = () -> iterator;
            stream = (Stream)StreamSupport.stream(iterable.spliterator(), parallel).onClose(() -> iterator.close());
        }
        return stream;
    }
}

