/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.qdox.model.annotation;

import com.thoughtworks.qdox.model.annotation.AnnotationValue;
import com.thoughtworks.qdox.model.annotation.AnnotationVisitor;

public class AnnotationQuery
implements AnnotationValue {
    private final AnnotationValue condition;
    private final AnnotationValue trueExpression;
    private final AnnotationValue falseExpression;

    public AnnotationQuery(AnnotationValue condition, AnnotationValue trueExpression, AnnotationValue falseExpression) {
        this.condition = condition;
        this.trueExpression = trueExpression;
        this.falseExpression = falseExpression;
    }

    public Object accept(AnnotationVisitor visitor) {
        return visitor.visitAnnotationQuery(this);
    }

    public AnnotationValue getCondition() {
        return this.condition;
    }

    public AnnotationValue getTrueExpression() {
        return this.trueExpression;
    }

    public AnnotationValue getFalseExpression() {
        return this.falseExpression;
    }

    public Object getParameterValue() {
        return this.condition.getParameterValue().toString() + " ? " + this.trueExpression.getParameterValue() + " : " + this.falseExpression.getParameterValue();
    }

    public String toString() {
        return this.condition.toString() + " ? " + this.trueExpression.toString() + " : " + this.falseExpression.toString();
    }
}

