/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.jms;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;
import org.apache.qpid.proton.amqp.messaging.DeliveryAnnotations;
import org.apache.qpid.proton.amqp.messaging.Footer;
import org.apache.qpid.proton.amqp.messaging.Header;
import org.apache.qpid.proton.amqp.messaging.MessageAnnotations;
import org.apache.qpid.proton.amqp.messaging.Properties;
import org.apache.qpid.proton.jms.EncodedMessage;
import org.apache.qpid.proton.jms.JMSVendor;
import org.apache.qpid.proton.message.Message;

public abstract class InboundTransformer {
    JMSVendor vendor;
    public static final String TRANSFORMER_NATIVE = "native";
    public static final String TRANSFORMER_RAW = "raw";
    public static final String TRANSFORMER_JMS = "jms";
    String prefixVendor = "JMS_AMQP_";
    String prefixDeliveryAnnotations = "DA_";
    String prefixMessageAnnotations = "MA_";
    String prefixFooter = "FT_";
    int defaultDeliveryMode = 2;
    int defaultPriority = 4;
    long defaultTtl = 0L;
    private static final Set<String> QUEUE_ATTRIBUTES = InboundTransformer.createSet("queue");
    private static final Set<String> TOPIC_ATTRIBUTES = InboundTransformer.createSet("topic");
    private static final Set<String> TEMP_QUEUE_ATTRIBUTES = InboundTransformer.createSet("queue", "temporary");
    private static final Set<String> TEMP_TOPIC_ATTRIBUTES = InboundTransformer.createSet("topic", "temporary");

    public InboundTransformer(JMSVendor vendor) {
        this.vendor = vendor;
    }

    public abstract javax.jms.Message transform(EncodedMessage var1) throws Exception;

    public int getDefaultDeliveryMode() {
        return this.defaultDeliveryMode;
    }

    public void setDefaultDeliveryMode(int defaultDeliveryMode) {
        this.defaultDeliveryMode = defaultDeliveryMode;
    }

    public int getDefaultPriority() {
        return this.defaultPriority;
    }

    public void setDefaultPriority(int defaultPriority) {
        this.defaultPriority = defaultPriority;
    }

    public long getDefaultTtl() {
        return this.defaultTtl;
    }

    public void setDefaultTtl(long defaultTtl) {
        this.defaultTtl = defaultTtl;
    }

    public String getPrefixVendor() {
        return this.prefixVendor;
    }

    public void setPrefixVendor(String prefixVendor) {
        this.prefixVendor = prefixVendor;
    }

    public JMSVendor getVendor() {
        return this.vendor;
    }

    public void setVendor(JMSVendor vendor) {
        this.vendor = vendor;
    }

    protected void populateMessage(javax.jms.Message jms, Message amqp) throws Exception {
        Footer fp;
        Properties properties;
        ApplicationProperties ap;
        DeliveryAnnotations da;
        Header header = amqp.getHeader();
        if (header == null) {
            header = new Header();
        }
        if (header.getDurable() != null) {
            jms.setJMSDeliveryMode(header.getDurable() != false ? 2 : 1);
        } else {
            jms.setJMSDeliveryMode(this.defaultDeliveryMode);
        }
        if (header.getPriority() != null) {
            jms.setJMSPriority(header.getPriority().intValue());
        } else {
            jms.setJMSPriority(this.defaultPriority);
        }
        if (header.getTtl() != null) {
            jms.setJMSExpiration(header.getTtl().longValue());
        } else {
            jms.setJMSExpiration(this.defaultTtl);
        }
        if (header.getFirstAcquirer() != null) {
            jms.setBooleanProperty(this.prefixVendor + "FirstAcquirer", header.getFirstAcquirer().booleanValue());
        }
        if (header.getDeliveryCount() != null) {
            this.vendor.setJMSXDeliveryCount(jms, header.getDeliveryCount().longValue());
        }
        if ((da = amqp.getDeliveryAnnotations()) != null) {
            for (Map.Entry entry : da.getValue().entrySet()) {
                String key = entry.getKey().toString();
                this.setProperty(jms, this.prefixVendor + this.prefixDeliveryAnnotations + key, entry.getValue());
            }
        }
        Class<Destination> toAttributes = Destination.class;
        Class<Destination> replyToAttributes = Destination.class;
        MessageAnnotations ma = amqp.getMessageAnnotations();
        if (ma != null) {
            for (Map.Entry entry : ma.getValue().entrySet()) {
                String key = entry.getKey().toString();
                if ("x-opt-jms-type".equals(key)) {
                    jms.setJMSType(entry.getValue().toString());
                    continue;
                }
                if ("x-opt-to-type".equals(key)) {
                    toAttributes = this.toClassFromAttributes(entry.getValue().toString());
                    continue;
                }
                if ("x-opt-reply-type".equals(key)) {
                    replyToAttributes = this.toClassFromAttributes(entry.getValue().toString());
                    continue;
                }
                this.setProperty(jms, this.prefixVendor + this.prefixMessageAnnotations + key, entry.getValue());
            }
        }
        if ((ap = amqp.getApplicationProperties()) != null) {
            for (Map.Entry entry : ap.getValue().entrySet()) {
                String key = entry.getKey().toString();
                if ("JMSXGroupID".equals(key)) {
                    this.vendor.setJMSXGroupID(jms, entry.getValue().toString());
                    continue;
                }
                if ("JMSXGroupSequence".equals(key)) {
                    this.vendor.setJMSXGroupSequence(jms, ((Number)entry.getValue()).intValue());
                    continue;
                }
                if ("JMSXUserID".equals(key)) {
                    this.vendor.setJMSXUserID(jms, entry.getValue().toString());
                    continue;
                }
                this.setProperty(jms, key, entry.getValue());
            }
        }
        if ((properties = amqp.getProperties()) != null) {
            Binary userId;
            if (properties.getMessageId() != null) {
                jms.setJMSMessageID(properties.getMessageId().toString());
            }
            if ((userId = properties.getUserId()) != null) {
                this.vendor.setJMSXUserID(jms, new String(userId.getArray(), userId.getArrayOffset(), userId.getLength(), "UTF-8"));
            }
            if (properties.getTo() != null) {
                jms.setJMSDestination(this.vendor.createDestination(properties.getTo(), toAttributes));
            }
            if (properties.getSubject() != null) {
                jms.setStringProperty(this.prefixVendor + "Subject", properties.getSubject());
            }
            if (properties.getReplyTo() != null) {
                jms.setJMSReplyTo(this.vendor.createDestination(properties.getReplyTo(), replyToAttributes));
            }
            if (properties.getCorrelationId() != null) {
                jms.setJMSCorrelationID(properties.getCorrelationId().toString());
            }
            if (properties.getContentType() != null) {
                jms.setStringProperty(this.prefixVendor + "ContentType", properties.getContentType().toString());
            }
            if (properties.getContentEncoding() != null) {
                jms.setStringProperty(this.prefixVendor + "ContentEncoding", properties.getContentEncoding().toString());
            }
            if (properties.getCreationTime() != null) {
                jms.setJMSTimestamp(properties.getCreationTime().getTime());
            }
            if (properties.getGroupId() != null) {
                this.vendor.setJMSXGroupID(jms, properties.getGroupId());
            }
            if (properties.getGroupSequence() != null) {
                this.vendor.setJMSXGroupSequence(jms, properties.getGroupSequence().intValue());
            }
            if (properties.getReplyToGroupId() != null) {
                jms.setStringProperty(this.prefixVendor + "ReplyToGroupID", properties.getReplyToGroupId());
            }
        }
        if ((fp = amqp.getFooter()) != null) {
            for (Map.Entry entry : fp.getValue().entrySet()) {
                String key = entry.getKey().toString();
                this.setProperty(jms, this.prefixVendor + this.prefixFooter + key, entry.getValue());
            }
        }
    }

    private static Set<String> createSet(String ... args) {
        HashSet<String> s = new HashSet<String>();
        for (String arg : args) {
            s.add(arg);
        }
        return Collections.unmodifiableSet(s);
    }

    Class<? extends Destination> toClassFromAttributes(String value) {
        if (value == null) {
            return null;
        }
        HashSet<String> attributes = new HashSet<String>();
        for (String x : value.split("\\s*,\\s*")) {
            attributes.add(x);
        }
        if (QUEUE_ATTRIBUTES.equals(attributes)) {
            return Queue.class;
        }
        if (TOPIC_ATTRIBUTES.equals(attributes)) {
            return Topic.class;
        }
        if (TEMP_QUEUE_ATTRIBUTES.equals(attributes)) {
            return TemporaryQueue.class;
        }
        if (TEMP_TOPIC_ATTRIBUTES.equals(attributes)) {
            return TemporaryTopic.class;
        }
        return Destination.class;
    }

    private void setProperty(javax.jms.Message msg, String key, Object value) throws JMSException {
        msg.setObjectProperty(key, value);
    }
}

