/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import org.apache.camel.Exchange;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.util.IOHelper;

public class ZipDataFormat
implements DataFormat {
    private final int compressionLevel;

    public ZipDataFormat() {
        this.compressionLevel = 1;
    }

    public ZipDataFormat(int compressionLevel) {
        this.compressionLevel = compressionLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void marshal(Exchange exchange, Object graph, OutputStream stream) throws Exception {
        InputStream is = exchange.getContext().getTypeConverter().mandatoryConvertTo(InputStream.class, graph);
        DeflaterOutputStream zipOutput = new DeflaterOutputStream(stream, new Deflater(this.compressionLevel));
        try {
            IOHelper.copy(is, zipOutput);
        }
        catch (Throwable throwable) {
            IOHelper.close(is, zipOutput);
            throw throwable;
        }
        IOHelper.close(is, zipOutput);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object unmarshal(Exchange exchange, InputStream stream) throws Exception {
        InputStream is = exchange.getIn().getMandatoryBody(InputStream.class);
        InflaterInputStream unzipInput = new InflaterInputStream(is);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            IOHelper.copy(unzipInput, bos);
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        finally {
            IOHelper.close((Closeable)unzipInput);
        }
    }
}

