/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.engine.impl;

import java.util.Iterator;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.Receiver;
import org.apache.qpid.proton.engine.impl.DeliveryImpl;
import org.apache.qpid.proton.engine.impl.LinkImpl;
import org.apache.qpid.proton.engine.impl.SessionImpl;
import org.apache.qpid.proton.engine.impl.TransportReceiver;

public class ReceiverImpl
extends LinkImpl
implements Receiver {
    private TransportReceiver _transportReceiver;
    private int _unsentCredits;

    @Override
    public boolean advance() {
        boolean advance;
        if (this.current() != null) {
            this.current().setDone();
        }
        if (advance = super.advance()) {
            this.decrementQueued();
            this.decrementCredit();
        }
        return advance;
    }

    public ReceiverImpl(SessionImpl session, String name) {
        super(session, name);
    }

    public void flow(int credits) {
        this.modified();
        this.addCredit(credits);
        this.setDrain(false);
        this._unsentCredits += credits;
    }

    int clearUnsentCredits() {
        int credits = this._unsentCredits;
        this._unsentCredits = 0;
        return credits;
    }

    public int recv(byte[] bytes, int offset, int size) {
        return this._current.recv(bytes, offset, size);
    }

    public Iterator<Delivery> unsettled() {
        return null;
    }

    @Override
    public void free() {
        this.getSession().freeReceiver(this);
        super.free();
    }

    boolean hasIncoming() {
        return false;
    }

    void setTransportLink(TransportReceiver transportReceiver) {
        this._transportReceiver = transportReceiver;
    }

    @Override
    TransportReceiver getTransportLink() {
        return this._transportReceiver;
    }

    @Override
    boolean workUpdate(DeliveryImpl delivery) {
        return delivery == this.current();
    }

    public void drain(int credit) {
        this.flow(credit);
        this.setDrain(true);
    }
}

