/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.Socket;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.activemq.command.Command;
import org.apache.activemq.command.WireFormatInfo;
import org.apache.activemq.openwire.OpenWireFormat;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportFilter;
import org.apache.activemq.util.IOExceptionSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WireFormatNegotiator
extends TransportFilter {
    private static final Logger LOG = LoggerFactory.getLogger(WireFormatNegotiator.class);
    private OpenWireFormat wireFormat;
    private final int minimumVersion;
    private long negotiateTimeout = 15000L;
    private final AtomicBoolean firstStart = new AtomicBoolean(true);
    private final CountDownLatch readyCountDownLatch = new CountDownLatch(1);
    private final CountDownLatch wireInfoSentDownLatch = new CountDownLatch(1);

    public WireFormatNegotiator(Transport next, OpenWireFormat wireFormat, int minimumVersion) {
        super(next);
        this.wireFormat = wireFormat;
        if (minimumVersion <= 0) {
            minimumVersion = 1;
        }
        this.minimumVersion = minimumVersion;
        try {
            if (wireFormat.getPreferedWireFormatInfo() != null) {
                this.setNegotiateTimeout(wireFormat.getPreferedWireFormatInfo().getMaxInactivityDurationInitalDelay());
            }
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    @Override
    public void start() throws Exception {
        super.start();
        if (this.firstStart.compareAndSet(true, false)) {
            this.sendWireFormat();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendWireFormat() throws IOException {
        try {
            WireFormatInfo info2 = this.wireFormat.getPreferedWireFormatInfo();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Sending: " + info2);
            }
            this.sendWireFormat(info2);
        }
        finally {
            this.wireInfoSentDownLatch.countDown();
        }
    }

    @Override
    public void stop() throws Exception {
        super.stop();
        this.readyCountDownLatch.countDown();
    }

    @Override
    public void oneway(Object command) throws IOException {
        try {
            if (!this.readyCountDownLatch.await(this.negotiateTimeout, TimeUnit.MILLISECONDS)) {
                throw new IOException("Wire format negotiation timeout: peer did not send his wire format.");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new InterruptedIOException();
        }
        super.oneway(command);
    }

    @Override
    public void onCommand(Object o) {
        Command command = (Command)o;
        if (command.isWireFormatInfo()) {
            WireFormatInfo info2 = (WireFormatInfo)command;
            this.negociate(info2);
        }
        this.getTransportListener().onCommand(command);
    }

    public void negociate(WireFormatInfo info2) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Received WireFormat: " + info2);
        }
        try {
            this.wireInfoSentDownLatch.await();
            if (LOG.isDebugEnabled()) {
                LOG.debug(this + " before negotiation: " + this.wireFormat);
            }
            if (!info2.isValid()) {
                this.onException(new IOException("Remote wire format magic is invalid"));
            } else if (info2.getVersion() < this.minimumVersion) {
                this.onException(new IOException("Remote wire format (" + info2.getVersion() + ") is lower the minimum version required (" + this.minimumVersion + ")"));
            }
            this.wireFormat.renegotiateWireFormat(info2);
            Socket socket = this.next.narrow(Socket.class);
            if (socket != null) {
                socket.setTcpNoDelay(this.wireFormat.isTcpNoDelayEnabled());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(this + " after negotiation: " + this.wireFormat);
            }
        }
        catch (IOException e) {
            this.onException(e);
        }
        catch (InterruptedException e) {
            this.onException((IOException)new InterruptedIOException().initCause(e));
        }
        catch (Exception e) {
            this.onException(IOExceptionSupport.create(e));
        }
        this.readyCountDownLatch.countDown();
        this.onWireFormatNegotiated(info2);
    }

    @Override
    public void onException(IOException error2) {
        this.readyCountDownLatch.countDown();
        super.onException(error2);
    }

    @Override
    public String toString() {
        return this.next.toString();
    }

    protected void sendWireFormat(WireFormatInfo info2) throws IOException {
        this.next.oneway(info2);
    }

    protected void onWireFormatNegotiated(WireFormatInfo info2) {
    }

    public long getNegotiateTimeout() {
        return this.negotiateTimeout;
    }

    public void setNegotiateTimeout(long negotiateTimeout) {
        this.negotiateTimeout = negotiateTimeout;
    }
}

